/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMobileDeviceAccessOverrideResponse extends WorkMailResponse implements
        ToCopyableBuilder<GetMobileDeviceAccessOverrideResponse.Builder, GetMobileDeviceAccessOverrideResponse> {
    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UserId")
            .getter(getter(GetMobileDeviceAccessOverrideResponse::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()).build();

    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceId").getter(getter(GetMobileDeviceAccessOverrideResponse::deviceId))
            .setter(setter(Builder::deviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").build()).build();

    private static final SdkField<String> EFFECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Effect")
            .getter(getter(GetMobileDeviceAccessOverrideResponse::effectAsString)).setter(setter(Builder::effect))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Effect").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetMobileDeviceAccessOverrideResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> DATE_CREATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DateCreated").getter(getter(GetMobileDeviceAccessOverrideResponse::dateCreated))
            .setter(setter(Builder::dateCreated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateCreated").build()).build();

    private static final SdkField<Instant> DATE_MODIFIED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DateModified").getter(getter(GetMobileDeviceAccessOverrideResponse::dateModified))
            .setter(setter(Builder::dateModified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateModified").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ID_FIELD,
            DEVICE_ID_FIELD, EFFECT_FIELD, DESCRIPTION_FIELD, DATE_CREATED_FIELD, DATE_MODIFIED_FIELD));

    private final String userId;

    private final String deviceId;

    private final String effect;

    private final String description;

    private final Instant dateCreated;

    private final Instant dateModified;

    private GetMobileDeviceAccessOverrideResponse(BuilderImpl builder) {
        super(builder);
        this.userId = builder.userId;
        this.deviceId = builder.deviceId;
        this.effect = builder.effect;
        this.description = builder.description;
        this.dateCreated = builder.dateCreated;
        this.dateModified = builder.dateModified;
    }

    /**
     * <p>
     * The WorkMail user to which the access override applies.
     * </p>
     * 
     * @return The WorkMail user to which the access override applies.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * The device to which the access override applies.
     * </p>
     * 
     * @return The device to which the access override applies.
     */
    public final String deviceId() {
        return deviceId;
    }

    /**
     * <p>
     * The effect of the override, <code>ALLOW</code> or <code>DENY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #effect} will
     * return {@link MobileDeviceAccessRuleEffect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #effectAsString}.
     * </p>
     * 
     * @return The effect of the override, <code>ALLOW</code> or <code>DENY</code>.
     * @see MobileDeviceAccessRuleEffect
     */
    public final MobileDeviceAccessRuleEffect effect() {
        return MobileDeviceAccessRuleEffect.fromValue(effect);
    }

    /**
     * <p>
     * The effect of the override, <code>ALLOW</code> or <code>DENY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #effect} will
     * return {@link MobileDeviceAccessRuleEffect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #effectAsString}.
     * </p>
     * 
     * @return The effect of the override, <code>ALLOW</code> or <code>DENY</code>.
     * @see MobileDeviceAccessRuleEffect
     */
    public final String effectAsString() {
        return effect;
    }

    /**
     * <p>
     * A description of the override.
     * </p>
     * 
     * @return A description of the override.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The date the override was first created.
     * </p>
     * 
     * @return The date the override was first created.
     */
    public final Instant dateCreated() {
        return dateCreated;
    }

    /**
     * <p>
     * The date the description was last modified.
     * </p>
     * 
     * @return The date the description was last modified.
     */
    public final Instant dateModified() {
        return dateModified;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(effectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(dateModified());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMobileDeviceAccessOverrideResponse)) {
            return false;
        }
        GetMobileDeviceAccessOverrideResponse other = (GetMobileDeviceAccessOverrideResponse) obj;
        return Objects.equals(userId(), other.userId()) && Objects.equals(deviceId(), other.deviceId())
                && Objects.equals(effectAsString(), other.effectAsString()) && Objects.equals(description(), other.description())
                && Objects.equals(dateCreated(), other.dateCreated()) && Objects.equals(dateModified(), other.dateModified());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMobileDeviceAccessOverrideResponse").add("UserId", userId()).add("DeviceId", deviceId())
                .add("Effect", effectAsString()).add("Description", description()).add("DateCreated", dateCreated())
                .add("DateModified", dateModified()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "DeviceId":
            return Optional.ofNullable(clazz.cast(deviceId()));
        case "Effect":
            return Optional.ofNullable(clazz.cast(effectAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DateCreated":
            return Optional.ofNullable(clazz.cast(dateCreated()));
        case "DateModified":
            return Optional.ofNullable(clazz.cast(dateModified()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMobileDeviceAccessOverrideResponse, T> g) {
        return obj -> g.apply((GetMobileDeviceAccessOverrideResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkMailResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetMobileDeviceAccessOverrideResponse> {
        /**
         * <p>
         * The WorkMail user to which the access override applies.
         * </p>
         * 
         * @param userId
         *        The WorkMail user to which the access override applies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The device to which the access override applies.
         * </p>
         * 
         * @param deviceId
         *        The device to which the access override applies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceId(String deviceId);

        /**
         * <p>
         * The effect of the override, <code>ALLOW</code> or <code>DENY</code>.
         * </p>
         * 
         * @param effect
         *        The effect of the override, <code>ALLOW</code> or <code>DENY</code>.
         * @see MobileDeviceAccessRuleEffect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MobileDeviceAccessRuleEffect
         */
        Builder effect(String effect);

        /**
         * <p>
         * The effect of the override, <code>ALLOW</code> or <code>DENY</code>.
         * </p>
         * 
         * @param effect
         *        The effect of the override, <code>ALLOW</code> or <code>DENY</code>.
         * @see MobileDeviceAccessRuleEffect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MobileDeviceAccessRuleEffect
         */
        Builder effect(MobileDeviceAccessRuleEffect effect);

        /**
         * <p>
         * A description of the override.
         * </p>
         * 
         * @param description
         *        A description of the override.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The date the override was first created.
         * </p>
         * 
         * @param dateCreated
         *        The date the override was first created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateCreated(Instant dateCreated);

        /**
         * <p>
         * The date the description was last modified.
         * </p>
         * 
         * @param dateModified
         *        The date the description was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateModified(Instant dateModified);
    }

    static final class BuilderImpl extends WorkMailResponse.BuilderImpl implements Builder {
        private String userId;

        private String deviceId;

        private String effect;

        private String description;

        private Instant dateCreated;

        private Instant dateModified;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMobileDeviceAccessOverrideResponse model) {
            super(model);
            userId(model.userId);
            deviceId(model.deviceId);
            effect(model.effect);
            description(model.description);
            dateCreated(model.dateCreated);
            dateModified(model.dateModified);
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getDeviceId() {
            return deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final String getEffect() {
            return effect;
        }

        public final void setEffect(String effect) {
            this.effect = effect;
        }

        @Override
        public final Builder effect(String effect) {
            this.effect = effect;
            return this;
        }

        @Override
        public final Builder effect(MobileDeviceAccessRuleEffect effect) {
            this.effect(effect == null ? null : effect.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getDateCreated() {
            return dateCreated;
        }

        public final void setDateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
        }

        @Override
        public final Builder dateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final Instant getDateModified() {
            return dateModified;
        }

        public final void setDateModified(Instant dateModified) {
            this.dateModified = dateModified;
        }

        @Override
        public final Builder dateModified(Instant dateModified) {
            this.dateModified = dateModified;
            return this;
        }

        @Override
        public GetMobileDeviceAccessOverrideResponse build() {
            return new GetMobileDeviceAccessOverrideResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
