/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutAccessControlRuleRequest extends WorkMailRequest implements
        ToCopyableBuilder<PutAccessControlRuleRequest.Builder, PutAccessControlRuleRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(PutAccessControlRuleRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> EFFECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Effect")
            .getter(getter(PutAccessControlRuleRequest::effectAsString)).setter(setter(Builder::effect))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Effect").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(PutAccessControlRuleRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<String>> IP_RANGES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("IpRanges")
            .getter(getter(PutAccessControlRuleRequest::ipRanges))
            .setter(setter(Builder::ipRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpRanges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NOT_IP_RANGES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NotIpRanges")
            .getter(getter(PutAccessControlRuleRequest::notIpRanges))
            .setter(setter(Builder::notIpRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotIpRanges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Actions")
            .getter(getter(PutAccessControlRuleRequest::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NOT_ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NotActions")
            .getter(getter(PutAccessControlRuleRequest::notActions))
            .setter(setter(Builder::notActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> USER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UserIds")
            .getter(getter(PutAccessControlRuleRequest::userIds))
            .setter(setter(Builder::userIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NOT_USER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NotUserIds")
            .getter(getter(PutAccessControlRuleRequest::notUserIds))
            .setter(setter(Builder::notUserIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotUserIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationId").getter(getter(PutAccessControlRuleRequest::organizationId))
            .setter(setter(Builder::organizationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, EFFECT_FIELD,
            DESCRIPTION_FIELD, IP_RANGES_FIELD, NOT_IP_RANGES_FIELD, ACTIONS_FIELD, NOT_ACTIONS_FIELD, USER_IDS_FIELD,
            NOT_USER_IDS_FIELD, ORGANIZATION_ID_FIELD));

    private final String name;

    private final String effect;

    private final String description;

    private final List<String> ipRanges;

    private final List<String> notIpRanges;

    private final List<String> actions;

    private final List<String> notActions;

    private final List<String> userIds;

    private final List<String> notUserIds;

    private final String organizationId;

    private PutAccessControlRuleRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.effect = builder.effect;
        this.description = builder.description;
        this.ipRanges = builder.ipRanges;
        this.notIpRanges = builder.notIpRanges;
        this.actions = builder.actions;
        this.notActions = builder.notActions;
        this.userIds = builder.userIds;
        this.notUserIds = builder.notUserIds;
        this.organizationId = builder.organizationId;
    }

    /**
     * <p>
     * The rule name.
     * </p>
     * 
     * @return The rule name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The rule effect.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #effect} will
     * return {@link AccessControlRuleEffect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #effectAsString}.
     * </p>
     * 
     * @return The rule effect.
     * @see AccessControlRuleEffect
     */
    public final AccessControlRuleEffect effect() {
        return AccessControlRuleEffect.fromValue(effect);
    }

    /**
     * <p>
     * The rule effect.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #effect} will
     * return {@link AccessControlRuleEffect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #effectAsString}.
     * </p>
     * 
     * @return The rule effect.
     * @see AccessControlRuleEffect
     */
    public final String effectAsString() {
        return effect;
    }

    /**
     * <p>
     * The rule description.
     * </p>
     * 
     * @return The rule description.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the IpRanges property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIpRanges() {
        return ipRanges != null && !(ipRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * IPv4 CIDR ranges to include in the rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpRanges} method.
     * </p>
     * 
     * @return IPv4 CIDR ranges to include in the rule.
     */
    public final List<String> ipRanges() {
        return ipRanges;
    }

    /**
     * For responses, this returns true if the service returned a value for the NotIpRanges property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNotIpRanges() {
        return notIpRanges != null && !(notIpRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * IPv4 CIDR ranges to exclude from the rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotIpRanges} method.
     * </p>
     * 
     * @return IPv4 CIDR ranges to exclude from the rule.
     */
    public final List<String> notIpRanges() {
        return notIpRanges;
    }

    /**
     * For responses, this returns true if the service returned a value for the Actions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Access protocol actions to include in the rule. Valid values include <code>ActiveSync</code>,
     * <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>, <code>WindowsOutlook</code>,
     * and <code>WebMail</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActions} method.
     * </p>
     * 
     * @return Access protocol actions to include in the rule. Valid values include <code>ActiveSync</code>,
     *         <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>,
     *         <code>WindowsOutlook</code>, and <code>WebMail</code>.
     */
    public final List<String> actions() {
        return actions;
    }

    /**
     * For responses, this returns true if the service returned a value for the NotActions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasNotActions() {
        return notActions != null && !(notActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Access protocol actions to exclude from the rule. Valid values include <code>ActiveSync</code>,
     * <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>, <code>WindowsOutlook</code>,
     * and <code>WebMail</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotActions} method.
     * </p>
     * 
     * @return Access protocol actions to exclude from the rule. Valid values include <code>ActiveSync</code>,
     *         <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>,
     *         <code>WindowsOutlook</code>, and <code>WebMail</code>.
     */
    public final List<String> notActions() {
        return notActions;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasUserIds() {
        return userIds != null && !(userIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * User IDs to include in the rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserIds} method.
     * </p>
     * 
     * @return User IDs to include in the rule.
     */
    public final List<String> userIds() {
        return userIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the NotUserIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasNotUserIds() {
        return notUserIds != null && !(notUserIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * User IDs to exclude from the rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotUserIds} method.
     * </p>
     * 
     * @return User IDs to exclude from the rule.
     */
    public final List<String> notUserIds() {
        return notUserIds;
    }

    /**
     * <p>
     * The identifier of the organization.
     * </p>
     * 
     * @return The identifier of the organization.
     */
    public final String organizationId() {
        return organizationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(effectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpRanges() ? ipRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNotIpRanges() ? notIpRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNotActions() ? notActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUserIds() ? userIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNotUserIds() ? notUserIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(organizationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAccessControlRuleRequest)) {
            return false;
        }
        PutAccessControlRuleRequest other = (PutAccessControlRuleRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(effectAsString(), other.effectAsString())
                && Objects.equals(description(), other.description()) && hasIpRanges() == other.hasIpRanges()
                && Objects.equals(ipRanges(), other.ipRanges()) && hasNotIpRanges() == other.hasNotIpRanges()
                && Objects.equals(notIpRanges(), other.notIpRanges()) && hasActions() == other.hasActions()
                && Objects.equals(actions(), other.actions()) && hasNotActions() == other.hasNotActions()
                && Objects.equals(notActions(), other.notActions()) && hasUserIds() == other.hasUserIds()
                && Objects.equals(userIds(), other.userIds()) && hasNotUserIds() == other.hasNotUserIds()
                && Objects.equals(notUserIds(), other.notUserIds()) && Objects.equals(organizationId(), other.organizationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutAccessControlRuleRequest").add("Name", name()).add("Effect", effectAsString())
                .add("Description", description()).add("IpRanges", hasIpRanges() ? ipRanges() : null)
                .add("NotIpRanges", hasNotIpRanges() ? notIpRanges() : null).add("Actions", hasActions() ? actions() : null)
                .add("NotActions", hasNotActions() ? notActions() : null).add("UserIds", hasUserIds() ? userIds() : null)
                .add("NotUserIds", hasNotUserIds() ? notUserIds() : null).add("OrganizationId", organizationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Effect":
            return Optional.ofNullable(clazz.cast(effectAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "IpRanges":
            return Optional.ofNullable(clazz.cast(ipRanges()));
        case "NotIpRanges":
            return Optional.ofNullable(clazz.cast(notIpRanges()));
        case "Actions":
            return Optional.ofNullable(clazz.cast(actions()));
        case "NotActions":
            return Optional.ofNullable(clazz.cast(notActions()));
        case "UserIds":
            return Optional.ofNullable(clazz.cast(userIds()));
        case "NotUserIds":
            return Optional.ofNullable(clazz.cast(notUserIds()));
        case "OrganizationId":
            return Optional.ofNullable(clazz.cast(organizationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutAccessControlRuleRequest, T> g) {
        return obj -> g.apply((PutAccessControlRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkMailRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutAccessControlRuleRequest> {
        /**
         * <p>
         * The rule name.
         * </p>
         * 
         * @param name
         *        The rule name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The rule effect.
         * </p>
         * 
         * @param effect
         *        The rule effect.
         * @see AccessControlRuleEffect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessControlRuleEffect
         */
        Builder effect(String effect);

        /**
         * <p>
         * The rule effect.
         * </p>
         * 
         * @param effect
         *        The rule effect.
         * @see AccessControlRuleEffect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessControlRuleEffect
         */
        Builder effect(AccessControlRuleEffect effect);

        /**
         * <p>
         * The rule description.
         * </p>
         * 
         * @param description
         *        The rule description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * IPv4 CIDR ranges to include in the rule.
         * </p>
         * 
         * @param ipRanges
         *        IPv4 CIDR ranges to include in the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipRanges(Collection<String> ipRanges);

        /**
         * <p>
         * IPv4 CIDR ranges to include in the rule.
         * </p>
         * 
         * @param ipRanges
         *        IPv4 CIDR ranges to include in the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipRanges(String... ipRanges);

        /**
         * <p>
         * IPv4 CIDR ranges to exclude from the rule.
         * </p>
         * 
         * @param notIpRanges
         *        IPv4 CIDR ranges to exclude from the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notIpRanges(Collection<String> notIpRanges);

        /**
         * <p>
         * IPv4 CIDR ranges to exclude from the rule.
         * </p>
         * 
         * @param notIpRanges
         *        IPv4 CIDR ranges to exclude from the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notIpRanges(String... notIpRanges);

        /**
         * <p>
         * Access protocol actions to include in the rule. Valid values include <code>ActiveSync</code>,
         * <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>,
         * <code>WindowsOutlook</code>, and <code>WebMail</code>.
         * </p>
         * 
         * @param actions
         *        Access protocol actions to include in the rule. Valid values include <code>ActiveSync</code>,
         *        <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>,
         *        <code>WindowsOutlook</code>, and <code>WebMail</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<String> actions);

        /**
         * <p>
         * Access protocol actions to include in the rule. Valid values include <code>ActiveSync</code>,
         * <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>,
         * <code>WindowsOutlook</code>, and <code>WebMail</code>.
         * </p>
         * 
         * @param actions
         *        Access protocol actions to include in the rule. Valid values include <code>ActiveSync</code>,
         *        <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>,
         *        <code>WindowsOutlook</code>, and <code>WebMail</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(String... actions);

        /**
         * <p>
         * Access protocol actions to exclude from the rule. Valid values include <code>ActiveSync</code>,
         * <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>,
         * <code>WindowsOutlook</code>, and <code>WebMail</code>.
         * </p>
         * 
         * @param notActions
         *        Access protocol actions to exclude from the rule. Valid values include <code>ActiveSync</code>,
         *        <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>,
         *        <code>WindowsOutlook</code>, and <code>WebMail</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notActions(Collection<String> notActions);

        /**
         * <p>
         * Access protocol actions to exclude from the rule. Valid values include <code>ActiveSync</code>,
         * <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>,
         * <code>WindowsOutlook</code>, and <code>WebMail</code>.
         * </p>
         * 
         * @param notActions
         *        Access protocol actions to exclude from the rule. Valid values include <code>ActiveSync</code>,
         *        <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>,
         *        <code>WindowsOutlook</code>, and <code>WebMail</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notActions(String... notActions);

        /**
         * <p>
         * User IDs to include in the rule.
         * </p>
         * 
         * @param userIds
         *        User IDs to include in the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIds(Collection<String> userIds);

        /**
         * <p>
         * User IDs to include in the rule.
         * </p>
         * 
         * @param userIds
         *        User IDs to include in the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIds(String... userIds);

        /**
         * <p>
         * User IDs to exclude from the rule.
         * </p>
         * 
         * @param notUserIds
         *        User IDs to exclude from the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notUserIds(Collection<String> notUserIds);

        /**
         * <p>
         * User IDs to exclude from the rule.
         * </p>
         * 
         * @param notUserIds
         *        User IDs to exclude from the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notUserIds(String... notUserIds);

        /**
         * <p>
         * The identifier of the organization.
         * </p>
         * 
         * @param organizationId
         *        The identifier of the organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationId(String organizationId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkMailRequest.BuilderImpl implements Builder {
        private String name;

        private String effect;

        private String description;

        private List<String> ipRanges = DefaultSdkAutoConstructList.getInstance();

        private List<String> notIpRanges = DefaultSdkAutoConstructList.getInstance();

        private List<String> actions = DefaultSdkAutoConstructList.getInstance();

        private List<String> notActions = DefaultSdkAutoConstructList.getInstance();

        private List<String> userIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> notUserIds = DefaultSdkAutoConstructList.getInstance();

        private String organizationId;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAccessControlRuleRequest model) {
            super(model);
            name(model.name);
            effect(model.effect);
            description(model.description);
            ipRanges(model.ipRanges);
            notIpRanges(model.notIpRanges);
            actions(model.actions);
            notActions(model.notActions);
            userIds(model.userIds);
            notUserIds(model.notUserIds);
            organizationId(model.organizationId);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getEffect() {
            return effect;
        }

        public final void setEffect(String effect) {
            this.effect = effect;
        }

        @Override
        @Transient
        public final Builder effect(String effect) {
            this.effect = effect;
            return this;
        }

        @Override
        @Transient
        public final Builder effect(AccessControlRuleEffect effect) {
            this.effect(effect == null ? null : effect.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getIpRanges() {
            if (ipRanges instanceof SdkAutoConstructList) {
                return null;
            }
            return ipRanges;
        }

        public final void setIpRanges(Collection<String> ipRanges) {
            this.ipRanges = IpRangeListCopier.copy(ipRanges);
        }

        @Override
        @Transient
        public final Builder ipRanges(Collection<String> ipRanges) {
            this.ipRanges = IpRangeListCopier.copy(ipRanges);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ipRanges(String... ipRanges) {
            ipRanges(Arrays.asList(ipRanges));
            return this;
        }

        public final Collection<String> getNotIpRanges() {
            if (notIpRanges instanceof SdkAutoConstructList) {
                return null;
            }
            return notIpRanges;
        }

        public final void setNotIpRanges(Collection<String> notIpRanges) {
            this.notIpRanges = IpRangeListCopier.copy(notIpRanges);
        }

        @Override
        @Transient
        public final Builder notIpRanges(Collection<String> notIpRanges) {
            this.notIpRanges = IpRangeListCopier.copy(notIpRanges);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder notIpRanges(String... notIpRanges) {
            notIpRanges(Arrays.asList(notIpRanges));
            return this;
        }

        public final Collection<String> getActions() {
            if (actions instanceof SdkAutoConstructList) {
                return null;
            }
            return actions;
        }

        public final void setActions(Collection<String> actions) {
            this.actions = ActionsListCopier.copy(actions);
        }

        @Override
        @Transient
        public final Builder actions(Collection<String> actions) {
            this.actions = ActionsListCopier.copy(actions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder actions(String... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        public final Collection<String> getNotActions() {
            if (notActions instanceof SdkAutoConstructList) {
                return null;
            }
            return notActions;
        }

        public final void setNotActions(Collection<String> notActions) {
            this.notActions = ActionsListCopier.copy(notActions);
        }

        @Override
        @Transient
        public final Builder notActions(Collection<String> notActions) {
            this.notActions = ActionsListCopier.copy(notActions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder notActions(String... notActions) {
            notActions(Arrays.asList(notActions));
            return this;
        }

        public final Collection<String> getUserIds() {
            if (userIds instanceof SdkAutoConstructList) {
                return null;
            }
            return userIds;
        }

        public final void setUserIds(Collection<String> userIds) {
            this.userIds = UserIdListCopier.copy(userIds);
        }

        @Override
        @Transient
        public final Builder userIds(Collection<String> userIds) {
            this.userIds = UserIdListCopier.copy(userIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder userIds(String... userIds) {
            userIds(Arrays.asList(userIds));
            return this;
        }

        public final Collection<String> getNotUserIds() {
            if (notUserIds instanceof SdkAutoConstructList) {
                return null;
            }
            return notUserIds;
        }

        public final void setNotUserIds(Collection<String> notUserIds) {
            this.notUserIds = UserIdListCopier.copy(notUserIds);
        }

        @Override
        @Transient
        public final Builder notUserIds(Collection<String> notUserIds) {
            this.notUserIds = UserIdListCopier.copy(notUserIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder notUserIds(String... notUserIds) {
            notUserIds(Arrays.asList(notUserIds));
            return this;
        }

        public final String getOrganizationId() {
            return organizationId;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        @Transient
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAccessControlRuleRequest build() {
            return new PutAccessControlRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
