/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The representation of an Amazon WorkMail group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Group implements SdkPojo, Serializable, ToCopyableBuilder<Group.Builder, Group> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(Group::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Email")
            .getter(getter(Group::email)).setter(setter(Builder::email))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Group::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(Group::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Instant> ENABLED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EnabledDate").getter(getter(Group::enabledDate)).setter(setter(Builder::enabledDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledDate").build()).build();

    private static final SdkField<Instant> DISABLED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DisabledDate").getter(getter(Group::disabledDate)).setter(setter(Builder::disabledDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisabledDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, EMAIL_FIELD,
            NAME_FIELD, STATE_FIELD, ENABLED_DATE_FIELD, DISABLED_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String email;

    private final String name;

    private final String state;

    private final Instant enabledDate;

    private final Instant disabledDate;

    private Group(BuilderImpl builder) {
        this.id = builder.id;
        this.email = builder.email;
        this.name = builder.name;
        this.state = builder.state;
        this.enabledDate = builder.enabledDate;
        this.disabledDate = builder.disabledDate;
    }

    /**
     * <p>
     * The identifier of the group.
     * </p>
     * 
     * @return The identifier of the group.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The email of the group.
     * </p>
     * 
     * @return The email of the group.
     */
    public final String email() {
        return email;
    }

    /**
     * <p>
     * The name of the group.
     * </p>
     * 
     * @return The name of the group.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The state of the group, which can be ENABLED, DISABLED, or DELETED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link EntityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the group, which can be ENABLED, DISABLED, or DELETED.
     * @see EntityState
     */
    public final EntityState state() {
        return EntityState.fromValue(state);
    }

    /**
     * <p>
     * The state of the group, which can be ENABLED, DISABLED, or DELETED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link EntityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the group, which can be ENABLED, DISABLED, or DELETED.
     * @see EntityState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The date indicating when the group was enabled for Amazon WorkMail use.
     * </p>
     * 
     * @return The date indicating when the group was enabled for Amazon WorkMail use.
     */
    public final Instant enabledDate() {
        return enabledDate;
    }

    /**
     * <p>
     * The date indicating when the group was disabled from Amazon WorkMail use.
     * </p>
     * 
     * @return The date indicating when the group was disabled from Amazon WorkMail use.
     */
    public final Instant disabledDate() {
        return disabledDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(email());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enabledDate());
        hashCode = 31 * hashCode + Objects.hashCode(disabledDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Group)) {
            return false;
        }
        Group other = (Group) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(email(), other.email()) && Objects.equals(name(), other.name())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(enabledDate(), other.enabledDate())
                && Objects.equals(disabledDate(), other.disabledDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Group").add("Id", id()).add("Email", email()).add("Name", name()).add("State", stateAsString())
                .add("EnabledDate", enabledDate()).add("DisabledDate", disabledDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Email":
            return Optional.ofNullable(clazz.cast(email()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "EnabledDate":
            return Optional.ofNullable(clazz.cast(enabledDate()));
        case "DisabledDate":
            return Optional.ofNullable(clazz.cast(disabledDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Group, T> g) {
        return obj -> g.apply((Group) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Group> {
        /**
         * <p>
         * The identifier of the group.
         * </p>
         * 
         * @param id
         *        The identifier of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The email of the group.
         * </p>
         * 
         * @param email
         *        The email of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(String email);

        /**
         * <p>
         * The name of the group.
         * </p>
         * 
         * @param name
         *        The name of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The state of the group, which can be ENABLED, DISABLED, or DELETED.
         * </p>
         * 
         * @param state
         *        The state of the group, which can be ENABLED, DISABLED, or DELETED.
         * @see EntityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the group, which can be ENABLED, DISABLED, or DELETED.
         * </p>
         * 
         * @param state
         *        The state of the group, which can be ENABLED, DISABLED, or DELETED.
         * @see EntityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityState
         */
        Builder state(EntityState state);

        /**
         * <p>
         * The date indicating when the group was enabled for Amazon WorkMail use.
         * </p>
         * 
         * @param enabledDate
         *        The date indicating when the group was enabled for Amazon WorkMail use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledDate(Instant enabledDate);

        /**
         * <p>
         * The date indicating when the group was disabled from Amazon WorkMail use.
         * </p>
         * 
         * @param disabledDate
         *        The date indicating when the group was disabled from Amazon WorkMail use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disabledDate(Instant disabledDate);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String email;

        private String name;

        private String state;

        private Instant enabledDate;

        private Instant disabledDate;

        private BuilderImpl() {
        }

        private BuilderImpl(Group model) {
            id(model.id);
            email(model.email);
            name(model.name);
            state(model.state);
            enabledDate(model.enabledDate);
            disabledDate(model.disabledDate);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getEmail() {
            return email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(EntityState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getEnabledDate() {
            return enabledDate;
        }

        public final void setEnabledDate(Instant enabledDate) {
            this.enabledDate = enabledDate;
        }

        @Override
        public final Builder enabledDate(Instant enabledDate) {
            this.enabledDate = enabledDate;
            return this;
        }

        public final Instant getDisabledDate() {
            return disabledDate;
        }

        public final void setDisabledDate(Instant disabledDate) {
            this.disabledDate = disabledDate;
        }

        @Override
        public final Builder disabledDate(Instant disabledDate) {
            this.disabledDate = disabledDate;
            return this;
        }

        @Override
        public Group build() {
            return new Group(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
