/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMobileDeviceAccessEffectResponse extends WorkMailResponse implements
        ToCopyableBuilder<GetMobileDeviceAccessEffectResponse.Builder, GetMobileDeviceAccessEffectResponse> {
    private static final SdkField<String> EFFECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Effect")
            .getter(getter(GetMobileDeviceAccessEffectResponse::effectAsString)).setter(setter(Builder::effect))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Effect").build()).build();

    private static final SdkField<List<MobileDeviceAccessMatchedRule>> MATCHED_RULES_FIELD = SdkField
            .<List<MobileDeviceAccessMatchedRule>> builder(MarshallingType.LIST)
            .memberName("MatchedRules")
            .getter(getter(GetMobileDeviceAccessEffectResponse::matchedRules))
            .setter(setter(Builder::matchedRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchedRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MobileDeviceAccessMatchedRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(MobileDeviceAccessMatchedRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EFFECT_FIELD,
            MATCHED_RULES_FIELD));

    private final String effect;

    private final List<MobileDeviceAccessMatchedRule> matchedRules;

    private GetMobileDeviceAccessEffectResponse(BuilderImpl builder) {
        super(builder);
        this.effect = builder.effect;
        this.matchedRules = builder.matchedRules;
    }

    /**
     * <p>
     * The effect of the simulated access, <code>ALLOW</code> or <code>DENY</code>, after evaluating mobile device
     * access rules in the Amazon WorkMail organization for the simulated user parameters.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #effect} will
     * return {@link MobileDeviceAccessRuleEffect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #effectAsString}.
     * </p>
     * 
     * @return The effect of the simulated access, <code>ALLOW</code> or <code>DENY</code>, after evaluating mobile
     *         device access rules in the Amazon WorkMail organization for the simulated user parameters.
     * @see MobileDeviceAccessRuleEffect
     */
    public final MobileDeviceAccessRuleEffect effect() {
        return MobileDeviceAccessRuleEffect.fromValue(effect);
    }

    /**
     * <p>
     * The effect of the simulated access, <code>ALLOW</code> or <code>DENY</code>, after evaluating mobile device
     * access rules in the Amazon WorkMail organization for the simulated user parameters.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #effect} will
     * return {@link MobileDeviceAccessRuleEffect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #effectAsString}.
     * </p>
     * 
     * @return The effect of the simulated access, <code>ALLOW</code> or <code>DENY</code>, after evaluating mobile
     *         device access rules in the Amazon WorkMail organization for the simulated user parameters.
     * @see MobileDeviceAccessRuleEffect
     */
    public final String effectAsString() {
        return effect;
    }

    /**
     * For responses, this returns true if the service returned a value for the MatchedRules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMatchedRules() {
        return matchedRules != null && !(matchedRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the rules which matched the simulated user input and produced the effect.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMatchedRules} method.
     * </p>
     * 
     * @return A list of the rules which matched the simulated user input and produced the effect.
     */
    public final List<MobileDeviceAccessMatchedRule> matchedRules() {
        return matchedRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(effectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasMatchedRules() ? matchedRules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMobileDeviceAccessEffectResponse)) {
            return false;
        }
        GetMobileDeviceAccessEffectResponse other = (GetMobileDeviceAccessEffectResponse) obj;
        return Objects.equals(effectAsString(), other.effectAsString()) && hasMatchedRules() == other.hasMatchedRules()
                && Objects.equals(matchedRules(), other.matchedRules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMobileDeviceAccessEffectResponse").add("Effect", effectAsString())
                .add("MatchedRules", hasMatchedRules() ? matchedRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Effect":
            return Optional.ofNullable(clazz.cast(effectAsString()));
        case "MatchedRules":
            return Optional.ofNullable(clazz.cast(matchedRules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMobileDeviceAccessEffectResponse, T> g) {
        return obj -> g.apply((GetMobileDeviceAccessEffectResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkMailResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetMobileDeviceAccessEffectResponse> {
        /**
         * <p>
         * The effect of the simulated access, <code>ALLOW</code> or <code>DENY</code>, after evaluating mobile device
         * access rules in the Amazon WorkMail organization for the simulated user parameters.
         * </p>
         * 
         * @param effect
         *        The effect of the simulated access, <code>ALLOW</code> or <code>DENY</code>, after evaluating mobile
         *        device access rules in the Amazon WorkMail organization for the simulated user parameters.
         * @see MobileDeviceAccessRuleEffect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MobileDeviceAccessRuleEffect
         */
        Builder effect(String effect);

        /**
         * <p>
         * The effect of the simulated access, <code>ALLOW</code> or <code>DENY</code>, after evaluating mobile device
         * access rules in the Amazon WorkMail organization for the simulated user parameters.
         * </p>
         * 
         * @param effect
         *        The effect of the simulated access, <code>ALLOW</code> or <code>DENY</code>, after evaluating mobile
         *        device access rules in the Amazon WorkMail organization for the simulated user parameters.
         * @see MobileDeviceAccessRuleEffect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MobileDeviceAccessRuleEffect
         */
        Builder effect(MobileDeviceAccessRuleEffect effect);

        /**
         * <p>
         * A list of the rules which matched the simulated user input and produced the effect.
         * </p>
         * 
         * @param matchedRules
         *        A list of the rules which matched the simulated user input and produced the effect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchedRules(Collection<MobileDeviceAccessMatchedRule> matchedRules);

        /**
         * <p>
         * A list of the rules which matched the simulated user input and produced the effect.
         * </p>
         * 
         * @param matchedRules
         *        A list of the rules which matched the simulated user input and produced the effect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchedRules(MobileDeviceAccessMatchedRule... matchedRules);

        /**
         * <p>
         * A list of the rules which matched the simulated user input and produced the effect.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <MobileDeviceAccessMatchedRule>.Builder} avoiding the need to create one manually via {@link List
         * <MobileDeviceAccessMatchedRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MobileDeviceAccessMatchedRule>.Builder#build()} is called
         * immediately and its result is passed to {@link #matchedRules(List<MobileDeviceAccessMatchedRule>)}.
         * 
         * @param matchedRules
         *        a consumer that will call methods on {@link List<MobileDeviceAccessMatchedRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #matchedRules(List<MobileDeviceAccessMatchedRule>)
         */
        Builder matchedRules(Consumer<MobileDeviceAccessMatchedRule.Builder>... matchedRules);
    }

    static final class BuilderImpl extends WorkMailResponse.BuilderImpl implements Builder {
        private String effect;

        private List<MobileDeviceAccessMatchedRule> matchedRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMobileDeviceAccessEffectResponse model) {
            super(model);
            effect(model.effect);
            matchedRules(model.matchedRules);
        }

        public final String getEffect() {
            return effect;
        }

        public final void setEffect(String effect) {
            this.effect = effect;
        }

        @Override
        public final Builder effect(String effect) {
            this.effect = effect;
            return this;
        }

        @Override
        public final Builder effect(MobileDeviceAccessRuleEffect effect) {
            this.effect(effect == null ? null : effect.toString());
            return this;
        }

        public final List<MobileDeviceAccessMatchedRule.Builder> getMatchedRules() {
            List<MobileDeviceAccessMatchedRule.Builder> result = MobileDeviceAccessMatchedRuleListCopier
                    .copyToBuilder(this.matchedRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMatchedRules(Collection<MobileDeviceAccessMatchedRule.BuilderImpl> matchedRules) {
            this.matchedRules = MobileDeviceAccessMatchedRuleListCopier.copyFromBuilder(matchedRules);
        }

        @Override
        public final Builder matchedRules(Collection<MobileDeviceAccessMatchedRule> matchedRules) {
            this.matchedRules = MobileDeviceAccessMatchedRuleListCopier.copy(matchedRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchedRules(MobileDeviceAccessMatchedRule... matchedRules) {
            matchedRules(Arrays.asList(matchedRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchedRules(Consumer<MobileDeviceAccessMatchedRule.Builder>... matchedRules) {
            matchedRules(Stream.of(matchedRules).map(c -> MobileDeviceAccessMatchedRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetMobileDeviceAccessEffectResponse build() {
            return new GetMobileDeviceAccessEffectResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
