/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workmail.model.AccessControlRuleEffect;
import software.amazon.awssdk.services.workmail.model.AccessControlRuleNameListCopier;
import software.amazon.awssdk.services.workmail.model.WorkMailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAccessControlEffectResponse
extends WorkMailResponse
implements ToCopyableBuilder<Builder, GetAccessControlEffectResponse> {
    private static final SdkField<String> EFFECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Effect").getter(GetAccessControlEffectResponse.getter(GetAccessControlEffectResponse::effectAsString)).setter(GetAccessControlEffectResponse.setter(Builder::effect)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Effect").build()}).build();
    private static final SdkField<List<String>> MATCHED_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MatchedRules").getter(GetAccessControlEffectResponse.getter(GetAccessControlEffectResponse::matchedRules)).setter(GetAccessControlEffectResponse.setter(Builder::matchedRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchedRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EFFECT_FIELD, MATCHED_RULES_FIELD));
    private final String effect;
    private final List<String> matchedRules;

    private GetAccessControlEffectResponse(BuilderImpl builder) {
        super(builder);
        this.effect = builder.effect;
        this.matchedRules = builder.matchedRules;
    }

    public AccessControlRuleEffect effect() {
        return AccessControlRuleEffect.fromValue(this.effect);
    }

    public String effectAsString() {
        return this.effect;
    }

    public boolean hasMatchedRules() {
        return this.matchedRules != null && !(this.matchedRules instanceof SdkAutoConstructList);
    }

    public List<String> matchedRules() {
        return this.matchedRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.effectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMatchedRules() ? this.matchedRules() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccessControlEffectResponse)) {
            return false;
        }
        GetAccessControlEffectResponse other = (GetAccessControlEffectResponse)((Object)obj);
        return Objects.equals(this.effectAsString(), other.effectAsString()) && this.hasMatchedRules() == other.hasMatchedRules() && Objects.equals(this.matchedRules(), other.matchedRules());
    }

    public String toString() {
        return ToString.builder((String)"GetAccessControlEffectResponse").add("Effect", (Object)this.effectAsString()).add("MatchedRules", this.hasMatchedRules() ? this.matchedRules() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Effect": {
                return Optional.ofNullable(clazz.cast(this.effectAsString()));
            }
            case "MatchedRules": {
                return Optional.ofNullable(clazz.cast(this.matchedRules()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAccessControlEffectResponse, T> g) {
        return obj -> g.apply((GetAccessControlEffectResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkMailResponse.BuilderImpl
    implements Builder {
        private String effect;
        private List<String> matchedRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccessControlEffectResponse model) {
            super(model);
            this.effect(model.effect);
            this.matchedRules(model.matchedRules);
        }

        public final String getEffect() {
            return this.effect;
        }

        @Override
        public final Builder effect(String effect) {
            this.effect = effect;
            return this;
        }

        @Override
        public final Builder effect(AccessControlRuleEffect effect) {
            this.effect(effect == null ? null : effect.toString());
            return this;
        }

        public final void setEffect(String effect) {
            this.effect = effect;
        }

        public final Collection<String> getMatchedRules() {
            if (this.matchedRules instanceof SdkAutoConstructList) {
                return null;
            }
            return this.matchedRules;
        }

        @Override
        public final Builder matchedRules(Collection<String> matchedRules) {
            this.matchedRules = AccessControlRuleNameListCopier.copy(matchedRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchedRules(String ... matchedRules) {
            this.matchedRules(Arrays.asList(matchedRules));
            return this;
        }

        public final void setMatchedRules(Collection<String> matchedRules) {
            this.matchedRules = AccessControlRuleNameListCopier.copy(matchedRules);
        }

        @Override
        public GetAccessControlEffectResponse build() {
            return new GetAccessControlEffectResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkMailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAccessControlEffectResponse> {
        public Builder effect(String var1);

        public Builder effect(AccessControlRuleEffect var1);

        public Builder matchedRules(Collection<String> var1);

        public Builder matchedRules(String ... var1);
    }
}

