/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Domain
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Domain> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(Domain.getter(Domain::domainName)).setter(Domain.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostedZoneId").getter(Domain.getter(Domain::hostedZoneId)).setter(Domain.setter(Builder::hostedZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZoneId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, HOSTED_ZONE_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String domainName;
    private final String hostedZoneId;

    private Domain(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.hostedZoneId = builder.hostedZoneId;
    }

    public String domainName() {
        return this.domainName;
    }

    public String hostedZoneId() {
        return this.hostedZoneId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Domain)) {
            return false;
        }
        Domain other = (Domain)obj;
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.hostedZoneId(), other.hostedZoneId());
    }

    public String toString() {
        return ToString.builder((String)"Domain").add("DomainName", (Object)this.domainName()).add("HostedZoneId", (Object)this.hostedZoneId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "HostedZoneId": {
                return Optional.ofNullable(clazz.cast(this.hostedZoneId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Domain, T> g) {
        return obj -> g.apply((Domain)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private String hostedZoneId;

        private BuilderImpl() {
        }

        private BuilderImpl(Domain model) {
            this.domainName(model.domainName);
            this.hostedZoneId(model.hostedZoneId);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public Domain build() {
            return new Domain(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Domain> {
        public Builder domainName(String var1);

        public Builder hostedZoneId(String var1);
    }
}

