/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workmail.model.Domain;
import software.amazon.awssdk.services.workmail.model.DomainsCopier;
import software.amazon.awssdk.services.workmail.model.WorkMailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateOrganizationRequest
extends WorkMailRequest
implements ToCopyableBuilder<Builder, CreateOrganizationRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(CreateOrganizationRequest.getter(CreateOrganizationRequest::directoryId)).setter(CreateOrganizationRequest.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Alias").getter(CreateOrganizationRequest.getter(CreateOrganizationRequest::alias)).setter(CreateOrganizationRequest.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateOrganizationRequest.getter(CreateOrganizationRequest::clientToken)).setter(CreateOrganizationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<Domain>> DOMAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Domains").getter(CreateOrganizationRequest.getter(CreateOrganizationRequest::domains)).setter(CreateOrganizationRequest.setter(Builder::domains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domains").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Domain::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyArn").getter(CreateOrganizationRequest.getter(CreateOrganizationRequest::kmsKeyArn)).setter(CreateOrganizationRequest.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()}).build();
    private static final SdkField<Boolean> ENABLE_INTEROPERABILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableInteroperability").getter(CreateOrganizationRequest.getter(CreateOrganizationRequest::enableInteroperability)).setter(CreateOrganizationRequest.setter(Builder::enableInteroperability)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableInteroperability").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD, ALIAS_FIELD, CLIENT_TOKEN_FIELD, DOMAINS_FIELD, KMS_KEY_ARN_FIELD, ENABLE_INTEROPERABILITY_FIELD));
    private final String directoryId;
    private final String alias;
    private final String clientToken;
    private final List<Domain> domains;
    private final String kmsKeyArn;
    private final Boolean enableInteroperability;

    private CreateOrganizationRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.alias = builder.alias;
        this.clientToken = builder.clientToken;
        this.domains = builder.domains;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.enableInteroperability = builder.enableInteroperability;
    }

    public String directoryId() {
        return this.directoryId;
    }

    public String alias() {
        return this.alias;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public boolean hasDomains() {
        return this.domains != null && !(this.domains instanceof SdkAutoConstructList);
    }

    public List<Domain> domains() {
        return this.domains;
    }

    public String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public Boolean enableInteroperability() {
        return this.enableInteroperability;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDomains() ? this.domains() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableInteroperability());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOrganizationRequest)) {
            return false;
        }
        CreateOrganizationRequest other = (CreateOrganizationRequest)((Object)obj);
        return Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.alias(), other.alias()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasDomains() == other.hasDomains() && Objects.equals(this.domains(), other.domains()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.enableInteroperability(), other.enableInteroperability());
    }

    public String toString() {
        return ToString.builder((String)"CreateOrganizationRequest").add("DirectoryId", (Object)this.directoryId()).add("Alias", (Object)this.alias()).add("ClientToken", (Object)this.clientToken()).add("Domains", this.hasDomains() ? this.domains() : null).add("KmsKeyArn", (Object)this.kmsKeyArn()).add("EnableInteroperability", (Object)this.enableInteroperability()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "Alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Domains": {
                return Optional.ofNullable(clazz.cast(this.domains()));
            }
            case "KmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "EnableInteroperability": {
                return Optional.ofNullable(clazz.cast(this.enableInteroperability()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateOrganizationRequest, T> g) {
        return obj -> g.apply((CreateOrganizationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkMailRequest.BuilderImpl
    implements Builder {
        private String directoryId;
        private String alias;
        private String clientToken;
        private List<Domain> domains = DefaultSdkAutoConstructList.getInstance();
        private String kmsKeyArn;
        private Boolean enableInteroperability;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOrganizationRequest model) {
            super(model);
            this.directoryId(model.directoryId);
            this.alias(model.alias);
            this.clientToken(model.clientToken);
            this.domains(model.domains);
            this.kmsKeyArn(model.kmsKeyArn);
            this.enableInteroperability(model.enableInteroperability);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        public final String getAlias() {
            return this.alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Collection<Domain.Builder> getDomains() {
            if (this.domains instanceof SdkAutoConstructList) {
                return null;
            }
            return this.domains != null ? (Collection)this.domains.stream().map(Domain::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder domains(Collection<Domain> domains) {
            this.domains = DomainsCopier.copy(domains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domains(Domain ... domains) {
            this.domains(Arrays.asList(domains));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domains(Consumer<Domain.Builder> ... domains) {
            this.domains(Stream.of(domains).map(c -> (Domain)((Domain.Builder)Domain.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDomains(Collection<Domain.BuilderImpl> domains) {
            this.domains = DomainsCopier.copyFromBuilder(domains);
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        public final Boolean getEnableInteroperability() {
            return this.enableInteroperability;
        }

        @Override
        public final Builder enableInteroperability(Boolean enableInteroperability) {
            this.enableInteroperability = enableInteroperability;
            return this;
        }

        public final void setEnableInteroperability(Boolean enableInteroperability) {
            this.enableInteroperability = enableInteroperability;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateOrganizationRequest build() {
            return new CreateOrganizationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkMailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateOrganizationRequest> {
        public Builder directoryId(String var1);

        public Builder alias(String var1);

        public Builder clientToken(String var1);

        public Builder domains(Collection<Domain> var1);

        public Builder domains(Domain ... var1);

        public Builder domains(Consumer<Domain.Builder> ... var1);

        public Builder kmsKeyArn(String var1);

        public Builder enableInteroperability(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

