/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAccessControlEffectResponse extends WorkMailResponse implements
        ToCopyableBuilder<GetAccessControlEffectResponse.Builder, GetAccessControlEffectResponse> {
    private static final SdkField<String> EFFECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Effect")
            .getter(getter(GetAccessControlEffectResponse::effectAsString)).setter(setter(Builder::effect))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Effect").build()).build();

    private static final SdkField<List<String>> MATCHED_RULES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MatchedRules")
            .getter(getter(GetAccessControlEffectResponse::matchedRules))
            .setter(setter(Builder::matchedRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchedRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EFFECT_FIELD,
            MATCHED_RULES_FIELD));

    private final String effect;

    private final List<String> matchedRules;

    private GetAccessControlEffectResponse(BuilderImpl builder) {
        super(builder);
        this.effect = builder.effect;
        this.matchedRules = builder.matchedRules;
    }

    /**
     * <p>
     * The rule effect.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #effect} will
     * return {@link AccessControlRuleEffect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #effectAsString}.
     * </p>
     * 
     * @return The rule effect.
     * @see AccessControlRuleEffect
     */
    public AccessControlRuleEffect effect() {
        return AccessControlRuleEffect.fromValue(effect);
    }

    /**
     * <p>
     * The rule effect.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #effect} will
     * return {@link AccessControlRuleEffect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #effectAsString}.
     * </p>
     * 
     * @return The rule effect.
     * @see AccessControlRuleEffect
     */
    public String effectAsString() {
        return effect;
    }

    /**
     * Returns true if the MatchedRules property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasMatchedRules() {
        return matchedRules != null && !(matchedRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The rules that match the given parameters, resulting in an effect.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMatchedRules()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The rules that match the given parameters, resulting in an effect.
     */
    public List<String> matchedRules() {
        return matchedRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(effectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasMatchedRules() ? matchedRules() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccessControlEffectResponse)) {
            return false;
        }
        GetAccessControlEffectResponse other = (GetAccessControlEffectResponse) obj;
        return Objects.equals(effectAsString(), other.effectAsString()) && hasMatchedRules() == other.hasMatchedRules()
                && Objects.equals(matchedRules(), other.matchedRules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetAccessControlEffectResponse").add("Effect", effectAsString())
                .add("MatchedRules", hasMatchedRules() ? matchedRules() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Effect":
            return Optional.ofNullable(clazz.cast(effectAsString()));
        case "MatchedRules":
            return Optional.ofNullable(clazz.cast(matchedRules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAccessControlEffectResponse, T> g) {
        return obj -> g.apply((GetAccessControlEffectResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkMailResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAccessControlEffectResponse> {
        /**
         * <p>
         * The rule effect.
         * </p>
         * 
         * @param effect
         *        The rule effect.
         * @see AccessControlRuleEffect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessControlRuleEffect
         */
        Builder effect(String effect);

        /**
         * <p>
         * The rule effect.
         * </p>
         * 
         * @param effect
         *        The rule effect.
         * @see AccessControlRuleEffect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessControlRuleEffect
         */
        Builder effect(AccessControlRuleEffect effect);

        /**
         * <p>
         * The rules that match the given parameters, resulting in an effect.
         * </p>
         * 
         * @param matchedRules
         *        The rules that match the given parameters, resulting in an effect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchedRules(Collection<String> matchedRules);

        /**
         * <p>
         * The rules that match the given parameters, resulting in an effect.
         * </p>
         * 
         * @param matchedRules
         *        The rules that match the given parameters, resulting in an effect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchedRules(String... matchedRules);
    }

    static final class BuilderImpl extends WorkMailResponse.BuilderImpl implements Builder {
        private String effect;

        private List<String> matchedRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccessControlEffectResponse model) {
            super(model);
            effect(model.effect);
            matchedRules(model.matchedRules);
        }

        public final String getEffect() {
            return effect;
        }

        @Override
        public final Builder effect(String effect) {
            this.effect = effect;
            return this;
        }

        @Override
        public final Builder effect(AccessControlRuleEffect effect) {
            this.effect(effect == null ? null : effect.toString());
            return this;
        }

        public final void setEffect(String effect) {
            this.effect = effect;
        }

        public final Collection<String> getMatchedRules() {
            if (matchedRules instanceof SdkAutoConstructList) {
                return null;
            }
            return matchedRules;
        }

        @Override
        public final Builder matchedRules(Collection<String> matchedRules) {
            this.matchedRules = AccessControlRuleNameListCopier.copy(matchedRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchedRules(String... matchedRules) {
            matchedRules(Arrays.asList(matchedRules));
            return this;
        }

        public final void setMatchedRules(Collection<String> matchedRules) {
            this.matchedRules = AccessControlRuleNameListCopier.copy(matchedRules);
        }

        @Override
        public GetAccessControlEffectResponse build() {
            return new GetAccessControlEffectResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
