/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.worklink.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WebsiteCaSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WebsiteCaSummary> {
    private static final SdkField<String> WEBSITE_CA_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebsiteCaId").getter(WebsiteCaSummary.getter(WebsiteCaSummary::websiteCaId)).setter(WebsiteCaSummary.setter(Builder::websiteCaId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebsiteCaId").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(WebsiteCaSummary.getter(WebsiteCaSummary::createdTime)).setter(WebsiteCaSummary.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(WebsiteCaSummary.getter(WebsiteCaSummary::displayName)).setter(WebsiteCaSummary.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEBSITE_CA_ID_FIELD, CREATED_TIME_FIELD, DISPLAY_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String websiteCaId;
    private final Instant createdTime;
    private final String displayName;

    private WebsiteCaSummary(BuilderImpl builder) {
        this.websiteCaId = builder.websiteCaId;
        this.createdTime = builder.createdTime;
        this.displayName = builder.displayName;
    }

    public final String websiteCaId() {
        return this.websiteCaId;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final String displayName() {
        return this.displayName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.websiteCaId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebsiteCaSummary)) {
            return false;
        }
        WebsiteCaSummary other = (WebsiteCaSummary)obj;
        return Objects.equals(this.websiteCaId(), other.websiteCaId()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.displayName(), other.displayName());
    }

    public final String toString() {
        return ToString.builder((String)"WebsiteCaSummary").add("WebsiteCaId", (Object)this.websiteCaId()).add("CreatedTime", (Object)this.createdTime()).add("DisplayName", (Object)this.displayName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WebsiteCaId": {
                return Optional.ofNullable(clazz.cast(this.websiteCaId()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WebsiteCaSummary, T> g) {
        return obj -> g.apply((WebsiteCaSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String websiteCaId;
        private Instant createdTime;
        private String displayName;

        private BuilderImpl() {
        }

        private BuilderImpl(WebsiteCaSummary model) {
            this.websiteCaId(model.websiteCaId);
            this.createdTime(model.createdTime);
            this.displayName(model.displayName);
        }

        public final String getWebsiteCaId() {
            return this.websiteCaId;
        }

        @Override
        public final Builder websiteCaId(String websiteCaId) {
            this.websiteCaId = websiteCaId;
            return this;
        }

        public final void setWebsiteCaId(String websiteCaId) {
            this.websiteCaId = websiteCaId;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public WebsiteCaSummary build() {
            return new WebsiteCaSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WebsiteCaSummary> {
        public Builder websiteCaId(String var1);

        public Builder createdTime(Instant var1);

        public Builder displayName(String var1);
    }
}

