/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.worklink.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeIdentityProviderConfigurationResponse extends WorkLinkResponse implements
        ToCopyableBuilder<DescribeIdentityProviderConfigurationResponse.Builder, DescribeIdentityProviderConfigurationResponse> {
    private static final SdkField<String> IDENTITY_PROVIDER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityProviderType")
            .getter(getter(DescribeIdentityProviderConfigurationResponse::identityProviderTypeAsString))
            .setter(setter(Builder::identityProviderType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderType").build())
            .build();

    private static final SdkField<String> SERVICE_PROVIDER_SAML_METADATA_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ServiceProviderSamlMetadata")
            .getter(getter(DescribeIdentityProviderConfigurationResponse::serviceProviderSamlMetadata))
            .setter(setter(Builder::serviceProviderSamlMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceProviderSamlMetadata")
                    .build()).build();

    private static final SdkField<String> IDENTITY_PROVIDER_SAML_METADATA_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IdentityProviderSamlMetadata")
            .getter(getter(DescribeIdentityProviderConfigurationResponse::identityProviderSamlMetadata))
            .setter(setter(Builder::identityProviderSamlMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderSamlMetadata")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_PROVIDER_TYPE_FIELD,
            SERVICE_PROVIDER_SAML_METADATA_FIELD, IDENTITY_PROVIDER_SAML_METADATA_FIELD));

    private final String identityProviderType;

    private final String serviceProviderSamlMetadata;

    private final String identityProviderSamlMetadata;

    private DescribeIdentityProviderConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.identityProviderType = builder.identityProviderType;
        this.serviceProviderSamlMetadata = builder.serviceProviderSamlMetadata;
        this.identityProviderSamlMetadata = builder.identityProviderSamlMetadata;
    }

    /**
     * <p>
     * The type of identity provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #identityProviderType} will return {@link IdentityProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #identityProviderTypeAsString}.
     * </p>
     * 
     * @return The type of identity provider.
     * @see IdentityProviderType
     */
    public final IdentityProviderType identityProviderType() {
        return IdentityProviderType.fromValue(identityProviderType);
    }

    /**
     * <p>
     * The type of identity provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #identityProviderType} will return {@link IdentityProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #identityProviderTypeAsString}.
     * </p>
     * 
     * @return The type of identity provider.
     * @see IdentityProviderType
     */
    public final String identityProviderTypeAsString() {
        return identityProviderType;
    }

    /**
     * <p>
     * The SAML metadata document uploaded to the user’s identity provider.
     * </p>
     * 
     * @return The SAML metadata document uploaded to the user’s identity provider.
     */
    public final String serviceProviderSamlMetadata() {
        return serviceProviderSamlMetadata;
    }

    /**
     * <p>
     * The SAML metadata document provided by the user’s identity provider.
     * </p>
     * 
     * @return The SAML metadata document provided by the user’s identity provider.
     */
    public final String identityProviderSamlMetadata() {
        return identityProviderSamlMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serviceProviderSamlMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderSamlMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIdentityProviderConfigurationResponse)) {
            return false;
        }
        DescribeIdentityProviderConfigurationResponse other = (DescribeIdentityProviderConfigurationResponse) obj;
        return Objects.equals(identityProviderTypeAsString(), other.identityProviderTypeAsString())
                && Objects.equals(serviceProviderSamlMetadata(), other.serviceProviderSamlMetadata())
                && Objects.equals(identityProviderSamlMetadata(), other.identityProviderSamlMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeIdentityProviderConfigurationResponse")
                .add("IdentityProviderType", identityProviderTypeAsString())
                .add("ServiceProviderSamlMetadata", serviceProviderSamlMetadata())
                .add("IdentityProviderSamlMetadata", identityProviderSamlMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityProviderType":
            return Optional.ofNullable(clazz.cast(identityProviderTypeAsString()));
        case "ServiceProviderSamlMetadata":
            return Optional.ofNullable(clazz.cast(serviceProviderSamlMetadata()));
        case "IdentityProviderSamlMetadata":
            return Optional.ofNullable(clazz.cast(identityProviderSamlMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeIdentityProviderConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeIdentityProviderConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkLinkResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeIdentityProviderConfigurationResponse> {
        /**
         * <p>
         * The type of identity provider.
         * </p>
         * 
         * @param identityProviderType
         *        The type of identity provider.
         * @see IdentityProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityProviderType
         */
        Builder identityProviderType(String identityProviderType);

        /**
         * <p>
         * The type of identity provider.
         * </p>
         * 
         * @param identityProviderType
         *        The type of identity provider.
         * @see IdentityProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityProviderType
         */
        Builder identityProviderType(IdentityProviderType identityProviderType);

        /**
         * <p>
         * The SAML metadata document uploaded to the user’s identity provider.
         * </p>
         * 
         * @param serviceProviderSamlMetadata
         *        The SAML metadata document uploaded to the user’s identity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceProviderSamlMetadata(String serviceProviderSamlMetadata);

        /**
         * <p>
         * The SAML metadata document provided by the user’s identity provider.
         * </p>
         * 
         * @param identityProviderSamlMetadata
         *        The SAML metadata document provided by the user’s identity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderSamlMetadata(String identityProviderSamlMetadata);
    }

    static final class BuilderImpl extends WorkLinkResponse.BuilderImpl implements Builder {
        private String identityProviderType;

        private String serviceProviderSamlMetadata;

        private String identityProviderSamlMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIdentityProviderConfigurationResponse model) {
            super(model);
            identityProviderType(model.identityProviderType);
            serviceProviderSamlMetadata(model.serviceProviderSamlMetadata);
            identityProviderSamlMetadata(model.identityProviderSamlMetadata);
        }

        public final String getIdentityProviderType() {
            return identityProviderType;
        }

        @Override
        public final Builder identityProviderType(String identityProviderType) {
            this.identityProviderType = identityProviderType;
            return this;
        }

        @Override
        public final Builder identityProviderType(IdentityProviderType identityProviderType) {
            this.identityProviderType(identityProviderType == null ? null : identityProviderType.toString());
            return this;
        }

        public final void setIdentityProviderType(String identityProviderType) {
            this.identityProviderType = identityProviderType;
        }

        public final String getServiceProviderSamlMetadata() {
            return serviceProviderSamlMetadata;
        }

        @Override
        public final Builder serviceProviderSamlMetadata(String serviceProviderSamlMetadata) {
            this.serviceProviderSamlMetadata = serviceProviderSamlMetadata;
            return this;
        }

        public final void setServiceProviderSamlMetadata(String serviceProviderSamlMetadata) {
            this.serviceProviderSamlMetadata = serviceProviderSamlMetadata;
        }

        public final String getIdentityProviderSamlMetadata() {
            return identityProviderSamlMetadata;
        }

        @Override
        public final Builder identityProviderSamlMetadata(String identityProviderSamlMetadata) {
            this.identityProviderSamlMetadata = identityProviderSamlMetadata;
            return this;
        }

        public final void setIdentityProviderSamlMetadata(String identityProviderSamlMetadata) {
            this.identityProviderSamlMetadata = identityProviderSamlMetadata;
        }

        @Override
        public DescribeIdentityProviderConfigurationResponse build() {
            return new DescribeIdentityProviderConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
