/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchResourcesRequest extends WorkDocsRequest implements
        ToCopyableBuilder<SearchResourcesRequest.Builder, SearchResourcesRequest> {
    private static final SdkField<String> AUTHENTICATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationToken").getter(getter(SearchResourcesRequest::authenticationToken))
            .setter(setter(Builder::authenticationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Authentication").build()).build();

    private static final SdkField<String> QUERY_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryText").getter(getter(SearchResourcesRequest::queryText)).setter(setter(Builder::queryText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryText").build()).build();

    private static final SdkField<List<String>> QUERY_SCOPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("QueryScopes")
            .getter(getter(SearchResourcesRequest::queryScopesAsStrings))
            .setter(setter(Builder::queryScopesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryScopes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationId").getter(getter(SearchResourcesRequest::organizationId))
            .setter(setter(Builder::organizationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()).build();

    private static final SdkField<List<String>> ADDITIONAL_RESPONSE_FIELDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AdditionalResponseFields")
            .getter(getter(SearchResourcesRequest::additionalResponseFieldsAsStrings))
            .setter(setter(Builder::additionalResponseFieldsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalResponseFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Filters> FILTERS_FIELD = SdkField.<Filters> builder(MarshallingType.SDK_POJO)
            .memberName("Filters").getter(getter(SearchResourcesRequest::filters)).setter(setter(Builder::filters))
            .constructor(Filters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()).build();

    private static final SdkField<List<SearchSortResult>> ORDER_BY_FIELD = SdkField
            .<List<SearchSortResult>> builder(MarshallingType.LIST)
            .memberName("OrderBy")
            .getter(getter(SearchResourcesRequest::orderBy))
            .setter(setter(Builder::orderBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderBy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SearchSortResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(SearchSortResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(SearchResourcesRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(SearchResourcesRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TOKEN_FIELD,
            QUERY_TEXT_FIELD, QUERY_SCOPES_FIELD, ORGANIZATION_ID_FIELD, ADDITIONAL_RESPONSE_FIELDS_FIELD, FILTERS_FIELD,
            ORDER_BY_FIELD, LIMIT_FIELD, MARKER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String authenticationToken;

    private final String queryText;

    private final List<String> queryScopes;

    private final String organizationId;

    private final List<String> additionalResponseFields;

    private final Filters filters;

    private final List<SearchSortResult> orderBy;

    private final Integer limit;

    private final String marker;

    private SearchResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationToken = builder.authenticationToken;
        this.queryText = builder.queryText;
        this.queryScopes = builder.queryScopes;
        this.organizationId = builder.organizationId;
        this.additionalResponseFields = builder.additionalResponseFields;
        this.filters = builder.filters;
        this.orderBy = builder.orderBy;
        this.limit = builder.limit;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * Amazon WorkDocs authentication token. Not required when using Amazon Web Services administrator credentials to
     * access the API.
     * </p>
     * 
     * @return Amazon WorkDocs authentication token. Not required when using Amazon Web Services administrator
     *         credentials to access the API.
     */
    public final String authenticationToken() {
        return authenticationToken;
    }

    /**
     * <p>
     * The String to search for. Searches across different text fields based on request parameters. Use double quotes
     * around the query string for exact phrase matches.
     * </p>
     * 
     * @return The String to search for. Searches across different text fields based on request parameters. Use double
     *         quotes around the query string for exact phrase matches.
     */
    public final String queryText() {
        return queryText;
    }

    /**
     * <p>
     * Filter based on the text field type. A Folder has only a name and no content. A Comment has only content and no
     * name. A Document or Document Version has a name and content
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQueryScopes} method.
     * </p>
     * 
     * @return Filter based on the text field type. A Folder has only a name and no content. A Comment has only content
     *         and no name. A Document or Document Version has a name and content
     */
    public final List<SearchQueryScopeType> queryScopes() {
        return SearchQueryScopeTypeListCopier.copyStringToEnum(queryScopes);
    }

    /**
     * For responses, this returns true if the service returned a value for the QueryScopes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasQueryScopes() {
        return queryScopes != null && !(queryScopes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter based on the text field type. A Folder has only a name and no content. A Comment has only content and no
     * name. A Document or Document Version has a name and content
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQueryScopes} method.
     * </p>
     * 
     * @return Filter based on the text field type. A Folder has only a name and no content. A Comment has only content
     *         and no name. A Document or Document Version has a name and content
     */
    public final List<String> queryScopesAsStrings() {
        return queryScopes;
    }

    /**
     * <p>
     * Filters based on the resource owner OrgId. This is a mandatory parameter when using Admin SigV4 credentials.
     * </p>
     * 
     * @return Filters based on the resource owner OrgId. This is a mandatory parameter when using Admin SigV4
     *         credentials.
     */
    public final String organizationId() {
        return organizationId;
    }

    /**
     * <p>
     * A list of attributes to include in the response. Used to request fields that are not normally returned in a
     * standard response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalResponseFields} method.
     * </p>
     * 
     * @return A list of attributes to include in the response. Used to request fields that are not normally returned in
     *         a standard response.
     */
    public final List<AdditionalResponseFieldType> additionalResponseFields() {
        return AdditionalResponseFieldsListCopier.copyStringToEnum(additionalResponseFields);
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalResponseFields property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdditionalResponseFields() {
        return additionalResponseFields != null && !(additionalResponseFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of attributes to include in the response. Used to request fields that are not normally returned in a
     * standard response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalResponseFields} method.
     * </p>
     * 
     * @return A list of attributes to include in the response. Used to request fields that are not normally returned in
     *         a standard response.
     */
    public final List<String> additionalResponseFieldsAsStrings() {
        return additionalResponseFields;
    }

    /**
     * <p>
     * Filters results based on entity metadata.
     * </p>
     * 
     * @return Filters results based on entity metadata.
     */
    public final Filters filters() {
        return filters;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrderBy property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOrderBy() {
        return orderBy != null && !(orderBy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Order by results in one or more categories.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrderBy} method.
     * </p>
     * 
     * @return Order by results in one or more categories.
     */
    public final List<SearchSortResult> orderBy() {
        return orderBy;
    }

    /**
     * <p>
     * Max results count per page.
     * </p>
     * 
     * @return Max results count per page.
     */
    public final Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The marker for the next set of results.
     * </p>
     * 
     * @return The marker for the next set of results.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(queryText());
        hashCode = 31 * hashCode + Objects.hashCode(hasQueryScopes() ? queryScopesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalResponseFields() ? additionalResponseFieldsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(hasOrderBy() ? orderBy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchResourcesRequest)) {
            return false;
        }
        SearchResourcesRequest other = (SearchResourcesRequest) obj;
        return Objects.equals(authenticationToken(), other.authenticationToken())
                && Objects.equals(queryText(), other.queryText()) && hasQueryScopes() == other.hasQueryScopes()
                && Objects.equals(queryScopesAsStrings(), other.queryScopesAsStrings())
                && Objects.equals(organizationId(), other.organizationId())
                && hasAdditionalResponseFields() == other.hasAdditionalResponseFields()
                && Objects.equals(additionalResponseFieldsAsStrings(), other.additionalResponseFieldsAsStrings())
                && Objects.equals(filters(), other.filters()) && hasOrderBy() == other.hasOrderBy()
                && Objects.equals(orderBy(), other.orderBy()) && Objects.equals(limit(), other.limit())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchResourcesRequest")
                .add("AuthenticationToken", authenticationToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("QueryText", queryText() == null ? null : "*** Sensitive Data Redacted ***")
                .add("QueryScopes", hasQueryScopes() ? queryScopesAsStrings() : null).add("OrganizationId", organizationId())
                .add("AdditionalResponseFields", hasAdditionalResponseFields() ? additionalResponseFieldsAsStrings() : null)
                .add("Filters", filters()).add("OrderBy", hasOrderBy() ? orderBy() : null).add("Limit", limit())
                .add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthenticationToken":
            return Optional.ofNullable(clazz.cast(authenticationToken()));
        case "QueryText":
            return Optional.ofNullable(clazz.cast(queryText()));
        case "QueryScopes":
            return Optional.ofNullable(clazz.cast(queryScopesAsStrings()));
        case "OrganizationId":
            return Optional.ofNullable(clazz.cast(organizationId()));
        case "AdditionalResponseFields":
            return Optional.ofNullable(clazz.cast(additionalResponseFieldsAsStrings()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "OrderBy":
            return Optional.ofNullable(clazz.cast(orderBy()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Authentication", AUTHENTICATION_TOKEN_FIELD);
        map.put("QueryText", QUERY_TEXT_FIELD);
        map.put("QueryScopes", QUERY_SCOPES_FIELD);
        map.put("OrganizationId", ORGANIZATION_ID_FIELD);
        map.put("AdditionalResponseFields", ADDITIONAL_RESPONSE_FIELDS_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("OrderBy", ORDER_BY_FIELD);
        map.put("Limit", LIMIT_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchResourcesRequest, T> g) {
        return obj -> g.apply((SearchResourcesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkDocsRequest.Builder, SdkPojo, CopyableBuilder<Builder, SearchResourcesRequest> {
        /**
         * <p>
         * Amazon WorkDocs authentication token. Not required when using Amazon Web Services administrator credentials
         * to access the API.
         * </p>
         * 
         * @param authenticationToken
         *        Amazon WorkDocs authentication token. Not required when using Amazon Web Services administrator
         *        credentials to access the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationToken(String authenticationToken);

        /**
         * <p>
         * The String to search for. Searches across different text fields based on request parameters. Use double
         * quotes around the query string for exact phrase matches.
         * </p>
         * 
         * @param queryText
         *        The String to search for. Searches across different text fields based on request parameters. Use
         *        double quotes around the query string for exact phrase matches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryText(String queryText);

        /**
         * <p>
         * Filter based on the text field type. A Folder has only a name and no content. A Comment has only content and
         * no name. A Document or Document Version has a name and content
         * </p>
         * 
         * @param queryScopes
         *        Filter based on the text field type. A Folder has only a name and no content. A Comment has only
         *        content and no name. A Document or Document Version has a name and content
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryScopesWithStrings(Collection<String> queryScopes);

        /**
         * <p>
         * Filter based on the text field type. A Folder has only a name and no content. A Comment has only content and
         * no name. A Document or Document Version has a name and content
         * </p>
         * 
         * @param queryScopes
         *        Filter based on the text field type. A Folder has only a name and no content. A Comment has only
         *        content and no name. A Document or Document Version has a name and content
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryScopesWithStrings(String... queryScopes);

        /**
         * <p>
         * Filter based on the text field type. A Folder has only a name and no content. A Comment has only content and
         * no name. A Document or Document Version has a name and content
         * </p>
         * 
         * @param queryScopes
         *        Filter based on the text field type. A Folder has only a name and no content. A Comment has only
         *        content and no name. A Document or Document Version has a name and content
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryScopes(Collection<SearchQueryScopeType> queryScopes);

        /**
         * <p>
         * Filter based on the text field type. A Folder has only a name and no content. A Comment has only content and
         * no name. A Document or Document Version has a name and content
         * </p>
         * 
         * @param queryScopes
         *        Filter based on the text field type. A Folder has only a name and no content. A Comment has only
         *        content and no name. A Document or Document Version has a name and content
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryScopes(SearchQueryScopeType... queryScopes);

        /**
         * <p>
         * Filters based on the resource owner OrgId. This is a mandatory parameter when using Admin SigV4 credentials.
         * </p>
         * 
         * @param organizationId
         *        Filters based on the resource owner OrgId. This is a mandatory parameter when using Admin SigV4
         *        credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationId(String organizationId);

        /**
         * <p>
         * A list of attributes to include in the response. Used to request fields that are not normally returned in a
         * standard response.
         * </p>
         * 
         * @param additionalResponseFields
         *        A list of attributes to include in the response. Used to request fields that are not normally returned
         *        in a standard response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalResponseFieldsWithStrings(Collection<String> additionalResponseFields);

        /**
         * <p>
         * A list of attributes to include in the response. Used to request fields that are not normally returned in a
         * standard response.
         * </p>
         * 
         * @param additionalResponseFields
         *        A list of attributes to include in the response. Used to request fields that are not normally returned
         *        in a standard response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalResponseFieldsWithStrings(String... additionalResponseFields);

        /**
         * <p>
         * A list of attributes to include in the response. Used to request fields that are not normally returned in a
         * standard response.
         * </p>
         * 
         * @param additionalResponseFields
         *        A list of attributes to include in the response. Used to request fields that are not normally returned
         *        in a standard response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalResponseFields(Collection<AdditionalResponseFieldType> additionalResponseFields);

        /**
         * <p>
         * A list of attributes to include in the response. Used to request fields that are not normally returned in a
         * standard response.
         * </p>
         * 
         * @param additionalResponseFields
         *        A list of attributes to include in the response. Used to request fields that are not normally returned
         *        in a standard response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalResponseFields(AdditionalResponseFieldType... additionalResponseFields);

        /**
         * <p>
         * Filters results based on entity metadata.
         * </p>
         * 
         * @param filters
         *        Filters results based on entity metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filters filters);

        /**
         * <p>
         * Filters results based on entity metadata.
         * </p>
         * This is a convenience method that creates an instance of the {@link Filters.Builder} avoiding the need to
         * create one manually via {@link Filters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Filters.Builder#build()} is called immediately and its result is
         * passed to {@link #filters(Filters)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link Filters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(Filters)
         */
        default Builder filters(Consumer<Filters.Builder> filters) {
            return filters(Filters.builder().applyMutation(filters).build());
        }

        /**
         * <p>
         * Order by results in one or more categories.
         * </p>
         * 
         * @param orderBy
         *        Order by results in one or more categories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderBy(Collection<SearchSortResult> orderBy);

        /**
         * <p>
         * Order by results in one or more categories.
         * </p>
         * 
         * @param orderBy
         *        Order by results in one or more categories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderBy(SearchSortResult... orderBy);

        /**
         * <p>
         * Order by results in one or more categories.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workdocs.model.SearchSortResult.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.workdocs.model.SearchSortResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workdocs.model.SearchSortResult.Builder#build()} is called immediately
         * and its result is passed to {@link #orderBy(List<SearchSortResult>)}.
         * 
         * @param orderBy
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workdocs.model.SearchSortResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orderBy(java.util.Collection<SearchSortResult>)
         */
        Builder orderBy(Consumer<SearchSortResult.Builder>... orderBy);

        /**
         * <p>
         * Max results count per page.
         * </p>
         * 
         * @param limit
         *        Max results count per page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The marker for the next set of results.
         * </p>
         * 
         * @param marker
         *        The marker for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkDocsRequest.BuilderImpl implements Builder {
        private String authenticationToken;

        private String queryText;

        private List<String> queryScopes = DefaultSdkAutoConstructList.getInstance();

        private String organizationId;

        private List<String> additionalResponseFields = DefaultSdkAutoConstructList.getInstance();

        private Filters filters;

        private List<SearchSortResult> orderBy = DefaultSdkAutoConstructList.getInstance();

        private Integer limit;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchResourcesRequest model) {
            super(model);
            authenticationToken(model.authenticationToken);
            queryText(model.queryText);
            queryScopesWithStrings(model.queryScopes);
            organizationId(model.organizationId);
            additionalResponseFieldsWithStrings(model.additionalResponseFields);
            filters(model.filters);
            orderBy(model.orderBy);
            limit(model.limit);
            marker(model.marker);
        }

        public final String getAuthenticationToken() {
            return authenticationToken;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final String getQueryText() {
            return queryText;
        }

        public final void setQueryText(String queryText) {
            this.queryText = queryText;
        }

        @Override
        public final Builder queryText(String queryText) {
            this.queryText = queryText;
            return this;
        }

        public final Collection<String> getQueryScopes() {
            if (queryScopes instanceof SdkAutoConstructList) {
                return null;
            }
            return queryScopes;
        }

        public final void setQueryScopes(Collection<String> queryScopes) {
            this.queryScopes = SearchQueryScopeTypeListCopier.copy(queryScopes);
        }

        @Override
        public final Builder queryScopesWithStrings(Collection<String> queryScopes) {
            this.queryScopes = SearchQueryScopeTypeListCopier.copy(queryScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryScopesWithStrings(String... queryScopes) {
            queryScopesWithStrings(Arrays.asList(queryScopes));
            return this;
        }

        @Override
        public final Builder queryScopes(Collection<SearchQueryScopeType> queryScopes) {
            this.queryScopes = SearchQueryScopeTypeListCopier.copyEnumToString(queryScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryScopes(SearchQueryScopeType... queryScopes) {
            queryScopes(Arrays.asList(queryScopes));
            return this;
        }

        public final String getOrganizationId() {
            return organizationId;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final Collection<String> getAdditionalResponseFields() {
            if (additionalResponseFields instanceof SdkAutoConstructList) {
                return null;
            }
            return additionalResponseFields;
        }

        public final void setAdditionalResponseFields(Collection<String> additionalResponseFields) {
            this.additionalResponseFields = AdditionalResponseFieldsListCopier.copy(additionalResponseFields);
        }

        @Override
        public final Builder additionalResponseFieldsWithStrings(Collection<String> additionalResponseFields) {
            this.additionalResponseFields = AdditionalResponseFieldsListCopier.copy(additionalResponseFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalResponseFieldsWithStrings(String... additionalResponseFields) {
            additionalResponseFieldsWithStrings(Arrays.asList(additionalResponseFields));
            return this;
        }

        @Override
        public final Builder additionalResponseFields(Collection<AdditionalResponseFieldType> additionalResponseFields) {
            this.additionalResponseFields = AdditionalResponseFieldsListCopier.copyEnumToString(additionalResponseFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalResponseFields(AdditionalResponseFieldType... additionalResponseFields) {
            additionalResponseFields(Arrays.asList(additionalResponseFields));
            return this;
        }

        public final Filters.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        public final void setFilters(Filters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(Filters filters) {
            this.filters = filters;
            return this;
        }

        public final List<SearchSortResult.Builder> getOrderBy() {
            List<SearchSortResult.Builder> result = SearchResultSortListCopier.copyToBuilder(this.orderBy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrderBy(Collection<SearchSortResult.BuilderImpl> orderBy) {
            this.orderBy = SearchResultSortListCopier.copyFromBuilder(orderBy);
        }

        @Override
        public final Builder orderBy(Collection<SearchSortResult> orderBy) {
            this.orderBy = SearchResultSortListCopier.copy(orderBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderBy(SearchSortResult... orderBy) {
            orderBy(Arrays.asList(orderBy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderBy(Consumer<SearchSortResult.Builder>... orderBy) {
            orderBy(Stream.of(orderBy).map(c -> SearchSortResult.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchResourcesRequest build() {
            return new SearchResourcesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
