/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * List of Documents, Folders, Comments, and Document Versions matching the query.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResponseItem implements SdkPojo, Serializable, ToCopyableBuilder<ResponseItem.Builder, ResponseItem> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(ResponseItem::resourceTypeAsString)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> WEB_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("WebUrl")
            .getter(getter(ResponseItem::webUrl)).setter(setter(Builder::webUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebUrl").build()).build();

    private static final SdkField<DocumentMetadata> DOCUMENT_METADATA_FIELD = SdkField
            .<DocumentMetadata> builder(MarshallingType.SDK_POJO).memberName("DocumentMetadata")
            .getter(getter(ResponseItem::documentMetadata)).setter(setter(Builder::documentMetadata))
            .constructor(DocumentMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentMetadata").build()).build();

    private static final SdkField<FolderMetadata> FOLDER_METADATA_FIELD = SdkField
            .<FolderMetadata> builder(MarshallingType.SDK_POJO).memberName("FolderMetadata")
            .getter(getter(ResponseItem::folderMetadata)).setter(setter(Builder::folderMetadata))
            .constructor(FolderMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FolderMetadata").build()).build();

    private static final SdkField<CommentMetadata> COMMENT_METADATA_FIELD = SdkField
            .<CommentMetadata> builder(MarshallingType.SDK_POJO).memberName("CommentMetadata")
            .getter(getter(ResponseItem::commentMetadata)).setter(setter(Builder::commentMetadata))
            .constructor(CommentMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommentMetadata").build()).build();

    private static final SdkField<DocumentVersionMetadata> DOCUMENT_VERSION_METADATA_FIELD = SdkField
            .<DocumentVersionMetadata> builder(MarshallingType.SDK_POJO).memberName("DocumentVersionMetadata")
            .getter(getter(ResponseItem::documentVersionMetadata)).setter(setter(Builder::documentVersionMetadata))
            .constructor(DocumentVersionMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersionMetadata").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD,
            WEB_URL_FIELD, DOCUMENT_METADATA_FIELD, FOLDER_METADATA_FIELD, COMMENT_METADATA_FIELD,
            DOCUMENT_VERSION_METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resourceType;

    private final String webUrl;

    private final DocumentMetadata documentMetadata;

    private final FolderMetadata folderMetadata;

    private final CommentMetadata commentMetadata;

    private final DocumentVersionMetadata documentVersionMetadata;

    private ResponseItem(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.webUrl = builder.webUrl;
        this.documentMetadata = builder.documentMetadata;
        this.folderMetadata = builder.folderMetadata;
        this.commentMetadata = builder.commentMetadata;
        this.documentVersionMetadata = builder.documentVersionMetadata;
    }

    /**
     * <p>
     * The type of item being returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResponseItemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of item being returned.
     * @see ResponseItemType
     */
    public final ResponseItemType resourceType() {
        return ResponseItemType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of item being returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResponseItemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of item being returned.
     * @see ResponseItemType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The webUrl of the item being returned.
     * </p>
     * 
     * @return The webUrl of the item being returned.
     */
    public final String webUrl() {
        return webUrl;
    }

    /**
     * <p>
     * The document that matches the query.
     * </p>
     * 
     * @return The document that matches the query.
     */
    public final DocumentMetadata documentMetadata() {
        return documentMetadata;
    }

    /**
     * <p>
     * The folder that matches the query.
     * </p>
     * 
     * @return The folder that matches the query.
     */
    public final FolderMetadata folderMetadata() {
        return folderMetadata;
    }

    /**
     * <p>
     * The comment that matches the query.
     * </p>
     * 
     * @return The comment that matches the query.
     */
    public final CommentMetadata commentMetadata() {
        return commentMetadata;
    }

    /**
     * <p>
     * The document version that matches the metadata.
     * </p>
     * 
     * @return The document version that matches the metadata.
     */
    public final DocumentVersionMetadata documentVersionMetadata() {
        return documentVersionMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(webUrl());
        hashCode = 31 * hashCode + Objects.hashCode(documentMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(folderMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(commentMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(documentVersionMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResponseItem)) {
            return false;
        }
        ResponseItem other = (ResponseItem) obj;
        return Objects.equals(resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(webUrl(), other.webUrl())
                && Objects.equals(documentMetadata(), other.documentMetadata())
                && Objects.equals(folderMetadata(), other.folderMetadata())
                && Objects.equals(commentMetadata(), other.commentMetadata())
                && Objects.equals(documentVersionMetadata(), other.documentVersionMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResponseItem").add("ResourceType", resourceTypeAsString())
                .add("WebUrl", webUrl() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DocumentMetadata", documentMetadata()).add("FolderMetadata", folderMetadata())
                .add("CommentMetadata", commentMetadata()).add("DocumentVersionMetadata", documentVersionMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "WebUrl":
            return Optional.ofNullable(clazz.cast(webUrl()));
        case "DocumentMetadata":
            return Optional.ofNullable(clazz.cast(documentMetadata()));
        case "FolderMetadata":
            return Optional.ofNullable(clazz.cast(folderMetadata()));
        case "CommentMetadata":
            return Optional.ofNullable(clazz.cast(commentMetadata()));
        case "DocumentVersionMetadata":
            return Optional.ofNullable(clazz.cast(documentVersionMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("WebUrl", WEB_URL_FIELD);
        map.put("DocumentMetadata", DOCUMENT_METADATA_FIELD);
        map.put("FolderMetadata", FOLDER_METADATA_FIELD);
        map.put("CommentMetadata", COMMENT_METADATA_FIELD);
        map.put("DocumentVersionMetadata", DOCUMENT_VERSION_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResponseItem, T> g) {
        return obj -> g.apply((ResponseItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResponseItem> {
        /**
         * <p>
         * The type of item being returned.
         * </p>
         * 
         * @param resourceType
         *        The type of item being returned.
         * @see ResponseItemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResponseItemType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of item being returned.
         * </p>
         * 
         * @param resourceType
         *        The type of item being returned.
         * @see ResponseItemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResponseItemType
         */
        Builder resourceType(ResponseItemType resourceType);

        /**
         * <p>
         * The webUrl of the item being returned.
         * </p>
         * 
         * @param webUrl
         *        The webUrl of the item being returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webUrl(String webUrl);

        /**
         * <p>
         * The document that matches the query.
         * </p>
         * 
         * @param documentMetadata
         *        The document that matches the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentMetadata(DocumentMetadata documentMetadata);

        /**
         * <p>
         * The document that matches the query.
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentMetadata.Builder} avoiding the
         * need to create one manually via {@link DocumentMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #documentMetadata(DocumentMetadata)}.
         * 
         * @param documentMetadata
         *        a consumer that will call methods on {@link DocumentMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentMetadata(DocumentMetadata)
         */
        default Builder documentMetadata(Consumer<DocumentMetadata.Builder> documentMetadata) {
            return documentMetadata(DocumentMetadata.builder().applyMutation(documentMetadata).build());
        }

        /**
         * <p>
         * The folder that matches the query.
         * </p>
         * 
         * @param folderMetadata
         *        The folder that matches the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder folderMetadata(FolderMetadata folderMetadata);

        /**
         * <p>
         * The folder that matches the query.
         * </p>
         * This is a convenience method that creates an instance of the {@link FolderMetadata.Builder} avoiding the need
         * to create one manually via {@link FolderMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FolderMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #folderMetadata(FolderMetadata)}.
         * 
         * @param folderMetadata
         *        a consumer that will call methods on {@link FolderMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #folderMetadata(FolderMetadata)
         */
        default Builder folderMetadata(Consumer<FolderMetadata.Builder> folderMetadata) {
            return folderMetadata(FolderMetadata.builder().applyMutation(folderMetadata).build());
        }

        /**
         * <p>
         * The comment that matches the query.
         * </p>
         * 
         * @param commentMetadata
         *        The comment that matches the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commentMetadata(CommentMetadata commentMetadata);

        /**
         * <p>
         * The comment that matches the query.
         * </p>
         * This is a convenience method that creates an instance of the {@link CommentMetadata.Builder} avoiding the
         * need to create one manually via {@link CommentMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CommentMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #commentMetadata(CommentMetadata)}.
         * 
         * @param commentMetadata
         *        a consumer that will call methods on {@link CommentMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #commentMetadata(CommentMetadata)
         */
        default Builder commentMetadata(Consumer<CommentMetadata.Builder> commentMetadata) {
            return commentMetadata(CommentMetadata.builder().applyMutation(commentMetadata).build());
        }

        /**
         * <p>
         * The document version that matches the metadata.
         * </p>
         * 
         * @param documentVersionMetadata
         *        The document version that matches the metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentVersionMetadata(DocumentVersionMetadata documentVersionMetadata);

        /**
         * <p>
         * The document version that matches the metadata.
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentVersionMetadata.Builder} avoiding
         * the need to create one manually via {@link DocumentVersionMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentVersionMetadata.Builder#build()} is called immediately
         * and its result is passed to {@link #documentVersionMetadata(DocumentVersionMetadata)}.
         * 
         * @param documentVersionMetadata
         *        a consumer that will call methods on {@link DocumentVersionMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentVersionMetadata(DocumentVersionMetadata)
         */
        default Builder documentVersionMetadata(Consumer<DocumentVersionMetadata.Builder> documentVersionMetadata) {
            return documentVersionMetadata(DocumentVersionMetadata.builder().applyMutation(documentVersionMetadata).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String resourceType;

        private String webUrl;

        private DocumentMetadata documentMetadata;

        private FolderMetadata folderMetadata;

        private CommentMetadata commentMetadata;

        private DocumentVersionMetadata documentVersionMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(ResponseItem model) {
            resourceType(model.resourceType);
            webUrl(model.webUrl);
            documentMetadata(model.documentMetadata);
            folderMetadata(model.folderMetadata);
            commentMetadata(model.commentMetadata);
            documentVersionMetadata(model.documentVersionMetadata);
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResponseItemType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getWebUrl() {
            return webUrl;
        }

        public final void setWebUrl(String webUrl) {
            this.webUrl = webUrl;
        }

        @Override
        public final Builder webUrl(String webUrl) {
            this.webUrl = webUrl;
            return this;
        }

        public final DocumentMetadata.Builder getDocumentMetadata() {
            return documentMetadata != null ? documentMetadata.toBuilder() : null;
        }

        public final void setDocumentMetadata(DocumentMetadata.BuilderImpl documentMetadata) {
            this.documentMetadata = documentMetadata != null ? documentMetadata.build() : null;
        }

        @Override
        public final Builder documentMetadata(DocumentMetadata documentMetadata) {
            this.documentMetadata = documentMetadata;
            return this;
        }

        public final FolderMetadata.Builder getFolderMetadata() {
            return folderMetadata != null ? folderMetadata.toBuilder() : null;
        }

        public final void setFolderMetadata(FolderMetadata.BuilderImpl folderMetadata) {
            this.folderMetadata = folderMetadata != null ? folderMetadata.build() : null;
        }

        @Override
        public final Builder folderMetadata(FolderMetadata folderMetadata) {
            this.folderMetadata = folderMetadata;
            return this;
        }

        public final CommentMetadata.Builder getCommentMetadata() {
            return commentMetadata != null ? commentMetadata.toBuilder() : null;
        }

        public final void setCommentMetadata(CommentMetadata.BuilderImpl commentMetadata) {
            this.commentMetadata = commentMetadata != null ? commentMetadata.build() : null;
        }

        @Override
        public final Builder commentMetadata(CommentMetadata commentMetadata) {
            this.commentMetadata = commentMetadata;
            return this;
        }

        public final DocumentVersionMetadata.Builder getDocumentVersionMetadata() {
            return documentVersionMetadata != null ? documentVersionMetadata.toBuilder() : null;
        }

        public final void setDocumentVersionMetadata(DocumentVersionMetadata.BuilderImpl documentVersionMetadata) {
            this.documentVersionMetadata = documentVersionMetadata != null ? documentVersionMetadata.build() : null;
        }

        @Override
        public final Builder documentVersionMetadata(DocumentVersionMetadata documentVersionMetadata) {
            this.documentVersionMetadata = documentVersionMetadata;
            return this;
        }

        @Override
        public ResponseItem build() {
            return new ResponseItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
