/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteDocumentVersionRequest extends WorkDocsRequest implements
        ToCopyableBuilder<DeleteDocumentVersionRequest.Builder, DeleteDocumentVersionRequest> {
    private static final SdkField<String> AUTHENTICATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationToken").getter(getter(DeleteDocumentVersionRequest::authenticationToken))
            .setter(setter(Builder::authenticationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Authentication").build()).build();

    private static final SdkField<String> DOCUMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentId").getter(getter(DeleteDocumentVersionRequest::documentId))
            .setter(setter(Builder::documentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DocumentId").build()).build();

    private static final SdkField<String> VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionId").getter(getter(DeleteDocumentVersionRequest::versionId)).setter(setter(Builder::versionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("VersionId").build()).build();

    private static final SdkField<Boolean> DELETE_PRIOR_VERSIONS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeletePriorVersions").getter(getter(DeleteDocumentVersionRequest::deletePriorVersions))
            .setter(setter(Builder::deletePriorVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("deletePriorVersions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TOKEN_FIELD,
            DOCUMENT_ID_FIELD, VERSION_ID_FIELD, DELETE_PRIOR_VERSIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String authenticationToken;

    private final String documentId;

    private final String versionId;

    private final Boolean deletePriorVersions;

    private DeleteDocumentVersionRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationToken = builder.authenticationToken;
        this.documentId = builder.documentId;
        this.versionId = builder.versionId;
        this.deletePriorVersions = builder.deletePriorVersions;
    }

    /**
     * <p>
     * Amazon WorkDocs authentication token. Not required when using Amazon Web Services administrator credentials to
     * access the API.
     * </p>
     * 
     * @return Amazon WorkDocs authentication token. Not required when using Amazon Web Services administrator
     *         credentials to access the API.
     */
    public final String authenticationToken() {
        return authenticationToken;
    }

    /**
     * <p>
     * The ID of the document associated with the version being deleted.
     * </p>
     * 
     * @return The ID of the document associated with the version being deleted.
     */
    public final String documentId() {
        return documentId;
    }

    /**
     * <p>
     * The ID of the version being deleted.
     * </p>
     * 
     * @return The ID of the version being deleted.
     */
    public final String versionId() {
        return versionId;
    }

    /**
     * <p>
     * Deletes all versions of a document prior to the current version.
     * </p>
     * 
     * @return Deletes all versions of a document prior to the current version.
     */
    public final Boolean deletePriorVersions() {
        return deletePriorVersions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(documentId());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        hashCode = 31 * hashCode + Objects.hashCode(deletePriorVersions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDocumentVersionRequest)) {
            return false;
        }
        DeleteDocumentVersionRequest other = (DeleteDocumentVersionRequest) obj;
        return Objects.equals(authenticationToken(), other.authenticationToken())
                && Objects.equals(documentId(), other.documentId()) && Objects.equals(versionId(), other.versionId())
                && Objects.equals(deletePriorVersions(), other.deletePriorVersions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteDocumentVersionRequest")
                .add("AuthenticationToken", authenticationToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DocumentId", documentId()).add("VersionId", versionId()).add("DeletePriorVersions", deletePriorVersions())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthenticationToken":
            return Optional.ofNullable(clazz.cast(authenticationToken()));
        case "DocumentId":
            return Optional.ofNullable(clazz.cast(documentId()));
        case "VersionId":
            return Optional.ofNullable(clazz.cast(versionId()));
        case "DeletePriorVersions":
            return Optional.ofNullable(clazz.cast(deletePriorVersions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Authentication", AUTHENTICATION_TOKEN_FIELD);
        map.put("DocumentId", DOCUMENT_ID_FIELD);
        map.put("VersionId", VERSION_ID_FIELD);
        map.put("deletePriorVersions", DELETE_PRIOR_VERSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteDocumentVersionRequest, T> g) {
        return obj -> g.apply((DeleteDocumentVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkDocsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteDocumentVersionRequest> {
        /**
         * <p>
         * Amazon WorkDocs authentication token. Not required when using Amazon Web Services administrator credentials
         * to access the API.
         * </p>
         * 
         * @param authenticationToken
         *        Amazon WorkDocs authentication token. Not required when using Amazon Web Services administrator
         *        credentials to access the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationToken(String authenticationToken);

        /**
         * <p>
         * The ID of the document associated with the version being deleted.
         * </p>
         * 
         * @param documentId
         *        The ID of the document associated with the version being deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentId(String documentId);

        /**
         * <p>
         * The ID of the version being deleted.
         * </p>
         * 
         * @param versionId
         *        The ID of the version being deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);

        /**
         * <p>
         * Deletes all versions of a document prior to the current version.
         * </p>
         * 
         * @param deletePriorVersions
         *        Deletes all versions of a document prior to the current version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletePriorVersions(Boolean deletePriorVersions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkDocsRequest.BuilderImpl implements Builder {
        private String authenticationToken;

        private String documentId;

        private String versionId;

        private Boolean deletePriorVersions;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDocumentVersionRequest model) {
            super(model);
            authenticationToken(model.authenticationToken);
            documentId(model.documentId);
            versionId(model.versionId);
            deletePriorVersions(model.deletePriorVersions);
        }

        public final String getAuthenticationToken() {
            return authenticationToken;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final String getDocumentId() {
            return documentId;
        }

        public final void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        @Override
        public final Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }

        public final String getVersionId() {
            return versionId;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final Boolean getDeletePriorVersions() {
            return deletePriorVersions;
        }

        public final void setDeletePriorVersions(Boolean deletePriorVersions) {
            this.deletePriorVersions = deletePriorVersions;
        }

        @Override
        public final Builder deletePriorVersions(Boolean deletePriorVersions) {
            this.deletePriorVersions = deletePriorVersions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteDocumentVersionRequest build() {
            return new DeleteDocumentVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
