/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workdocs.model.FolderContentType;
import software.amazon.awssdk.services.workdocs.model.OrderType;
import software.amazon.awssdk.services.workdocs.model.ResourceSortType;
import software.amazon.awssdk.services.workdocs.model.WorkDocsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFolderContentsRequest
extends WorkDocsRequest
implements ToCopyableBuilder<Builder, DescribeFolderContentsRequest> {
    private static final SdkField<String> AUTHENTICATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticationToken").getter(DescribeFolderContentsRequest.getter(DescribeFolderContentsRequest::authenticationToken)).setter(DescribeFolderContentsRequest.setter(Builder::authenticationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Authentication").build()}).build();
    private static final SdkField<String> FOLDER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FolderId").getter(DescribeFolderContentsRequest.getter(DescribeFolderContentsRequest::folderId)).setter(DescribeFolderContentsRequest.setter(Builder::folderId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("FolderId").build()}).build();
    private static final SdkField<String> SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Sort").getter(DescribeFolderContentsRequest.getter(DescribeFolderContentsRequest::sortAsString)).setter(DescribeFolderContentsRequest.setter(Builder::sort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sort").build()}).build();
    private static final SdkField<String> ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Order").getter(DescribeFolderContentsRequest.getter(DescribeFolderContentsRequest::orderAsString)).setter(DescribeFolderContentsRequest.setter(Builder::order)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("order").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Limit").getter(DescribeFolderContentsRequest.getter(DescribeFolderContentsRequest::limit)).setter(DescribeFolderContentsRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("limit").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeFolderContentsRequest.getter(DescribeFolderContentsRequest::marker)).setter(DescribeFolderContentsRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("marker").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(DescribeFolderContentsRequest.getter(DescribeFolderContentsRequest::typeAsString)).setter(DescribeFolderContentsRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("type").build()}).build();
    private static final SdkField<String> INCLUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Include").getter(DescribeFolderContentsRequest.getter(DescribeFolderContentsRequest::include)).setter(DescribeFolderContentsRequest.setter(Builder::include)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("include").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TOKEN_FIELD, FOLDER_ID_FIELD, SORT_FIELD, ORDER_FIELD, LIMIT_FIELD, MARKER_FIELD, TYPE_FIELD, INCLUDE_FIELD));
    private final String authenticationToken;
    private final String folderId;
    private final String sort;
    private final String order;
    private final Integer limit;
    private final String marker;
    private final String type;
    private final String include;

    private DescribeFolderContentsRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationToken = builder.authenticationToken;
        this.folderId = builder.folderId;
        this.sort = builder.sort;
        this.order = builder.order;
        this.limit = builder.limit;
        this.marker = builder.marker;
        this.type = builder.type;
        this.include = builder.include;
    }

    public final String authenticationToken() {
        return this.authenticationToken;
    }

    public final String folderId() {
        return this.folderId;
    }

    public final ResourceSortType sort() {
        return ResourceSortType.fromValue(this.sort);
    }

    public final String sortAsString() {
        return this.sort;
    }

    public final OrderType order() {
        return OrderType.fromValue(this.order);
    }

    public final String orderAsString() {
        return this.order;
    }

    public final Integer limit() {
        return this.limit;
    }

    public final String marker() {
        return this.marker;
    }

    public final FolderContentType type() {
        return FolderContentType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String include() {
        return this.include;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.folderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.include());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFolderContentsRequest)) {
            return false;
        }
        DescribeFolderContentsRequest other = (DescribeFolderContentsRequest)((Object)obj);
        return Objects.equals(this.authenticationToken(), other.authenticationToken()) && Objects.equals(this.folderId(), other.folderId()) && Objects.equals(this.sortAsString(), other.sortAsString()) && Objects.equals(this.orderAsString(), other.orderAsString()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.include(), other.include());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeFolderContentsRequest").add("AuthenticationToken", (Object)(this.authenticationToken() == null ? null : "*** Sensitive Data Redacted ***")).add("FolderId", (Object)this.folderId()).add("Sort", (Object)this.sortAsString()).add("Order", (Object)this.orderAsString()).add("Limit", (Object)this.limit()).add("Marker", (Object)this.marker()).add("Type", (Object)this.typeAsString()).add("Include", (Object)this.include()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationToken": {
                return Optional.ofNullable(clazz.cast(this.authenticationToken()));
            }
            case "FolderId": {
                return Optional.ofNullable(clazz.cast(this.folderId()));
            }
            case "Sort": {
                return Optional.ofNullable(clazz.cast(this.sortAsString()));
            }
            case "Order": {
                return Optional.ofNullable(clazz.cast(this.orderAsString()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Include": {
                return Optional.ofNullable(clazz.cast(this.include()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFolderContentsRequest, T> g) {
        return obj -> g.apply((DescribeFolderContentsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkDocsRequest.BuilderImpl
    implements Builder {
        private String authenticationToken;
        private String folderId;
        private String sort;
        private String order;
        private Integer limit;
        private String marker;
        private String type;
        private String include;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFolderContentsRequest model) {
            super(model);
            this.authenticationToken(model.authenticationToken);
            this.folderId(model.folderId);
            this.sort(model.sort);
            this.order(model.order);
            this.limit(model.limit);
            this.marker(model.marker);
            this.type(model.type);
            this.include(model.include);
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final String getFolderId() {
            return this.folderId;
        }

        public final void setFolderId(String folderId) {
            this.folderId = folderId;
        }

        @Override
        public final Builder folderId(String folderId) {
            this.folderId = folderId;
            return this;
        }

        public final String getSort() {
            return this.sort;
        }

        public final void setSort(String sort) {
            this.sort = sort;
        }

        @Override
        public final Builder sort(String sort) {
            this.sort = sort;
            return this;
        }

        @Override
        public final Builder sort(ResourceSortType sort) {
            this.sort(sort == null ? null : sort.toString());
            return this;
        }

        public final String getOrder() {
            return this.order;
        }

        public final void setOrder(String order) {
            this.order = order;
        }

        @Override
        public final Builder order(String order) {
            this.order = order;
            return this;
        }

        @Override
        public final Builder order(OrderType order) {
            this.order(order == null ? null : order.toString());
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FolderContentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getInclude() {
            return this.include;
        }

        public final void setInclude(String include) {
            this.include = include;
        }

        @Override
        public final Builder include(String include) {
            this.include = include;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeFolderContentsRequest build() {
            return new DescribeFolderContentsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkDocsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFolderContentsRequest> {
        public Builder authenticationToken(String var1);

        public Builder folderId(String var1);

        public Builder sort(String var1);

        public Builder sort(ResourceSortType var1);

        public Builder order(String var1);

        public Builder order(OrderType var1);

        public Builder limit(Integer var1);

        public Builder marker(String var1);

        public Builder type(String var1);

        public Builder type(FolderContentType var1);

        public Builder include(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

