/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workdocs.model.PrincipalRoleType;
import software.amazon.awssdk.services.workdocs.model.SearchPrincipalRoleListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchPrincipalType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SearchPrincipalType> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(SearchPrincipalType.getter(SearchPrincipalType::id)).setter(SearchPrincipalType.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<List<String>> ROLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Roles").getter(SearchPrincipalType.getter(SearchPrincipalType::rolesAsStrings)).setter(SearchPrincipalType.setter(Builder::rolesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Roles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ROLES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final List<String> roles;

    private SearchPrincipalType(BuilderImpl builder) {
        this.id = builder.id;
        this.roles = builder.roles;
    }

    public final String id() {
        return this.id;
    }

    public final List<PrincipalRoleType> roles() {
        return SearchPrincipalRoleListCopier.copyStringToEnum(this.roles);
    }

    public final boolean hasRoles() {
        return this.roles != null && !(this.roles instanceof SdkAutoConstructList);
    }

    public final List<String> rolesAsStrings() {
        return this.roles;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoles() ? this.rolesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchPrincipalType)) {
            return false;
        }
        SearchPrincipalType other = (SearchPrincipalType)obj;
        return Objects.equals(this.id(), other.id()) && this.hasRoles() == other.hasRoles() && Objects.equals(this.rolesAsStrings(), other.rolesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"SearchPrincipalType").add("Id", (Object)this.id()).add("Roles", this.hasRoles() ? this.rolesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Roles": {
                return Optional.ofNullable(clazz.cast(this.rolesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchPrincipalType, T> g) {
        return obj -> g.apply((SearchPrincipalType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private List<String> roles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchPrincipalType model) {
            this.id(model.id);
            this.rolesWithStrings(model.roles);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Collection<String> getRoles() {
            if (this.roles instanceof SdkAutoConstructList) {
                return null;
            }
            return this.roles;
        }

        public final void setRoles(Collection<String> roles) {
            this.roles = SearchPrincipalRoleListCopier.copy(roles);
        }

        @Override
        public final Builder rolesWithStrings(Collection<String> roles) {
            this.roles = SearchPrincipalRoleListCopier.copy(roles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rolesWithStrings(String ... roles) {
            this.rolesWithStrings(Arrays.asList(roles));
            return this;
        }

        @Override
        public final Builder roles(Collection<PrincipalRoleType> roles) {
            this.roles = SearchPrincipalRoleListCopier.copyEnumToString(roles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roles(PrincipalRoleType ... roles) {
            this.roles(Arrays.asList(roles));
            return this;
        }

        public SearchPrincipalType build() {
            return new SearchPrincipalType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SearchPrincipalType> {
        public Builder id(String var1);

        public Builder rolesWithStrings(Collection<String> var1);

        public Builder rolesWithStrings(String ... var1);

        public Builder roles(Collection<PrincipalRoleType> var1);

        public Builder roles(PrincipalRoleType ... var1);
    }
}

