/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum UserFilterType {
    ALL("ALL"),
    ACTIVE_PENDING("ACTIVE_PENDING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UserFilterType> VALUE_MAP;
    private final String value;

    private UserFilterType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UserFilterType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UserFilterType> knownValues() {
        EnumSet<UserFilterType> knownValues = EnumSet.allOf(UserFilterType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(UserFilterType.class, UserFilterType::toString);
    }
}

