/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wisdom.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wisdom.model.QuickResponseSummary;
import software.amazon.awssdk.services.wisdom.model.QuickResponseSummaryListCopier;
import software.amazon.awssdk.services.wisdom.model.WisdomResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListQuickResponsesResponse
extends WisdomResponse
implements ToCopyableBuilder<Builder, ListQuickResponsesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListQuickResponsesResponse.getter(ListQuickResponsesResponse::nextToken)).setter(ListQuickResponsesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<QuickResponseSummary>> QUICK_RESPONSE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("quickResponseSummaries").getter(ListQuickResponsesResponse.getter(ListQuickResponsesResponse::quickResponseSummaries)).setter(ListQuickResponsesResponse.setter(Builder::quickResponseSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quickResponseSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QuickResponseSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, QUICK_RESPONSE_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListQuickResponsesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<QuickResponseSummary> quickResponseSummaries;

    private ListQuickResponsesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.quickResponseSummaries = builder.quickResponseSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasQuickResponseSummaries() {
        return this.quickResponseSummaries != null && !(this.quickResponseSummaries instanceof SdkAutoConstructList);
    }

    public final List<QuickResponseSummary> quickResponseSummaries() {
        return this.quickResponseSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQuickResponseSummaries() ? this.quickResponseSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQuickResponsesResponse)) {
            return false;
        }
        ListQuickResponsesResponse other = (ListQuickResponsesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasQuickResponseSummaries() == other.hasQuickResponseSummaries() && Objects.equals(this.quickResponseSummaries(), other.quickResponseSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListQuickResponsesResponse").add("NextToken", (Object)this.nextToken()).add("QuickResponseSummaries", this.hasQuickResponseSummaries() ? this.quickResponseSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "quickResponseSummaries": {
                return Optional.ofNullable(clazz.cast(this.quickResponseSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("quickResponseSummaries", QUICK_RESPONSE_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListQuickResponsesResponse, T> g) {
        return obj -> g.apply((ListQuickResponsesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WisdomResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<QuickResponseSummary> quickResponseSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListQuickResponsesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.quickResponseSummaries(model.quickResponseSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<QuickResponseSummary.Builder> getQuickResponseSummaries() {
            List<QuickResponseSummary.Builder> result = QuickResponseSummaryListCopier.copyToBuilder(this.quickResponseSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQuickResponseSummaries(Collection<QuickResponseSummary.BuilderImpl> quickResponseSummaries) {
            this.quickResponseSummaries = QuickResponseSummaryListCopier.copyFromBuilder(quickResponseSummaries);
        }

        @Override
        public final Builder quickResponseSummaries(Collection<QuickResponseSummary> quickResponseSummaries) {
            this.quickResponseSummaries = QuickResponseSummaryListCopier.copy(quickResponseSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder quickResponseSummaries(QuickResponseSummary ... quickResponseSummaries) {
            this.quickResponseSummaries(Arrays.asList(quickResponseSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder quickResponseSummaries(Consumer<QuickResponseSummary.Builder> ... quickResponseSummaries) {
            this.quickResponseSummaries(Stream.of(quickResponseSummaries).map(c -> (QuickResponseSummary)((QuickResponseSummary.Builder)QuickResponseSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListQuickResponsesResponse build() {
            return new ListQuickResponsesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WisdomResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListQuickResponsesResponse> {
        public Builder nextToken(String var1);

        public Builder quickResponseSummaries(Collection<QuickResponseSummary> var1);

        public Builder quickResponseSummaries(QuickResponseSummary ... var1);

        public Builder quickResponseSummaries(Consumer<QuickResponseSummary.Builder> ... var1);
    }
}

