/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wisdom.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartContentUploadResponse extends WisdomResponse implements
        ToCopyableBuilder<StartContentUploadResponse.Builder, StartContentUploadResponse> {
    private static final SdkField<Map<String, String>> HEADERS_TO_INCLUDE_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("headersToInclude")
            .getter(getter(StartContentUploadResponse::headersToInclude))
            .setter(setter(Builder::headersToInclude))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("headersToInclude").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> UPLOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("uploadId").getter(getter(StartContentUploadResponse::uploadId)).setter(setter(Builder::uploadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadId").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("url")
            .getter(getter(StartContentUploadResponse::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()).build();

    private static final SdkField<Instant> URL_EXPIRY_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("urlExpiry")
            .getter(getter(StartContentUploadResponse::urlExpiry))
            .setter(setter(Builder::urlExpiry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("urlExpiry").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.UNIX_TIMESTAMP)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEADERS_TO_INCLUDE_FIELD,
            UPLOAD_ID_FIELD, URL_FIELD, URL_EXPIRY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Map<String, String> headersToInclude;

    private final String uploadId;

    private final String url;

    private final Instant urlExpiry;

    private StartContentUploadResponse(BuilderImpl builder) {
        super(builder);
        this.headersToInclude = builder.headersToInclude;
        this.uploadId = builder.uploadId;
        this.url = builder.url;
        this.urlExpiry = builder.urlExpiry;
    }

    /**
     * For responses, this returns true if the service returned a value for the HeadersToInclude property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHeadersToInclude() {
        return headersToInclude != null && !(headersToInclude instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The headers to include in the upload.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHeadersToInclude} method.
     * </p>
     * 
     * @return The headers to include in the upload.
     */
    public final Map<String, String> headersToInclude() {
        return headersToInclude;
    }

    /**
     * <p>
     * The identifier of the upload.
     * </p>
     * 
     * @return The identifier of the upload.
     */
    public final String uploadId() {
        return uploadId;
    }

    /**
     * <p>
     * The URL of the upload.
     * </p>
     * 
     * @return The URL of the upload.
     */
    public final String url() {
        return url;
    }

    /**
     * <p>
     * The expiration time of the URL as an epoch timestamp.
     * </p>
     * 
     * @return The expiration time of the URL as an epoch timestamp.
     */
    public final Instant urlExpiry() {
        return urlExpiry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasHeadersToInclude() ? headersToInclude() : null);
        hashCode = 31 * hashCode + Objects.hashCode(uploadId());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(urlExpiry());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartContentUploadResponse)) {
            return false;
        }
        StartContentUploadResponse other = (StartContentUploadResponse) obj;
        return hasHeadersToInclude() == other.hasHeadersToInclude()
                && Objects.equals(headersToInclude(), other.headersToInclude()) && Objects.equals(uploadId(), other.uploadId())
                && Objects.equals(url(), other.url()) && Objects.equals(urlExpiry(), other.urlExpiry());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartContentUploadResponse")
                .add("HeadersToInclude", hasHeadersToInclude() ? headersToInclude() : null).add("UploadId", uploadId())
                .add("Url", url() == null ? null : "*** Sensitive Data Redacted ***").add("UrlExpiry", urlExpiry()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "headersToInclude":
            return Optional.ofNullable(clazz.cast(headersToInclude()));
        case "uploadId":
            return Optional.ofNullable(clazz.cast(uploadId()));
        case "url":
            return Optional.ofNullable(clazz.cast(url()));
        case "urlExpiry":
            return Optional.ofNullable(clazz.cast(urlExpiry()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("headersToInclude", HEADERS_TO_INCLUDE_FIELD);
        map.put("uploadId", UPLOAD_ID_FIELD);
        map.put("url", URL_FIELD);
        map.put("urlExpiry", URL_EXPIRY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartContentUploadResponse, T> g) {
        return obj -> g.apply((StartContentUploadResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WisdomResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartContentUploadResponse> {
        /**
         * <p>
         * The headers to include in the upload.
         * </p>
         * 
         * @param headersToInclude
         *        The headers to include in the upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headersToInclude(Map<String, String> headersToInclude);

        /**
         * <p>
         * The identifier of the upload.
         * </p>
         * 
         * @param uploadId
         *        The identifier of the upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadId(String uploadId);

        /**
         * <p>
         * The URL of the upload.
         * </p>
         * 
         * @param url
         *        The URL of the upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * The expiration time of the URL as an epoch timestamp.
         * </p>
         * 
         * @param urlExpiry
         *        The expiration time of the URL as an epoch timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder urlExpiry(Instant urlExpiry);
    }

    static final class BuilderImpl extends WisdomResponse.BuilderImpl implements Builder {
        private Map<String, String> headersToInclude = DefaultSdkAutoConstructMap.getInstance();

        private String uploadId;

        private String url;

        private Instant urlExpiry;

        private BuilderImpl() {
        }

        private BuilderImpl(StartContentUploadResponse model) {
            super(model);
            headersToInclude(model.headersToInclude);
            uploadId(model.uploadId);
            url(model.url);
            urlExpiry(model.urlExpiry);
        }

        public final Map<String, String> getHeadersToInclude() {
            if (headersToInclude instanceof SdkAutoConstructMap) {
                return null;
            }
            return headersToInclude;
        }

        public final void setHeadersToInclude(Map<String, String> headersToInclude) {
            this.headersToInclude = HeadersCopier.copy(headersToInclude);
        }

        @Override
        public final Builder headersToInclude(Map<String, String> headersToInclude) {
            this.headersToInclude = HeadersCopier.copy(headersToInclude);
            return this;
        }

        public final String getUploadId() {
            return uploadId;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final Instant getUrlExpiry() {
            return urlExpiry;
        }

        public final void setUrlExpiry(Instant urlExpiry) {
            this.urlExpiry = urlExpiry;
        }

        @Override
        public final Builder urlExpiry(Instant urlExpiry) {
            this.urlExpiry = urlExpiry;
            return this;
        }

        @Override
        public StartContentUploadResponse build() {
            return new StartContentUploadResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
