/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wisdom.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResultData implements SdkPojo, Serializable, ToCopyableBuilder<ResultData.Builder, ResultData> {
    private static final SdkField<Document> DOCUMENT_FIELD = SdkField.<Document> builder(MarshallingType.SDK_POJO)
            .memberName("document").getter(getter(ResultData::document)).setter(setter(Builder::document))
            .constructor(Document::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("document").build()).build();

    private static final SdkField<Double> RELEVANCE_SCORE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("relevanceScore").getter(getter(ResultData::relevanceScore)).setter(setter(Builder::relevanceScore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relevanceScore").build()).build();

    private static final SdkField<String> RESULT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resultId").getter(getter(ResultData::resultId)).setter(setter(Builder::resultId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resultId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_FIELD,
            RELEVANCE_SCORE_FIELD, RESULT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Document document;

    private final Double relevanceScore;

    private final String resultId;

    private ResultData(BuilderImpl builder) {
        this.document = builder.document;
        this.relevanceScore = builder.relevanceScore;
        this.resultId = builder.resultId;
    }

    /**
     * <p>
     * The document.
     * </p>
     * 
     * @return The document.
     */
    public final Document document() {
        return document;
    }

    /**
     * <p>
     * The relevance score of the results.
     * </p>
     * 
     * @return The relevance score of the results.
     */
    public final Double relevanceScore() {
        return relevanceScore;
    }

    /**
     * <p>
     * The identifier of the result data.
     * </p>
     * 
     * @return The identifier of the result data.
     */
    public final String resultId() {
        return resultId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(document());
        hashCode = 31 * hashCode + Objects.hashCode(relevanceScore());
        hashCode = 31 * hashCode + Objects.hashCode(resultId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultData)) {
            return false;
        }
        ResultData other = (ResultData) obj;
        return Objects.equals(document(), other.document()) && Objects.equals(relevanceScore(), other.relevanceScore())
                && Objects.equals(resultId(), other.resultId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResultData").add("Document", document()).add("RelevanceScore", relevanceScore())
                .add("ResultId", resultId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "document":
            return Optional.ofNullable(clazz.cast(document()));
        case "relevanceScore":
            return Optional.ofNullable(clazz.cast(relevanceScore()));
        case "resultId":
            return Optional.ofNullable(clazz.cast(resultId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("document", DOCUMENT_FIELD);
        map.put("relevanceScore", RELEVANCE_SCORE_FIELD);
        map.put("resultId", RESULT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResultData, T> g) {
        return obj -> g.apply((ResultData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResultData> {
        /**
         * <p>
         * The document.
         * </p>
         * 
         * @param document
         *        The document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder document(Document document);

        /**
         * <p>
         * The document.
         * </p>
         * This is a convenience method that creates an instance of the {@link Document.Builder} avoiding the need to
         * create one manually via {@link Document#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Document.Builder#build()} is called immediately and its result is
         * passed to {@link #document(Document)}.
         * 
         * @param document
         *        a consumer that will call methods on {@link Document.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #document(Document)
         */
        default Builder document(Consumer<Document.Builder> document) {
            return document(Document.builder().applyMutation(document).build());
        }

        /**
         * <p>
         * The relevance score of the results.
         * </p>
         * 
         * @param relevanceScore
         *        The relevance score of the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relevanceScore(Double relevanceScore);

        /**
         * <p>
         * The identifier of the result data.
         * </p>
         * 
         * @param resultId
         *        The identifier of the result data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultId(String resultId);
    }

    static final class BuilderImpl implements Builder {
        private Document document;

        private Double relevanceScore;

        private String resultId;

        private BuilderImpl() {
        }

        private BuilderImpl(ResultData model) {
            document(model.document);
            relevanceScore(model.relevanceScore);
            resultId(model.resultId);
        }

        public final Document.Builder getDocument() {
            return document != null ? document.toBuilder() : null;
        }

        public final void setDocument(Document.BuilderImpl document) {
            this.document = document != null ? document.build() : null;
        }

        @Override
        public final Builder document(Document document) {
            this.document = document;
            return this;
        }

        public final Double getRelevanceScore() {
            return relevanceScore;
        }

        public final void setRelevanceScore(Double relevanceScore) {
            this.relevanceScore = relevanceScore;
        }

        @Override
        public final Builder relevanceScore(Double relevanceScore) {
            this.relevanceScore = relevanceScore;
            return this;
        }

        public final String getResultId() {
            return resultId;
        }

        public final void setResultId(String resultId) {
            this.resultId = resultId;
        }

        @Override
        public final Builder resultId(String resultId) {
            this.resultId = resultId;
            return this;
        }

        @Override
        public ResultData build() {
            return new ResultData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
