/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wisdom.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A search filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Filter implements SdkPojo, Serializable, ToCopyableBuilder<Filter.Builder, Filter> {
    private static final SdkField<String> FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("field")
            .getter(getter(Filter::fieldAsString)).setter(setter(Builder::field))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("field").build()).build();

    private static final SdkField<String> OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operator").getter(getter(Filter::operatorAsString)).setter(setter(Builder::operator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operator").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("value")
            .getter(getter(Filter::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_FIELD, OPERATOR_FIELD,
            VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String field;

    private final String operator;

    private final String value;

    private Filter(BuilderImpl builder) {
        this.field = builder.field;
        this.operator = builder.operator;
        this.value = builder.value;
    }

    /**
     * <p>
     * The field on which to filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #field} will return
     * {@link FilterField#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fieldAsString}.
     * </p>
     * 
     * @return The field on which to filter.
     * @see FilterField
     */
    public final FilterField field() {
        return FilterField.fromValue(field);
    }

    /**
     * <p>
     * The field on which to filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #field} will return
     * {@link FilterField#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fieldAsString}.
     * </p>
     * 
     * @return The field on which to filter.
     * @see FilterField
     */
    public final String fieldAsString() {
        return field;
    }

    /**
     * <p>
     * The operator to use for comparing the field’s value with the provided value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link FilterOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operatorAsString}.
     * </p>
     * 
     * @return The operator to use for comparing the field’s value with the provided value.
     * @see FilterOperator
     */
    public final FilterOperator operator() {
        return FilterOperator.fromValue(operator);
    }

    /**
     * <p>
     * The operator to use for comparing the field’s value with the provided value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link FilterOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operatorAsString}.
     * </p>
     * 
     * @return The operator to use for comparing the field’s value with the provided value.
     * @see FilterOperator
     */
    public final String operatorAsString() {
        return operator;
    }

    /**
     * <p>
     * The desired field value on which to filter.
     * </p>
     * 
     * @return The desired field value on which to filter.
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldAsString());
        hashCode = 31 * hashCode + Objects.hashCode(operatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filter)) {
            return false;
        }
        Filter other = (Filter) obj;
        return Objects.equals(fieldAsString(), other.fieldAsString())
                && Objects.equals(operatorAsString(), other.operatorAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Filter").add("Field", fieldAsString()).add("Operator", operatorAsString()).add("Value", value())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "field":
            return Optional.ofNullable(clazz.cast(fieldAsString()));
        case "operator":
            return Optional.ofNullable(clazz.cast(operatorAsString()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("field", FIELD_FIELD);
        map.put("operator", OPERATOR_FIELD);
        map.put("value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Filter, T> g) {
        return obj -> g.apply((Filter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Filter> {
        /**
         * <p>
         * The field on which to filter.
         * </p>
         * 
         * @param field
         *        The field on which to filter.
         * @see FilterField
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterField
         */
        Builder field(String field);

        /**
         * <p>
         * The field on which to filter.
         * </p>
         * 
         * @param field
         *        The field on which to filter.
         * @see FilterField
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterField
         */
        Builder field(FilterField field);

        /**
         * <p>
         * The operator to use for comparing the field’s value with the provided value.
         * </p>
         * 
         * @param operator
         *        The operator to use for comparing the field’s value with the provided value.
         * @see FilterOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterOperator
         */
        Builder operator(String operator);

        /**
         * <p>
         * The operator to use for comparing the field’s value with the provided value.
         * </p>
         * 
         * @param operator
         *        The operator to use for comparing the field’s value with the provided value.
         * @see FilterOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterOperator
         */
        Builder operator(FilterOperator operator);

        /**
         * <p>
         * The desired field value on which to filter.
         * </p>
         * 
         * @param value
         *        The desired field value on which to filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String field;

        private String operator;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(Filter model) {
            field(model.field);
            operator(model.operator);
            value(model.value);
        }

        public final String getField() {
            return field;
        }

        public final void setField(String field) {
            this.field = field;
        }

        @Override
        public final Builder field(String field) {
            this.field = field;
            return this;
        }

        @Override
        public final Builder field(FilterField field) {
            this.field(field == null ? null : field.toString());
            return this;
        }

        public final String getOperator() {
            return operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(FilterOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public Filter build() {
            return new Filter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
