/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wisdom.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about the assistant.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssistantSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AssistantSummary.Builder, AssistantSummary> {
    private static final SdkField<String> ASSISTANT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assistantArn").getter(getter(AssistantSummary::assistantArn)).setter(setter(Builder::assistantArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantArn").build()).build();

    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assistantId").getter(getter(AssistantSummary::assistantId)).setter(setter(Builder::assistantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AssistantSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<AssistantIntegrationConfiguration> INTEGRATION_CONFIGURATION_FIELD = SdkField
            .<AssistantIntegrationConfiguration> builder(MarshallingType.SDK_POJO).memberName("integrationConfiguration")
            .getter(getter(AssistantSummary::integrationConfiguration)).setter(setter(Builder::integrationConfiguration))
            .constructor(AssistantIntegrationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationConfiguration").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AssistantSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<ServerSideEncryptionConfiguration> SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<ServerSideEncryptionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("serverSideEncryptionConfiguration")
            .getter(getter(AssistantSummary::serverSideEncryptionConfiguration))
            .setter(setter(Builder::serverSideEncryptionConfiguration))
            .constructor(ServerSideEncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverSideEncryptionConfiguration")
                    .build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(AssistantSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(AssistantSummary::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(AssistantSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSISTANT_ARN_FIELD,
            ASSISTANT_ID_FIELD, DESCRIPTION_FIELD, INTEGRATION_CONFIGURATION_FIELD, NAME_FIELD,
            SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD, STATUS_FIELD, TAGS_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String assistantArn;

    private final String assistantId;

    private final String description;

    private final AssistantIntegrationConfiguration integrationConfiguration;

    private final String name;

    private final ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;

    private final String status;

    private final Map<String, String> tags;

    private final String type;

    private AssistantSummary(BuilderImpl builder) {
        this.assistantArn = builder.assistantArn;
        this.assistantId = builder.assistantId;
        this.description = builder.description;
        this.integrationConfiguration = builder.integrationConfiguration;
        this.name = builder.name;
        this.serverSideEncryptionConfiguration = builder.serverSideEncryptionConfiguration;
        this.status = builder.status;
        this.tags = builder.tags;
        this.type = builder.type;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Wisdom assistant.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Wisdom assistant.
     */
    public final String assistantArn() {
        return assistantArn;
    }

    /**
     * <p>
     * The identifier of the Wisdom assistant.
     * </p>
     * 
     * @return The identifier of the Wisdom assistant.
     */
    public final String assistantId() {
        return assistantId;
    }

    /**
     * <p>
     * The description of the assistant.
     * </p>
     * 
     * @return The description of the assistant.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The configuration information for the Wisdom assistant integration.
     * </p>
     * 
     * @return The configuration information for the Wisdom assistant integration.
     */
    public final AssistantIntegrationConfiguration integrationConfiguration() {
        return integrationConfiguration;
    }

    /**
     * <p>
     * The name of the assistant.
     * </p>
     * 
     * @return The name of the assistant.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The configuration information for the customer managed key used for encryption.
     * </p>
     * <p>
     * This KMS key must have a policy that allows <code>kms:CreateGrant</code>, <code>kms:DescribeKey</code>, and
     * <code>kms:Decrypt/kms:GenerateDataKey</code> permissions to the IAM identity using the key to invoke Wisdom. To
     * use Wisdom with chat, the key policy must also allow <code>kms:Decrypt</code>, <code>kms:GenerateDataKey*</code>,
     * and <code>kms:DescribeKey</code> permissions to the <code>connect.amazonaws.com</code> service principal.
     * </p>
     * <p>
     * For more information about setting up a customer managed key for Wisdom, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-wisdom.html">Enable Amazon Connect Wisdom for
     * your instance</a>.
     * </p>
     * 
     * @return The configuration information for the customer managed key used for encryption. </p>
     *         <p>
     *         This KMS key must have a policy that allows <code>kms:CreateGrant</code>, <code>kms:DescribeKey</code>,
     *         and <code>kms:Decrypt/kms:GenerateDataKey</code> permissions to the IAM identity using the key to invoke
     *         Wisdom. To use Wisdom with chat, the key policy must also allow <code>kms:Decrypt</code>,
     *         <code>kms:GenerateDataKey*</code>, and <code>kms:DescribeKey</code> permissions to the
     *         <code>connect.amazonaws.com</code> service principal.
     *         </p>
     *         <p>
     *         For more information about setting up a customer managed key for Wisdom, see <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-wisdom.html">Enable Amazon Connect
     *         Wisdom for your instance</a>.
     */
    public final ServerSideEncryptionConfiguration serverSideEncryptionConfiguration() {
        return serverSideEncryptionConfiguration;
    }

    /**
     * <p>
     * The status of the assistant.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AssistantStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the assistant.
     * @see AssistantStatus
     */
    public final AssistantStatus status() {
        return AssistantStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the assistant.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AssistantStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the assistant.
     * @see AssistantStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The type of the assistant.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AssistantType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the assistant.
     * @see AssistantType
     */
    public final AssistantType type() {
        return AssistantType.fromValue(type);
    }

    /**
     * <p>
     * The type of the assistant.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AssistantType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the assistant.
     * @see AssistantType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assistantArn());
        hashCode = 31 * hashCode + Objects.hashCode(assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(integrationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(serverSideEncryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssistantSummary)) {
            return false;
        }
        AssistantSummary other = (AssistantSummary) obj;
        return Objects.equals(assistantArn(), other.assistantArn()) && Objects.equals(assistantId(), other.assistantId())
                && Objects.equals(description(), other.description())
                && Objects.equals(integrationConfiguration(), other.integrationConfiguration())
                && Objects.equals(name(), other.name())
                && Objects.equals(serverSideEncryptionConfiguration(), other.serverSideEncryptionConfiguration())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssistantSummary").add("AssistantArn", assistantArn()).add("AssistantId", assistantId())
                .add("Description", description()).add("IntegrationConfiguration", integrationConfiguration())
                .add("Name", name()).add("ServerSideEncryptionConfiguration", serverSideEncryptionConfiguration())
                .add("Status", statusAsString()).add("Tags", hasTags() ? tags() : null).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assistantArn":
            return Optional.ofNullable(clazz.cast(assistantArn()));
        case "assistantId":
            return Optional.ofNullable(clazz.cast(assistantId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "integrationConfiguration":
            return Optional.ofNullable(clazz.cast(integrationConfiguration()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "serverSideEncryptionConfiguration":
            return Optional.ofNullable(clazz.cast(serverSideEncryptionConfiguration()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assistantArn", ASSISTANT_ARN_FIELD);
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("integrationConfiguration", INTEGRATION_CONFIGURATION_FIELD);
        map.put("name", NAME_FIELD);
        map.put("serverSideEncryptionConfiguration", SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssistantSummary, T> g) {
        return obj -> g.apply((AssistantSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssistantSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Wisdom assistant.
         * </p>
         * 
         * @param assistantArn
         *        The Amazon Resource Name (ARN) of the Wisdom assistant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantArn(String assistantArn);

        /**
         * <p>
         * The identifier of the Wisdom assistant.
         * </p>
         * 
         * @param assistantId
         *        The identifier of the Wisdom assistant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantId(String assistantId);

        /**
         * <p>
         * The description of the assistant.
         * </p>
         * 
         * @param description
         *        The description of the assistant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The configuration information for the Wisdom assistant integration.
         * </p>
         * 
         * @param integrationConfiguration
         *        The configuration information for the Wisdom assistant integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationConfiguration(AssistantIntegrationConfiguration integrationConfiguration);

        /**
         * <p>
         * The configuration information for the Wisdom assistant integration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AssistantIntegrationConfiguration.Builder} avoiding the need to create one manually via
         * {@link AssistantIntegrationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssistantIntegrationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #integrationConfiguration(AssistantIntegrationConfiguration)}.
         * 
         * @param integrationConfiguration
         *        a consumer that will call methods on {@link AssistantIntegrationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #integrationConfiguration(AssistantIntegrationConfiguration)
         */
        default Builder integrationConfiguration(Consumer<AssistantIntegrationConfiguration.Builder> integrationConfiguration) {
            return integrationConfiguration(AssistantIntegrationConfiguration.builder().applyMutation(integrationConfiguration)
                    .build());
        }

        /**
         * <p>
         * The name of the assistant.
         * </p>
         * 
         * @param name
         *        The name of the assistant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The configuration information for the customer managed key used for encryption.
         * </p>
         * <p>
         * This KMS key must have a policy that allows <code>kms:CreateGrant</code>, <code>kms:DescribeKey</code>, and
         * <code>kms:Decrypt/kms:GenerateDataKey</code> permissions to the IAM identity using the key to invoke Wisdom.
         * To use Wisdom with chat, the key policy must also allow <code>kms:Decrypt</code>,
         * <code>kms:GenerateDataKey*</code>, and <code>kms:DescribeKey</code> permissions to the
         * <code>connect.amazonaws.com</code> service principal.
         * </p>
         * <p>
         * For more information about setting up a customer managed key for Wisdom, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-wisdom.html">Enable Amazon Connect Wisdom
         * for your instance</a>.
         * </p>
         * 
         * @param serverSideEncryptionConfiguration
         *        The configuration information for the customer managed key used for encryption. </p>
         *        <p>
         *        This KMS key must have a policy that allows <code>kms:CreateGrant</code>, <code>kms:DescribeKey</code>
         *        , and <code>kms:Decrypt/kms:GenerateDataKey</code> permissions to the IAM identity using the key to
         *        invoke Wisdom. To use Wisdom with chat, the key policy must also allow <code>kms:Decrypt</code>,
         *        <code>kms:GenerateDataKey*</code>, and <code>kms:DescribeKey</code> permissions to the
         *        <code>connect.amazonaws.com</code> service principal.
         *        </p>
         *        <p>
         *        For more information about setting up a customer managed key for Wisdom, see <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-wisdom.html">Enable Amazon Connect
         *        Wisdom for your instance</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration serverSideEncryptionConfiguration);

        /**
         * <p>
         * The configuration information for the customer managed key used for encryption.
         * </p>
         * <p>
         * This KMS key must have a policy that allows <code>kms:CreateGrant</code>, <code>kms:DescribeKey</code>, and
         * <code>kms:Decrypt/kms:GenerateDataKey</code> permissions to the IAM identity using the key to invoke Wisdom.
         * To use Wisdom with chat, the key policy must also allow <code>kms:Decrypt</code>,
         * <code>kms:GenerateDataKey*</code>, and <code>kms:DescribeKey</code> permissions to the
         * <code>connect.amazonaws.com</code> service principal.
         * </p>
         * <p>
         * For more information about setting up a customer managed key for Wisdom, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-wisdom.html">Enable Amazon Connect Wisdom
         * for your instance</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ServerSideEncryptionConfiguration.Builder} avoiding the need to create one manually via
         * {@link ServerSideEncryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServerSideEncryptionConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration)}.
         * 
         * @param serverSideEncryptionConfiguration
         *        a consumer that will call methods on {@link ServerSideEncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration)
         */
        default Builder serverSideEncryptionConfiguration(
                Consumer<ServerSideEncryptionConfiguration.Builder> serverSideEncryptionConfiguration) {
            return serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration.builder()
                    .applyMutation(serverSideEncryptionConfiguration).build());
        }

        /**
         * <p>
         * The status of the assistant.
         * </p>
         * 
         * @param status
         *        The status of the assistant.
         * @see AssistantStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssistantStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the assistant.
         * </p>
         * 
         * @param status
         *        The status of the assistant.
         * @see AssistantStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssistantStatus
         */
        Builder status(AssistantStatus status);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The type of the assistant.
         * </p>
         * 
         * @param type
         *        The type of the assistant.
         * @see AssistantType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssistantType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the assistant.
         * </p>
         * 
         * @param type
         *        The type of the assistant.
         * @see AssistantType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssistantType
         */
        Builder type(AssistantType type);
    }

    static final class BuilderImpl implements Builder {
        private String assistantArn;

        private String assistantId;

        private String description;

        private AssistantIntegrationConfiguration integrationConfiguration;

        private String name;

        private ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;

        private String status;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(AssistantSummary model) {
            assistantArn(model.assistantArn);
            assistantId(model.assistantId);
            description(model.description);
            integrationConfiguration(model.integrationConfiguration);
            name(model.name);
            serverSideEncryptionConfiguration(model.serverSideEncryptionConfiguration);
            status(model.status);
            tags(model.tags);
            type(model.type);
        }

        public final String getAssistantArn() {
            return assistantArn;
        }

        public final void setAssistantArn(String assistantArn) {
            this.assistantArn = assistantArn;
        }

        @Override
        public final Builder assistantArn(String assistantArn) {
            this.assistantArn = assistantArn;
            return this;
        }

        public final String getAssistantId() {
            return assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final AssistantIntegrationConfiguration.Builder getIntegrationConfiguration() {
            return integrationConfiguration != null ? integrationConfiguration.toBuilder() : null;
        }

        public final void setIntegrationConfiguration(AssistantIntegrationConfiguration.BuilderImpl integrationConfiguration) {
            this.integrationConfiguration = integrationConfiguration != null ? integrationConfiguration.build() : null;
        }

        @Override
        public final Builder integrationConfiguration(AssistantIntegrationConfiguration integrationConfiguration) {
            this.integrationConfiguration = integrationConfiguration;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ServerSideEncryptionConfiguration.Builder getServerSideEncryptionConfiguration() {
            return serverSideEncryptionConfiguration != null ? serverSideEncryptionConfiguration.toBuilder() : null;
        }

        public final void setServerSideEncryptionConfiguration(
                ServerSideEncryptionConfiguration.BuilderImpl serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration != null ? serverSideEncryptionConfiguration
                    .build() : null;
        }

        @Override
        public final Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AssistantStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AssistantType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public AssistantSummary build() {
            return new AssistantSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
