/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wisdom.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wisdom.model.Configuration;
import software.amazon.awssdk.services.wisdom.model.ExternalSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExternalSourceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExternalSourceConfiguration> {
    private static final SdkField<Configuration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(ExternalSourceConfiguration.getter(ExternalSourceConfiguration::configuration)).setter(ExternalSourceConfiguration.setter(Builder::configuration)).constructor(Configuration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("source").getter(ExternalSourceConfiguration.getter(ExternalSourceConfiguration::sourceAsString)).setter(ExternalSourceConfiguration.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD, SOURCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Configuration configuration;
    private final String source;

    private ExternalSourceConfiguration(BuilderImpl builder) {
        this.configuration = builder.configuration;
        this.source = builder.source;
    }

    public final Configuration configuration() {
        return this.configuration;
    }

    public final ExternalSource source() {
        return ExternalSource.fromValue(this.source);
    }

    public final String sourceAsString() {
        return this.source;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalSourceConfiguration)) {
            return false;
        }
        ExternalSourceConfiguration other = (ExternalSourceConfiguration)obj;
        return Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.sourceAsString(), other.sourceAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ExternalSourceConfiguration").add("Configuration", (Object)this.configuration()).add("Source", (Object)this.sourceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.sourceAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExternalSourceConfiguration, T> g) {
        return obj -> g.apply((ExternalSourceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Configuration configuration;
        private String source;

        private BuilderImpl() {
        }

        private BuilderImpl(ExternalSourceConfiguration model) {
            this.configuration(model.configuration);
            this.source(model.source);
        }

        public final Configuration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(Configuration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(ExternalSource source) {
            this.source(source == null ? null : source.toString());
            return this;
        }

        public ExternalSourceConfiguration build() {
            return new ExternalSourceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExternalSourceConfiguration> {
        public Builder configuration(Configuration var1);

        default public Builder configuration(Consumer<Configuration.Builder> configuration) {
            return this.configuration((Configuration)((Configuration.Builder)Configuration.builder().applyMutation(configuration)).build());
        }

        public Builder source(String var1);

        public Builder source(ExternalSource var1);
    }
}

