/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wisdom.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateQuickResponseRequest extends WisdomRequest implements
        ToCopyableBuilder<CreateQuickResponseRequest.Builder, CreateQuickResponseRequest> {
    private static final SdkField<List<String>> CHANNELS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("channels")
            .getter(getter(CreateQuickResponseRequest::channels))
            .setter(setter(Builder::channels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateQuickResponseRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<QuickResponseDataProvider> CONTENT_FIELD = SdkField
            .<QuickResponseDataProvider> builder(MarshallingType.SDK_POJO).memberName("content")
            .getter(getter(CreateQuickResponseRequest::content)).setter(setter(Builder::content))
            .constructor(QuickResponseDataProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentType").getter(getter(CreateQuickResponseRequest::contentType))
            .setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentType").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateQuickResponseRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<GroupingConfiguration> GROUPING_CONFIGURATION_FIELD = SdkField
            .<GroupingConfiguration> builder(MarshallingType.SDK_POJO).memberName("groupingConfiguration")
            .getter(getter(CreateQuickResponseRequest::groupingConfiguration)).setter(setter(Builder::groupingConfiguration))
            .constructor(GroupingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupingConfiguration").build())
            .build();

    private static final SdkField<Boolean> IS_ACTIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isActive").getter(getter(CreateQuickResponseRequest::isActive)).setter(setter(Builder::isActive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isActive").build()).build();

    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseId").getter(getter(CreateQuickResponseRequest::knowledgeBaseId))
            .setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("knowledgeBaseId").build()).build();

    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("language").getter(getter(CreateQuickResponseRequest::language)).setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("language").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateQuickResponseRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SHORTCUT_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("shortcutKey").getter(getter(CreateQuickResponseRequest::shortcutKey))
            .setter(setter(Builder::shortcutKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shortcutKey").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateQuickResponseRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNELS_FIELD,
            CLIENT_TOKEN_FIELD, CONTENT_FIELD, CONTENT_TYPE_FIELD, DESCRIPTION_FIELD, GROUPING_CONFIGURATION_FIELD,
            IS_ACTIVE_FIELD, KNOWLEDGE_BASE_ID_FIELD, LANGUAGE_FIELD, NAME_FIELD, SHORTCUT_KEY_FIELD, TAGS_FIELD));

    private final List<String> channels;

    private final String clientToken;

    private final QuickResponseDataProvider content;

    private final String contentType;

    private final String description;

    private final GroupingConfiguration groupingConfiguration;

    private final Boolean isActive;

    private final String knowledgeBaseId;

    private final String language;

    private final String name;

    private final String shortcutKey;

    private final Map<String, String> tags;

    private CreateQuickResponseRequest(BuilderImpl builder) {
        super(builder);
        this.channels = builder.channels;
        this.clientToken = builder.clientToken;
        this.content = builder.content;
        this.contentType = builder.contentType;
        this.description = builder.description;
        this.groupingConfiguration = builder.groupingConfiguration;
        this.isActive = builder.isActive;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.language = builder.language;
        this.name = builder.name;
        this.shortcutKey = builder.shortcutKey;
        this.tags = builder.tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the Channels property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasChannels() {
        return channels != null && !(channels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Connect channels this quick response applies to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChannels} method.
     * </p>
     * 
     * @return The Amazon Connect channels this quick response applies to.
     */
    public final List<String> channels() {
        return channels;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with
     * idempotent APIs</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *         provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see
     *         <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
     *         retries safe with idempotent APIs</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The content of the quick response.
     * </p>
     * 
     * @return The content of the quick response.
     */
    public final QuickResponseDataProvider content() {
        return content;
    }

    /**
     * <p>
     * The media type of the quick response content.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <code>application/x.quickresponse;format=plain</code> for a quick response written in plain text.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>application/x.quickresponse;format=markdown</code> for a quick response written in richtext.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The media type of the quick response content.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Use <code>application/x.quickresponse;format=plain</code> for a quick response written in plain text.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use <code>application/x.quickresponse;format=markdown</code> for a quick response written in richtext.
     *         </p>
     *         </li>
     */
    public final String contentType() {
        return contentType;
    }

    /**
     * <p>
     * The description of the quick response.
     * </p>
     * 
     * @return The description of the quick response.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The configuration information of the user groups that the quick response is accessible to.
     * </p>
     * 
     * @return The configuration information of the user groups that the quick response is accessible to.
     */
    public final GroupingConfiguration groupingConfiguration() {
        return groupingConfiguration;
    }

    /**
     * <p>
     * Whether the quick response is active.
     * </p>
     * 
     * @return Whether the quick response is active.
     */
    public final Boolean isActive() {
        return isActive;
    }

    /**
     * <p>
     * The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base if you're storing
     * Wisdom Content resource to it. Can be either the ID or the ARN. URLs cannot contain the ARN.
     * </p>
     * 
     * @return The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base if you're
     *         storing Wisdom Content resource to it. Can be either the ID or the ARN. URLs cannot contain the ARN.
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    /**
     * <p>
     * The language code value for the language in which the quick response is written. The supported language codes
     * include <code>de_DE</code>, <code>en_US</code>, <code>es_ES</code>, <code>fr_FR</code>, <code>id_ID</code>,
     * <code>it_IT</code>, <code>ja_JP</code>, <code>ko_KR</code>, <code>pt_BR</code>, <code>zh_CN</code>,
     * <code>zh_TW</code>
     * </p>
     * 
     * @return The language code value for the language in which the quick response is written. The supported language
     *         codes include <code>de_DE</code>, <code>en_US</code>, <code>es_ES</code>, <code>fr_FR</code>,
     *         <code>id_ID</code>, <code>it_IT</code>, <code>ja_JP</code>, <code>ko_KR</code>, <code>pt_BR</code>,
     *         <code>zh_CN</code>, <code>zh_TW</code>
     */
    public final String language() {
        return language;
    }

    /**
     * <p>
     * The name of the quick response.
     * </p>
     * 
     * @return The name of the quick response.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The shortcut key of the quick response. The value should be unique across the knowledge base.
     * </p>
     * 
     * @return The shortcut key of the quick response. The value should be unique across the knowledge base.
     */
    public final String shortcutKey() {
        return shortcutKey;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasChannels() ? channels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(groupingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(isActive());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(language());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(shortcutKey());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateQuickResponseRequest)) {
            return false;
        }
        CreateQuickResponseRequest other = (CreateQuickResponseRequest) obj;
        return hasChannels() == other.hasChannels() && Objects.equals(channels(), other.channels())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(content(), other.content())
                && Objects.equals(contentType(), other.contentType()) && Objects.equals(description(), other.description())
                && Objects.equals(groupingConfiguration(), other.groupingConfiguration())
                && Objects.equals(isActive(), other.isActive()) && Objects.equals(knowledgeBaseId(), other.knowledgeBaseId())
                && Objects.equals(language(), other.language()) && Objects.equals(name(), other.name())
                && Objects.equals(shortcutKey(), other.shortcutKey()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateQuickResponseRequest")
                .add("Channels", channels() == null ? null : "*** Sensitive Data Redacted ***").add("ClientToken", clientToken())
                .add("Content", content()).add("ContentType", contentType()).add("Description", description())
                .add("GroupingConfiguration", groupingConfiguration()).add("IsActive", isActive())
                .add("KnowledgeBaseId", knowledgeBaseId()).add("Language", language()).add("Name", name())
                .add("ShortcutKey", shortcutKey()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "channels":
            return Optional.ofNullable(clazz.cast(channels()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "groupingConfiguration":
            return Optional.ofNullable(clazz.cast(groupingConfiguration()));
        case "isActive":
            return Optional.ofNullable(clazz.cast(isActive()));
        case "knowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        case "language":
            return Optional.ofNullable(clazz.cast(language()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "shortcutKey":
            return Optional.ofNullable(clazz.cast(shortcutKey()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateQuickResponseRequest, T> g) {
        return obj -> g.apply((CreateQuickResponseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WisdomRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateQuickResponseRequest> {
        /**
         * <p>
         * The Amazon Connect channels this quick response applies to.
         * </p>
         * 
         * @param channels
         *        The Amazon Connect channels this quick response applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channels(Collection<String> channels);

        /**
         * <p>
         * The Amazon Connect channels this quick response applies to.
         * </p>
         * 
         * @param channels
         *        The Amazon Connect channels this quick response applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channels(String... channels);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         * provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
         * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe
         * with idempotent APIs</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         *        provided, the Amazon Web Services SDK populates this field. For more information about idempotency,
         *        see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
         *        retries safe with idempotent APIs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The content of the quick response.
         * </p>
         * 
         * @param content
         *        The content of the quick response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(QuickResponseDataProvider content);

        /**
         * <p>
         * The content of the quick response.
         * </p>
         * This is a convenience method that creates an instance of the {@link QuickResponseDataProvider.Builder}
         * avoiding the need to create one manually via {@link QuickResponseDataProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QuickResponseDataProvider.Builder#build()} is called immediately
         * and its result is passed to {@link #content(QuickResponseDataProvider)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link QuickResponseDataProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(QuickResponseDataProvider)
         */
        default Builder content(Consumer<QuickResponseDataProvider.Builder> content) {
            return content(QuickResponseDataProvider.builder().applyMutation(content).build());
        }

        /**
         * <p>
         * The media type of the quick response content.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Use <code>application/x.quickresponse;format=plain</code> for a quick response written in plain text.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use <code>application/x.quickresponse;format=markdown</code> for a quick response written in richtext.
         * </p>
         * </li>
         * </ul>
         * 
         * @param contentType
         *        The media type of the quick response content.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Use <code>application/x.quickresponse;format=plain</code> for a quick response written in plain text.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use <code>application/x.quickresponse;format=markdown</code> for a quick response written in richtext.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * The description of the quick response.
         * </p>
         * 
         * @param description
         *        The description of the quick response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The configuration information of the user groups that the quick response is accessible to.
         * </p>
         * 
         * @param groupingConfiguration
         *        The configuration information of the user groups that the quick response is accessible to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupingConfiguration(GroupingConfiguration groupingConfiguration);

        /**
         * <p>
         * The configuration information of the user groups that the quick response is accessible to.
         * </p>
         * This is a convenience method that creates an instance of the {@link GroupingConfiguration.Builder} avoiding
         * the need to create one manually via {@link GroupingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GroupingConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #groupingConfiguration(GroupingConfiguration)}.
         * 
         * @param groupingConfiguration
         *        a consumer that will call methods on {@link GroupingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupingConfiguration(GroupingConfiguration)
         */
        default Builder groupingConfiguration(Consumer<GroupingConfiguration.Builder> groupingConfiguration) {
            return groupingConfiguration(GroupingConfiguration.builder().applyMutation(groupingConfiguration).build());
        }

        /**
         * <p>
         * Whether the quick response is active.
         * </p>
         * 
         * @param isActive
         *        Whether the quick response is active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isActive(Boolean isActive);

        /**
         * <p>
         * The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base if you're
         * storing Wisdom Content resource to it. Can be either the ID or the ARN. URLs cannot contain the ARN.
         * </p>
         * 
         * @param knowledgeBaseId
         *        The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base if
         *        you're storing Wisdom Content resource to it. Can be either the ID or the ARN. URLs cannot contain the
         *        ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        /**
         * <p>
         * The language code value for the language in which the quick response is written. The supported language codes
         * include <code>de_DE</code>, <code>en_US</code>, <code>es_ES</code>, <code>fr_FR</code>, <code>id_ID</code>,
         * <code>it_IT</code>, <code>ja_JP</code>, <code>ko_KR</code>, <code>pt_BR</code>, <code>zh_CN</code>,
         * <code>zh_TW</code>
         * </p>
         * 
         * @param language
         *        The language code value for the language in which the quick response is written. The supported
         *        language codes include <code>de_DE</code>, <code>en_US</code>, <code>es_ES</code>, <code>fr_FR</code>,
         *        <code>id_ID</code>, <code>it_IT</code>, <code>ja_JP</code>, <code>ko_KR</code>, <code>pt_BR</code>,
         *        <code>zh_CN</code>, <code>zh_TW</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder language(String language);

        /**
         * <p>
         * The name of the quick response.
         * </p>
         * 
         * @param name
         *        The name of the quick response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The shortcut key of the quick response. The value should be unique across the knowledge base.
         * </p>
         * 
         * @param shortcutKey
         *        The shortcut key of the quick response. The value should be unique across the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shortcutKey(String shortcutKey);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WisdomRequest.BuilderImpl implements Builder {
        private List<String> channels = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private QuickResponseDataProvider content;

        private String contentType;

        private String description;

        private GroupingConfiguration groupingConfiguration;

        private Boolean isActive;

        private String knowledgeBaseId;

        private String language;

        private String name;

        private String shortcutKey;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateQuickResponseRequest model) {
            super(model);
            channels(model.channels);
            clientToken(model.clientToken);
            content(model.content);
            contentType(model.contentType);
            description(model.description);
            groupingConfiguration(model.groupingConfiguration);
            isActive(model.isActive);
            knowledgeBaseId(model.knowledgeBaseId);
            language(model.language);
            name(model.name);
            shortcutKey(model.shortcutKey);
            tags(model.tags);
        }

        public final Collection<String> getChannels() {
            if (channels instanceof SdkAutoConstructList) {
                return null;
            }
            return channels;
        }

        public final void setChannels(Collection<String> channels) {
            this.channels = ChannelsCopier.copy(channels);
        }

        @Override
        public final Builder channels(Collection<String> channels) {
            this.channels = ChannelsCopier.copy(channels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channels(String... channels) {
            channels(Arrays.asList(channels));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final QuickResponseDataProvider.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(QuickResponseDataProvider.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(QuickResponseDataProvider content) {
            this.content = content;
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final GroupingConfiguration.Builder getGroupingConfiguration() {
            return groupingConfiguration != null ? groupingConfiguration.toBuilder() : null;
        }

        public final void setGroupingConfiguration(GroupingConfiguration.BuilderImpl groupingConfiguration) {
            this.groupingConfiguration = groupingConfiguration != null ? groupingConfiguration.build() : null;
        }

        @Override
        public final Builder groupingConfiguration(GroupingConfiguration groupingConfiguration) {
            this.groupingConfiguration = groupingConfiguration;
            return this;
        }

        public final Boolean getIsActive() {
            return isActive;
        }

        public final void setIsActive(Boolean isActive) {
            this.isActive = isActive;
        }

        @Override
        public final Builder isActive(Boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getLanguage() {
            return language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getShortcutKey() {
            return shortcutKey;
        }

        public final void setShortcutKey(String shortcutKey) {
            this.shortcutKey = shortcutKey;
        }

        @Override
        public final Builder shortcutKey(String shortcutKey) {
            this.shortcutKey = shortcutKey;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateQuickResponseRequest build() {
            return new CreateQuickResponseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
