/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wisdom.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wisdom.WisdomAsyncClient;
import software.amazon.awssdk.services.wisdom.model.QueryAssistantRequest;
import software.amazon.awssdk.services.wisdom.model.QueryAssistantResponse;
import software.amazon.awssdk.services.wisdom.model.ResultData;

public class QueryAssistantPublisher
implements SdkPublisher<QueryAssistantResponse> {
    private final WisdomAsyncClient client;
    private final QueryAssistantRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public QueryAssistantPublisher(WisdomAsyncClient client, QueryAssistantRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private QueryAssistantPublisher(WisdomAsyncClient client, QueryAssistantRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new QueryAssistantResponseFetcher();
    }

    public void subscribe(Subscriber<? super QueryAssistantResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ResultData> results() {
        Function<QueryAssistantResponse, Iterator> getIterator = response -> {
            if (response != null && response.results() != null) {
                return response.results().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new QueryAssistantResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class QueryAssistantResponseFetcher
    implements AsyncPageFetcher<QueryAssistantResponse> {
        private QueryAssistantResponseFetcher() {
        }

        public boolean hasNextPage(QueryAssistantResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<QueryAssistantResponse> nextPage(QueryAssistantResponse previousPage) {
            if (previousPage == null) {
                return QueryAssistantPublisher.this.client.queryAssistant(QueryAssistantPublisher.this.firstRequest);
            }
            return QueryAssistantPublisher.this.client.queryAssistant((QueryAssistantRequest)((Object)QueryAssistantPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

