/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wisdom.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wisdom.WisdomClient;
import software.amazon.awssdk.services.wisdom.model.ContentSummary;
import software.amazon.awssdk.services.wisdom.model.ListContentsRequest;
import software.amazon.awssdk.services.wisdom.model.ListContentsResponse;

public class ListContentsIterable
implements SdkIterable<ListContentsResponse> {
    private final WisdomClient client;
    private final ListContentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListContentsIterable(WisdomClient client, ListContentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListContentsResponseFetcher();
    }

    public Iterator<ListContentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ContentSummary> contentSummaries() {
        Function<ListContentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.contentSummaries() != null) {
                return response.contentSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListContentsResponseFetcher
    implements SyncPageFetcher<ListContentsResponse> {
        private ListContentsResponseFetcher() {
        }

        public boolean hasNextPage(ListContentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListContentsResponse nextPage(ListContentsResponse previousPage) {
            if (previousPage == null) {
                return ListContentsIterable.this.client.listContents(ListContentsIterable.this.firstRequest);
            }
            return ListContentsIterable.this.client.listContents((ListContentsRequest)((Object)ListContentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

