/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wisdom.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the content.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContentData implements SdkPojo, Serializable, ToCopyableBuilder<ContentData.Builder, ContentData> {
    private static final SdkField<String> CONTENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentArn").getter(getter(ContentData::contentArn)).setter(setter(Builder::contentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentArn").build()).build();

    private static final SdkField<String> CONTENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentId").getter(getter(ContentData::contentId)).setter(setter(Builder::contentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentId").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentType").getter(getter(ContentData::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentType").build()).build();

    private static final SdkField<String> KNOWLEDGE_BASE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseArn").getter(getter(ContentData::knowledgeBaseArn))
            .setter(setter(Builder::knowledgeBaseArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseArn").build()).build();

    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseId").getter(getter(ContentData::knowledgeBaseId)).setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()).build();

    private static final SdkField<String> LINK_OUT_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("linkOutUri").getter(getter(ContentData::linkOutUri)).setter(setter(Builder::linkOutUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("linkOutUri").build()).build();

    private static final SdkField<Map<String, String>> METADATA_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("metadata")
            .getter(getter(ContentData::metadata))
            .setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ContentData::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revisionId").getter(getter(ContentData::revisionId)).setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ContentData::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(ContentData::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(ContentData::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("url")
            .getter(getter(ContentData::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()).build();

    private static final SdkField<Instant> URL_EXPIRY_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("urlExpiry")
            .getter(getter(ContentData::urlExpiry))
            .setter(setter(Builder::urlExpiry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("urlExpiry").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.UNIX_TIMESTAMP)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_ARN_FIELD,
            CONTENT_ID_FIELD, CONTENT_TYPE_FIELD, KNOWLEDGE_BASE_ARN_FIELD, KNOWLEDGE_BASE_ID_FIELD, LINK_OUT_URI_FIELD,
            METADATA_FIELD, NAME_FIELD, REVISION_ID_FIELD, STATUS_FIELD, TAGS_FIELD, TITLE_FIELD, URL_FIELD, URL_EXPIRY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String contentArn;

    private final String contentId;

    private final String contentType;

    private final String knowledgeBaseArn;

    private final String knowledgeBaseId;

    private final String linkOutUri;

    private final Map<String, String> metadata;

    private final String name;

    private final String revisionId;

    private final String status;

    private final Map<String, String> tags;

    private final String title;

    private final String url;

    private final Instant urlExpiry;

    private ContentData(BuilderImpl builder) {
        this.contentArn = builder.contentArn;
        this.contentId = builder.contentId;
        this.contentType = builder.contentType;
        this.knowledgeBaseArn = builder.knowledgeBaseArn;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.linkOutUri = builder.linkOutUri;
        this.metadata = builder.metadata;
        this.name = builder.name;
        this.revisionId = builder.revisionId;
        this.status = builder.status;
        this.tags = builder.tags;
        this.title = builder.title;
        this.url = builder.url;
        this.urlExpiry = builder.urlExpiry;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the content.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the content.
     */
    public final String contentArn() {
        return contentArn;
    }

    /**
     * <p>
     * The identifier of the content.
     * </p>
     * 
     * @return The identifier of the content.
     */
    public final String contentId() {
        return contentId;
    }

    /**
     * <p>
     * The media type of the content.
     * </p>
     * 
     * @return The media type of the content.
     */
    public final String contentType() {
        return contentType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the knowledge base.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the knowledge base.
     */
    public final String knowledgeBaseArn() {
        return knowledgeBaseArn;
    }

    /**
     * <p>
     * The the identifier of the knowledge base.
     * </p>
     * 
     * @return The the identifier of the knowledge base.
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    /**
     * <p>
     * The URI of the content.
     * </p>
     * 
     * @return The URI of the content.
     */
    public final String linkOutUri() {
        return linkOutUri;
    }

    /**
     * For responses, this returns true if the service returned a value for the Metadata property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetadata() {
        return metadata != null && !(metadata instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A key/value map to store attributes without affecting tagging or recommendations. For example, when synchronizing
     * data between an external system and Wisdom, you can store an external version identifier as metadata to utilize
     * for determining drift.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetadata} method.
     * </p>
     * 
     * @return A key/value map to store attributes without affecting tagging or recommendations. For example, when
     *         synchronizing data between an external system and Wisdom, you can store an external version identifier as
     *         metadata to utilize for determining drift.
     */
    public final Map<String, String> metadata() {
        return metadata;
    }

    /**
     * <p>
     * The name of the content.
     * </p>
     * 
     * @return The name of the content.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The identifier of the content revision.
     * </p>
     * 
     * @return The identifier of the content revision.
     */
    public final String revisionId() {
        return revisionId;
    }

    /**
     * <p>
     * The status of the content.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ContentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the content.
     * @see ContentStatus
     */
    public final ContentStatus status() {
        return ContentStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the content.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ContentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the content.
     * @see ContentStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The title of the content.
     * </p>
     * 
     * @return The title of the content.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The URL of the content.
     * </p>
     * 
     * @return The URL of the content.
     */
    public final String url() {
        return url;
    }

    /**
     * <p>
     * The expiration time of the URL as an epoch timestamp.
     * </p>
     * 
     * @return The expiration time of the URL as an epoch timestamp.
     */
    public final Instant urlExpiry() {
        return urlExpiry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contentArn());
        hashCode = 31 * hashCode + Objects.hashCode(contentId());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseArn());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(linkOutUri());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetadata() ? metadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(urlExpiry());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentData)) {
            return false;
        }
        ContentData other = (ContentData) obj;
        return Objects.equals(contentArn(), other.contentArn()) && Objects.equals(contentId(), other.contentId())
                && Objects.equals(contentType(), other.contentType())
                && Objects.equals(knowledgeBaseArn(), other.knowledgeBaseArn())
                && Objects.equals(knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(linkOutUri(), other.linkOutUri())
                && hasMetadata() == other.hasMetadata() && Objects.equals(metadata(), other.metadata())
                && Objects.equals(name(), other.name()) && Objects.equals(revisionId(), other.revisionId())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(title(), other.title())
                && Objects.equals(url(), other.url()) && Objects.equals(urlExpiry(), other.urlExpiry());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContentData").add("ContentArn", contentArn()).add("ContentId", contentId())
                .add("ContentType", contentType()).add("KnowledgeBaseArn", knowledgeBaseArn())
                .add("KnowledgeBaseId", knowledgeBaseId()).add("LinkOutUri", linkOutUri())
                .add("Metadata", hasMetadata() ? metadata() : null).add("Name", name()).add("RevisionId", revisionId())
                .add("Status", statusAsString()).add("Tags", hasTags() ? tags() : null).add("Title", title())
                .add("Url", url() == null ? null : "*** Sensitive Data Redacted ***").add("UrlExpiry", urlExpiry()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contentArn":
            return Optional.ofNullable(clazz.cast(contentArn()));
        case "contentId":
            return Optional.ofNullable(clazz.cast(contentId()));
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "knowledgeBaseArn":
            return Optional.ofNullable(clazz.cast(knowledgeBaseArn()));
        case "knowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        case "linkOutUri":
            return Optional.ofNullable(clazz.cast(linkOutUri()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "revisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "url":
            return Optional.ofNullable(clazz.cast(url()));
        case "urlExpiry":
            return Optional.ofNullable(clazz.cast(urlExpiry()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContentData, T> g) {
        return obj -> g.apply((ContentData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContentData> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the content.
         * </p>
         * 
         * @param contentArn
         *        The Amazon Resource Name (ARN) of the content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentArn(String contentArn);

        /**
         * <p>
         * The identifier of the content.
         * </p>
         * 
         * @param contentId
         *        The identifier of the content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentId(String contentId);

        /**
         * <p>
         * The media type of the content.
         * </p>
         * 
         * @param contentType
         *        The media type of the content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the knowledge base.
         * </p>
         * 
         * @param knowledgeBaseArn
         *        The Amazon Resource Name (ARN) of the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseArn(String knowledgeBaseArn);

        /**
         * <p>
         * The the identifier of the knowledge base.
         * </p>
         * 
         * @param knowledgeBaseId
         *        The the identifier of the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        /**
         * <p>
         * The URI of the content.
         * </p>
         * 
         * @param linkOutUri
         *        The URI of the content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkOutUri(String linkOutUri);

        /**
         * <p>
         * A key/value map to store attributes without affecting tagging or recommendations. For example, when
         * synchronizing data between an external system and Wisdom, you can store an external version identifier as
         * metadata to utilize for determining drift.
         * </p>
         * 
         * @param metadata
         *        A key/value map to store attributes without affecting tagging or recommendations. For example, when
         *        synchronizing data between an external system and Wisdom, you can store an external version identifier
         *        as metadata to utilize for determining drift.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(Map<String, String> metadata);

        /**
         * <p>
         * The name of the content.
         * </p>
         * 
         * @param name
         *        The name of the content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The identifier of the content revision.
         * </p>
         * 
         * @param revisionId
         *        The identifier of the content revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);

        /**
         * <p>
         * The status of the content.
         * </p>
         * 
         * @param status
         *        The status of the content.
         * @see ContentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the content.
         * </p>
         * 
         * @param status
         *        The status of the content.
         * @see ContentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentStatus
         */
        Builder status(ContentStatus status);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The title of the content.
         * </p>
         * 
         * @param title
         *        The title of the content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The URL of the content.
         * </p>
         * 
         * @param url
         *        The URL of the content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * The expiration time of the URL as an epoch timestamp.
         * </p>
         * 
         * @param urlExpiry
         *        The expiration time of the URL as an epoch timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder urlExpiry(Instant urlExpiry);
    }

    static final class BuilderImpl implements Builder {
        private String contentArn;

        private String contentId;

        private String contentType;

        private String knowledgeBaseArn;

        private String knowledgeBaseId;

        private String linkOutUri;

        private Map<String, String> metadata = DefaultSdkAutoConstructMap.getInstance();

        private String name;

        private String revisionId;

        private String status;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String title;

        private String url;

        private Instant urlExpiry;

        private BuilderImpl() {
        }

        private BuilderImpl(ContentData model) {
            contentArn(model.contentArn);
            contentId(model.contentId);
            contentType(model.contentType);
            knowledgeBaseArn(model.knowledgeBaseArn);
            knowledgeBaseId(model.knowledgeBaseId);
            linkOutUri(model.linkOutUri);
            metadata(model.metadata);
            name(model.name);
            revisionId(model.revisionId);
            status(model.status);
            tags(model.tags);
            title(model.title);
            url(model.url);
            urlExpiry(model.urlExpiry);
        }

        public final String getContentArn() {
            return contentArn;
        }

        public final void setContentArn(String contentArn) {
            this.contentArn = contentArn;
        }

        @Override
        @Transient
        public final Builder contentArn(String contentArn) {
            this.contentArn = contentArn;
            return this;
        }

        public final String getContentId() {
            return contentId;
        }

        public final void setContentId(String contentId) {
            this.contentId = contentId;
        }

        @Override
        @Transient
        public final Builder contentId(String contentId) {
            this.contentId = contentId;
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        @Transient
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getKnowledgeBaseArn() {
            return knowledgeBaseArn;
        }

        public final void setKnowledgeBaseArn(String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
        }

        @Override
        @Transient
        public final Builder knowledgeBaseArn(String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        @Transient
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getLinkOutUri() {
            return linkOutUri;
        }

        public final void setLinkOutUri(String linkOutUri) {
            this.linkOutUri = linkOutUri;
        }

        @Override
        @Transient
        public final Builder linkOutUri(String linkOutUri) {
            this.linkOutUri = linkOutUri;
            return this;
        }

        public final Map<String, String> getMetadata() {
            if (metadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return metadata;
        }

        public final void setMetadata(Map<String, String> metadata) {
            this.metadata = ContentMetadataCopier.copy(metadata);
        }

        @Override
        @Transient
        public final Builder metadata(Map<String, String> metadata) {
            this.metadata = ContentMetadataCopier.copy(metadata);
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        @Transient
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(ContentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        @Transient
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        @Transient
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final Instant getUrlExpiry() {
            return urlExpiry;
        }

        public final void setUrlExpiry(Instant urlExpiry) {
            this.urlExpiry = urlExpiry;
        }

        @Override
        @Transient
        public final Builder urlExpiry(Instant urlExpiry) {
            this.urlExpiry = urlExpiry;
            return this;
        }

        @Override
        public ContentData build() {
            return new ContentData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
