/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wisdom.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data that is output as a result of the assistant association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssistantAssociationOutputData implements SdkPojo, Serializable,
        ToCopyableBuilder<AssistantAssociationOutputData.Builder, AssistantAssociationOutputData> {
    private static final SdkField<KnowledgeBaseAssociationData> KNOWLEDGE_BASE_ASSOCIATION_FIELD = SdkField
            .<KnowledgeBaseAssociationData> builder(MarshallingType.SDK_POJO).memberName("knowledgeBaseAssociation")
            .getter(getter(AssistantAssociationOutputData::knowledgeBaseAssociation))
            .setter(setter(Builder::knowledgeBaseAssociation)).constructor(KnowledgeBaseAssociationData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseAssociation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(KNOWLEDGE_BASE_ASSOCIATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final KnowledgeBaseAssociationData knowledgeBaseAssociation;

    private AssistantAssociationOutputData(BuilderImpl builder) {
        this.knowledgeBaseAssociation = builder.knowledgeBaseAssociation;
    }

    /**
     * <p>
     * The knowledge base where output data is sent.
     * </p>
     * 
     * @return The knowledge base where output data is sent.
     */
    public final KnowledgeBaseAssociationData knowledgeBaseAssociation() {
        return knowledgeBaseAssociation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseAssociation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssistantAssociationOutputData)) {
            return false;
        }
        AssistantAssociationOutputData other = (AssistantAssociationOutputData) obj;
        return Objects.equals(knowledgeBaseAssociation(), other.knowledgeBaseAssociation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssistantAssociationOutputData").add("KnowledgeBaseAssociation", knowledgeBaseAssociation())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "knowledgeBaseAssociation":
            return Optional.ofNullable(clazz.cast(knowledgeBaseAssociation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssistantAssociationOutputData, T> g) {
        return obj -> g.apply((AssistantAssociationOutputData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssistantAssociationOutputData> {
        /**
         * <p>
         * The knowledge base where output data is sent.
         * </p>
         * 
         * @param knowledgeBaseAssociation
         *        The knowledge base where output data is sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseAssociation(KnowledgeBaseAssociationData knowledgeBaseAssociation);

        /**
         * <p>
         * The knowledge base where output data is sent.
         * </p>
         * This is a convenience that creates an instance of the {@link KnowledgeBaseAssociationData.Builder} avoiding
         * the need to create one manually via {@link KnowledgeBaseAssociationData#builder()}.
         *
         * When the {@link Consumer} completes, {@link KnowledgeBaseAssociationData.Builder#build()} is called
         * immediately and its result is passed to {@link #knowledgeBaseAssociation(KnowledgeBaseAssociationData)}.
         * 
         * @param knowledgeBaseAssociation
         *        a consumer that will call methods on {@link KnowledgeBaseAssociationData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #knowledgeBaseAssociation(KnowledgeBaseAssociationData)
         */
        default Builder knowledgeBaseAssociation(Consumer<KnowledgeBaseAssociationData.Builder> knowledgeBaseAssociation) {
            return knowledgeBaseAssociation(KnowledgeBaseAssociationData.builder().applyMutation(knowledgeBaseAssociation)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private KnowledgeBaseAssociationData knowledgeBaseAssociation;

        private BuilderImpl() {
        }

        private BuilderImpl(AssistantAssociationOutputData model) {
            knowledgeBaseAssociation(model.knowledgeBaseAssociation);
        }

        public final KnowledgeBaseAssociationData.Builder getKnowledgeBaseAssociation() {
            return knowledgeBaseAssociation != null ? knowledgeBaseAssociation.toBuilder() : null;
        }

        public final void setKnowledgeBaseAssociation(KnowledgeBaseAssociationData.BuilderImpl knowledgeBaseAssociation) {
            this.knowledgeBaseAssociation = knowledgeBaseAssociation != null ? knowledgeBaseAssociation.build() : null;
        }

        @Override
        @Transient
        public final Builder knowledgeBaseAssociation(KnowledgeBaseAssociationData knowledgeBaseAssociation) {
            this.knowledgeBaseAssociation = knowledgeBaseAssociation;
            return this;
        }

        @Override
        public AssistantAssociationOutputData build() {
            return new AssistantAssociationOutputData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
