/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wisdom.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wisdom.model.SessionSummariesCopier;
import software.amazon.awssdk.services.wisdom.model.SessionSummary;
import software.amazon.awssdk.services.wisdom.model.WisdomResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchSessionsResponse
extends WisdomResponse
implements ToCopyableBuilder<Builder, SearchSessionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(SearchSessionsResponse.getter(SearchSessionsResponse::nextToken)).setter(SearchSessionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<SessionSummary>> SESSION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sessionSummaries").getter(SearchSessionsResponse.getter(SearchSessionsResponse::sessionSummaries)).setter(SearchSessionsResponse.setter(Builder::sessionSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SessionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SESSION_SUMMARIES_FIELD));
    private final String nextToken;
    private final List<SessionSummary> sessionSummaries;

    private SearchSessionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.sessionSummaries = builder.sessionSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasSessionSummaries() {
        return this.sessionSummaries != null && !(this.sessionSummaries instanceof SdkAutoConstructList);
    }

    public final List<SessionSummary> sessionSummaries() {
        return this.sessionSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSessionSummaries() ? this.sessionSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchSessionsResponse)) {
            return false;
        }
        SearchSessionsResponse other = (SearchSessionsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasSessionSummaries() == other.hasSessionSummaries() && Objects.equals(this.sessionSummaries(), other.sessionSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"SearchSessionsResponse").add("NextToken", (Object)this.nextToken()).add("SessionSummaries", this.hasSessionSummaries() ? this.sessionSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "sessionSummaries": {
                return Optional.ofNullable(clazz.cast(this.sessionSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchSessionsResponse, T> g) {
        return obj -> g.apply((SearchSessionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WisdomResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<SessionSummary> sessionSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchSessionsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.sessionSummaries(model.sessionSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SessionSummary.Builder> getSessionSummaries() {
            List<SessionSummary.Builder> result = SessionSummariesCopier.copyToBuilder(this.sessionSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSessionSummaries(Collection<SessionSummary.BuilderImpl> sessionSummaries) {
            this.sessionSummaries = SessionSummariesCopier.copyFromBuilder(sessionSummaries);
        }

        @Override
        @Transient
        public final Builder sessionSummaries(Collection<SessionSummary> sessionSummaries) {
            this.sessionSummaries = SessionSummariesCopier.copy(sessionSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sessionSummaries(SessionSummary ... sessionSummaries) {
            this.sessionSummaries(Arrays.asList(sessionSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sessionSummaries(Consumer<SessionSummary.Builder> ... sessionSummaries) {
            this.sessionSummaries(Stream.of(sessionSummaries).map(c -> (SessionSummary)((SessionSummary.Builder)SessionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SearchSessionsResponse build() {
            return new SearchSessionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WisdomResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchSessionsResponse> {
        public Builder nextToken(String var1);

        public Builder sessionSummaries(Collection<SessionSummary> var1);

        public Builder sessionSummaries(SessionSummary ... var1);

        public Builder sessionSummaries(Consumer<SessionSummary.Builder> ... var1);
    }
}

