/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateShareInvitationResponse extends WellArchitectedResponse implements
        ToCopyableBuilder<UpdateShareInvitationResponse.Builder, UpdateShareInvitationResponse> {
    private static final SdkField<ShareInvitation> SHARE_INVITATION_FIELD = SdkField
            .<ShareInvitation> builder(MarshallingType.SDK_POJO).memberName("ShareInvitation")
            .getter(getter(UpdateShareInvitationResponse::shareInvitation)).setter(setter(Builder::shareInvitation))
            .constructor(ShareInvitation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareInvitation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARE_INVITATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ShareInvitation shareInvitation;

    private UpdateShareInvitationResponse(BuilderImpl builder) {
        super(builder);
        this.shareInvitation = builder.shareInvitation;
    }

    /**
     * <p>
     * The updated workload or custom lens share invitation.
     * </p>
     * 
     * @return The updated workload or custom lens share invitation.
     */
    public final ShareInvitation shareInvitation() {
        return shareInvitation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(shareInvitation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateShareInvitationResponse)) {
            return false;
        }
        UpdateShareInvitationResponse other = (UpdateShareInvitationResponse) obj;
        return Objects.equals(shareInvitation(), other.shareInvitation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateShareInvitationResponse").add("ShareInvitation", shareInvitation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ShareInvitation":
            return Optional.ofNullable(clazz.cast(shareInvitation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ShareInvitation", SHARE_INVITATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateShareInvitationResponse, T> g) {
        return obj -> g.apply((UpdateShareInvitationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WellArchitectedResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateShareInvitationResponse> {
        /**
         * <p>
         * The updated workload or custom lens share invitation.
         * </p>
         * 
         * @param shareInvitation
         *        The updated workload or custom lens share invitation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareInvitation(ShareInvitation shareInvitation);

        /**
         * <p>
         * The updated workload or custom lens share invitation.
         * </p>
         * This is a convenience method that creates an instance of the {@link ShareInvitation.Builder} avoiding the
         * need to create one manually via {@link ShareInvitation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ShareInvitation.Builder#build()} is called immediately and its
         * result is passed to {@link #shareInvitation(ShareInvitation)}.
         * 
         * @param shareInvitation
         *        a consumer that will call methods on {@link ShareInvitation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #shareInvitation(ShareInvitation)
         */
        default Builder shareInvitation(Consumer<ShareInvitation.Builder> shareInvitation) {
            return shareInvitation(ShareInvitation.builder().applyMutation(shareInvitation).build());
        }
    }

    static final class BuilderImpl extends WellArchitectedResponse.BuilderImpl implements Builder {
        private ShareInvitation shareInvitation;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateShareInvitationResponse model) {
            super(model);
            shareInvitation(model.shareInvitation);
        }

        public final ShareInvitation.Builder getShareInvitation() {
            return shareInvitation != null ? shareInvitation.toBuilder() : null;
        }

        public final void setShareInvitation(ShareInvitation.BuilderImpl shareInvitation) {
            this.shareInvitation = shareInvitation != null ? shareInvitation.build() : null;
        }

        @Override
        public final Builder shareInvitation(ShareInvitation shareInvitation) {
            this.shareInvitation = shareInvitation;
            return this;
        }

        @Override
        public UpdateShareInvitationResponse build() {
            return new UpdateShareInvitationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
