/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateReviewTemplateLensReviewRequest extends WellArchitectedRequest implements
        ToCopyableBuilder<UpdateReviewTemplateLensReviewRequest.Builder, UpdateReviewTemplateLensReviewRequest> {
    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateArn").getter(getter(UpdateReviewTemplateLensReviewRequest::templateArn))
            .setter(setter(Builder::templateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("TemplateArn").build()).build();

    private static final SdkField<String> LENS_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensAlias").getter(getter(UpdateReviewTemplateLensReviewRequest::lensAlias))
            .setter(setter(Builder::lensAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("LensAlias").build()).build();

    private static final SdkField<String> LENS_NOTES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensNotes").getter(getter(UpdateReviewTemplateLensReviewRequest::lensNotes))
            .setter(setter(Builder::lensNotes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensNotes").build()).build();

    private static final SdkField<Map<String, String>> PILLAR_NOTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("PillarNotes")
            .getter(getter(UpdateReviewTemplateLensReviewRequest::pillarNotes))
            .setter(setter(Builder::pillarNotes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PillarNotes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_ARN_FIELD,
            LENS_ALIAS_FIELD, LENS_NOTES_FIELD, PILLAR_NOTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String templateArn;

    private final String lensAlias;

    private final String lensNotes;

    private final Map<String, String> pillarNotes;

    private UpdateReviewTemplateLensReviewRequest(BuilderImpl builder) {
        super(builder);
        this.templateArn = builder.templateArn;
        this.lensAlias = builder.lensAlias;
        this.lensNotes = builder.lensNotes;
        this.pillarNotes = builder.pillarNotes;
    }

    /**
     * <p>
     * The review template ARN.
     * </p>
     * 
     * @return The review template ARN.
     */
    public final String templateArn() {
        return templateArn;
    }

    /**
     * Returns the value of the LensAlias property for this object.
     * 
     * @return The value of the LensAlias property for this object.
     */
    public final String lensAlias() {
        return lensAlias;
    }

    /**
     * Returns the value of the LensNotes property for this object.
     * 
     * @return The value of the LensNotes property for this object.
     */
    public final String lensNotes() {
        return lensNotes;
    }

    /**
     * For responses, this returns true if the service returned a value for the PillarNotes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPillarNotes() {
        return pillarNotes != null && !(pillarNotes instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the PillarNotes property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPillarNotes} method.
     * </p>
     * 
     * @return The value of the PillarNotes property for this object.
     */
    public final Map<String, String> pillarNotes() {
        return pillarNotes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(templateArn());
        hashCode = 31 * hashCode + Objects.hashCode(lensAlias());
        hashCode = 31 * hashCode + Objects.hashCode(lensNotes());
        hashCode = 31 * hashCode + Objects.hashCode(hasPillarNotes() ? pillarNotes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateReviewTemplateLensReviewRequest)) {
            return false;
        }
        UpdateReviewTemplateLensReviewRequest other = (UpdateReviewTemplateLensReviewRequest) obj;
        return Objects.equals(templateArn(), other.templateArn()) && Objects.equals(lensAlias(), other.lensAlias())
                && Objects.equals(lensNotes(), other.lensNotes()) && hasPillarNotes() == other.hasPillarNotes()
                && Objects.equals(pillarNotes(), other.pillarNotes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateReviewTemplateLensReviewRequest").add("TemplateArn", templateArn())
                .add("LensAlias", lensAlias()).add("LensNotes", lensNotes())
                .add("PillarNotes", hasPillarNotes() ? pillarNotes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplateArn":
            return Optional.ofNullable(clazz.cast(templateArn()));
        case "LensAlias":
            return Optional.ofNullable(clazz.cast(lensAlias()));
        case "LensNotes":
            return Optional.ofNullable(clazz.cast(lensNotes()));
        case "PillarNotes":
            return Optional.ofNullable(clazz.cast(pillarNotes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TemplateArn", TEMPLATE_ARN_FIELD);
        map.put("LensAlias", LENS_ALIAS_FIELD);
        map.put("LensNotes", LENS_NOTES_FIELD);
        map.put("PillarNotes", PILLAR_NOTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateReviewTemplateLensReviewRequest, T> g) {
        return obj -> g.apply((UpdateReviewTemplateLensReviewRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WellArchitectedRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateReviewTemplateLensReviewRequest> {
        /**
         * <p>
         * The review template ARN.
         * </p>
         * 
         * @param templateArn
         *        The review template ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateArn(String templateArn);

        /**
         * Sets the value of the LensAlias property for this object.
         *
         * @param lensAlias
         *        The new value for the LensAlias property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensAlias(String lensAlias);

        /**
         * Sets the value of the LensNotes property for this object.
         *
         * @param lensNotes
         *        The new value for the LensNotes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensNotes(String lensNotes);

        /**
         * Sets the value of the PillarNotes property for this object.
         *
         * @param pillarNotes
         *        The new value for the PillarNotes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pillarNotes(Map<String, String> pillarNotes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WellArchitectedRequest.BuilderImpl implements Builder {
        private String templateArn;

        private String lensAlias;

        private String lensNotes;

        private Map<String, String> pillarNotes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateReviewTemplateLensReviewRequest model) {
            super(model);
            templateArn(model.templateArn);
            lensAlias(model.lensAlias);
            lensNotes(model.lensNotes);
            pillarNotes(model.pillarNotes);
        }

        public final String getTemplateArn() {
            return templateArn;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        @Override
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        public final String getLensAlias() {
            return lensAlias;
        }

        public final void setLensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
        }

        @Override
        public final Builder lensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
            return this;
        }

        public final String getLensNotes() {
            return lensNotes;
        }

        public final void setLensNotes(String lensNotes) {
            this.lensNotes = lensNotes;
        }

        @Override
        public final Builder lensNotes(String lensNotes) {
            this.lensNotes = lensNotes;
            return this;
        }

        public final Map<String, String> getPillarNotes() {
            if (pillarNotes instanceof SdkAutoConstructMap) {
                return null;
            }
            return pillarNotes;
        }

        public final void setPillarNotes(Map<String, String> pillarNotes) {
            this.pillarNotes = PillarNotesCopier.copy(pillarNotes);
        }

        @Override
        public final Builder pillarNotes(Map<String, String> pillarNotes) {
            this.pillarNotes = PillarNotesCopier.copy(pillarNotes);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateReviewTemplateLensReviewRequest build() {
            return new UpdateReviewTemplateLensReviewRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
