/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The selected pillar.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SelectedPillar implements SdkPojo, Serializable, ToCopyableBuilder<SelectedPillar.Builder, SelectedPillar> {
    private static final SdkField<String> PILLAR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PillarId").getter(getter(SelectedPillar::pillarId)).setter(setter(Builder::pillarId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PillarId").build()).build();

    private static final SdkField<List<String>> SELECTED_QUESTION_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SelectedQuestionIds")
            .getter(getter(SelectedPillar::selectedQuestionIds))
            .setter(setter(Builder::selectedQuestionIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedQuestionIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PILLAR_ID_FIELD,
            SELECTED_QUESTION_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String pillarId;

    private final List<String> selectedQuestionIds;

    private SelectedPillar(BuilderImpl builder) {
        this.pillarId = builder.pillarId;
        this.selectedQuestionIds = builder.selectedQuestionIds;
    }

    /**
     * Returns the value of the PillarId property for this object.
     * 
     * @return The value of the PillarId property for this object.
     */
    public final String pillarId() {
        return pillarId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SelectedQuestionIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSelectedQuestionIds() {
        return selectedQuestionIds != null && !(selectedQuestionIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Selected question IDs in the selected pillar.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSelectedQuestionIds} method.
     * </p>
     * 
     * @return Selected question IDs in the selected pillar.
     */
    public final List<String> selectedQuestionIds() {
        return selectedQuestionIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pillarId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSelectedQuestionIds() ? selectedQuestionIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelectedPillar)) {
            return false;
        }
        SelectedPillar other = (SelectedPillar) obj;
        return Objects.equals(pillarId(), other.pillarId()) && hasSelectedQuestionIds() == other.hasSelectedQuestionIds()
                && Objects.equals(selectedQuestionIds(), other.selectedQuestionIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SelectedPillar").add("PillarId", pillarId())
                .add("SelectedQuestionIds", hasSelectedQuestionIds() ? selectedQuestionIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PillarId":
            return Optional.ofNullable(clazz.cast(pillarId()));
        case "SelectedQuestionIds":
            return Optional.ofNullable(clazz.cast(selectedQuestionIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PillarId", PILLAR_ID_FIELD);
        map.put("SelectedQuestionIds", SELECTED_QUESTION_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SelectedPillar, T> g) {
        return obj -> g.apply((SelectedPillar) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SelectedPillar> {
        /**
         * Sets the value of the PillarId property for this object.
         *
         * @param pillarId
         *        The new value for the PillarId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pillarId(String pillarId);

        /**
         * <p>
         * Selected question IDs in the selected pillar.
         * </p>
         * 
         * @param selectedQuestionIds
         *        Selected question IDs in the selected pillar.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedQuestionIds(Collection<String> selectedQuestionIds);

        /**
         * <p>
         * Selected question IDs in the selected pillar.
         * </p>
         * 
         * @param selectedQuestionIds
         *        Selected question IDs in the selected pillar.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedQuestionIds(String... selectedQuestionIds);
    }

    static final class BuilderImpl implements Builder {
        private String pillarId;

        private List<String> selectedQuestionIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SelectedPillar model) {
            pillarId(model.pillarId);
            selectedQuestionIds(model.selectedQuestionIds);
        }

        public final String getPillarId() {
            return pillarId;
        }

        public final void setPillarId(String pillarId) {
            this.pillarId = pillarId;
        }

        @Override
        public final Builder pillarId(String pillarId) {
            this.pillarId = pillarId;
            return this;
        }

        public final Collection<String> getSelectedQuestionIds() {
            if (selectedQuestionIds instanceof SdkAutoConstructList) {
                return null;
            }
            return selectedQuestionIds;
        }

        public final void setSelectedQuestionIds(Collection<String> selectedQuestionIds) {
            this.selectedQuestionIds = SelectedQuestionIdsCopier.copy(selectedQuestionIds);
        }

        @Override
        public final Builder selectedQuestionIds(Collection<String> selectedQuestionIds) {
            this.selectedQuestionIds = SelectedQuestionIdsCopier.copy(selectedQuestionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedQuestionIds(String... selectedQuestionIds) {
            selectedQuestionIds(Arrays.asList(selectedQuestionIds));
            return this;
        }

        @Override
        public SelectedPillar build() {
            return new SelectedPillar(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
