/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A metric for a particular question in the pillar.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QuestionMetric implements SdkPojo, Serializable, ToCopyableBuilder<QuestionMetric.Builder, QuestionMetric> {
    private static final SdkField<String> QUESTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuestionId").getter(getter(QuestionMetric::questionId)).setter(setter(Builder::questionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionId").build()).build();

    private static final SdkField<String> RISK_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Risk")
            .getter(getter(QuestionMetric::riskAsString)).setter(setter(Builder::risk))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Risk").build()).build();

    private static final SdkField<List<BestPractice>> BEST_PRACTICES_FIELD = SdkField
            .<List<BestPractice>> builder(MarshallingType.LIST)
            .memberName("BestPractices")
            .getter(getter(QuestionMetric::bestPractices))
            .setter(setter(Builder::bestPractices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BestPractices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BestPractice> builder(MarshallingType.SDK_POJO)
                                            .constructor(BestPractice::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUESTION_ID_FIELD, RISK_FIELD,
            BEST_PRACTICES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String questionId;

    private final String risk;

    private final List<BestPractice> bestPractices;

    private QuestionMetric(BuilderImpl builder) {
        this.questionId = builder.questionId;
        this.risk = builder.risk;
        this.bestPractices = builder.bestPractices;
    }

    /**
     * Returns the value of the QuestionId property for this object.
     * 
     * @return The value of the QuestionId property for this object.
     */
    public final String questionId() {
        return questionId;
    }

    /**
     * Returns the value of the Risk property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #risk} will return
     * {@link Risk#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #riskAsString}.
     * </p>
     * 
     * @return The value of the Risk property for this object.
     * @see Risk
     */
    public final Risk risk() {
        return Risk.fromValue(risk);
    }

    /**
     * Returns the value of the Risk property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #risk} will return
     * {@link Risk#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #riskAsString}.
     * </p>
     * 
     * @return The value of the Risk property for this object.
     * @see Risk
     */
    public final String riskAsString() {
        return risk;
    }

    /**
     * For responses, this returns true if the service returned a value for the BestPractices property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBestPractices() {
        return bestPractices != null && !(bestPractices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The best practices, or choices, that have been identified as contributing to risk in a question.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBestPractices} method.
     * </p>
     * 
     * @return The best practices, or choices, that have been identified as contributing to risk in a question.
     */
    public final List<BestPractice> bestPractices() {
        return bestPractices;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(questionId());
        hashCode = 31 * hashCode + Objects.hashCode(riskAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasBestPractices() ? bestPractices() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuestionMetric)) {
            return false;
        }
        QuestionMetric other = (QuestionMetric) obj;
        return Objects.equals(questionId(), other.questionId()) && Objects.equals(riskAsString(), other.riskAsString())
                && hasBestPractices() == other.hasBestPractices() && Objects.equals(bestPractices(), other.bestPractices());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QuestionMetric").add("QuestionId", questionId()).add("Risk", riskAsString())
                .add("BestPractices", hasBestPractices() ? bestPractices() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QuestionId":
            return Optional.ofNullable(clazz.cast(questionId()));
        case "Risk":
            return Optional.ofNullable(clazz.cast(riskAsString()));
        case "BestPractices":
            return Optional.ofNullable(clazz.cast(bestPractices()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("QuestionId", QUESTION_ID_FIELD);
        map.put("Risk", RISK_FIELD);
        map.put("BestPractices", BEST_PRACTICES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QuestionMetric, T> g) {
        return obj -> g.apply((QuestionMetric) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QuestionMetric> {
        /**
         * Sets the value of the QuestionId property for this object.
         *
         * @param questionId
         *        The new value for the QuestionId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder questionId(String questionId);

        /**
         * Sets the value of the Risk property for this object.
         *
         * @param risk
         *        The new value for the Risk property for this object.
         * @see Risk
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Risk
         */
        Builder risk(String risk);

        /**
         * Sets the value of the Risk property for this object.
         *
         * @param risk
         *        The new value for the Risk property for this object.
         * @see Risk
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Risk
         */
        Builder risk(Risk risk);

        /**
         * <p>
         * The best practices, or choices, that have been identified as contributing to risk in a question.
         * </p>
         * 
         * @param bestPractices
         *        The best practices, or choices, that have been identified as contributing to risk in a question.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bestPractices(Collection<BestPractice> bestPractices);

        /**
         * <p>
         * The best practices, or choices, that have been identified as contributing to risk in a question.
         * </p>
         * 
         * @param bestPractices
         *        The best practices, or choices, that have been identified as contributing to risk in a question.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bestPractices(BestPractice... bestPractices);

        /**
         * <p>
         * The best practices, or choices, that have been identified as contributing to risk in a question.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wellarchitected.model.BestPractice.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.wellarchitected.model.BestPractice#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wellarchitected.model.BestPractice.Builder#build()} is called
         * immediately and its result is passed to {@link #bestPractices(List<BestPractice>)}.
         * 
         * @param bestPractices
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wellarchitected.model.BestPractice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bestPractices(java.util.Collection<BestPractice>)
         */
        Builder bestPractices(Consumer<BestPractice.Builder>... bestPractices);
    }

    static final class BuilderImpl implements Builder {
        private String questionId;

        private String risk;

        private List<BestPractice> bestPractices = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(QuestionMetric model) {
            questionId(model.questionId);
            risk(model.risk);
            bestPractices(model.bestPractices);
        }

        public final String getQuestionId() {
            return questionId;
        }

        public final void setQuestionId(String questionId) {
            this.questionId = questionId;
        }

        @Override
        public final Builder questionId(String questionId) {
            this.questionId = questionId;
            return this;
        }

        public final String getRisk() {
            return risk;
        }

        public final void setRisk(String risk) {
            this.risk = risk;
        }

        @Override
        public final Builder risk(String risk) {
            this.risk = risk;
            return this;
        }

        @Override
        public final Builder risk(Risk risk) {
            this.risk(risk == null ? null : risk.toString());
            return this;
        }

        public final List<BestPractice.Builder> getBestPractices() {
            List<BestPractice.Builder> result = BestPracticesCopier.copyToBuilder(this.bestPractices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBestPractices(Collection<BestPractice.BuilderImpl> bestPractices) {
            this.bestPractices = BestPracticesCopier.copyFromBuilder(bestPractices);
        }

        @Override
        public final Builder bestPractices(Collection<BestPractice> bestPractices) {
            this.bestPractices = BestPracticesCopier.copy(bestPractices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bestPractices(BestPractice... bestPractices) {
            bestPractices(Arrays.asList(bestPractices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bestPractices(Consumer<BestPractice.Builder>... bestPractices) {
            bestPractices(Stream.of(bestPractices).map(c -> BestPractice.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public QuestionMetric build() {
            return new QuestionMetric(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
