/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A profile template choice.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProfileTemplateChoice implements SdkPojo, Serializable,
        ToCopyableBuilder<ProfileTemplateChoice.Builder, ProfileTemplateChoice> {
    private static final SdkField<String> CHOICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChoiceId").getter(getter(ProfileTemplateChoice::choiceId)).setter(setter(Builder::choiceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChoiceId").build()).build();

    private static final SdkField<String> CHOICE_TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChoiceTitle").getter(getter(ProfileTemplateChoice::choiceTitle)).setter(setter(Builder::choiceTitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChoiceTitle").build()).build();

    private static final SdkField<String> CHOICE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChoiceDescription").getter(getter(ProfileTemplateChoice::choiceDescription))
            .setter(setter(Builder::choiceDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChoiceDescription").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHOICE_ID_FIELD,
            CHOICE_TITLE_FIELD, CHOICE_DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String choiceId;

    private final String choiceTitle;

    private final String choiceDescription;

    private ProfileTemplateChoice(BuilderImpl builder) {
        this.choiceId = builder.choiceId;
        this.choiceTitle = builder.choiceTitle;
        this.choiceDescription = builder.choiceDescription;
    }

    /**
     * Returns the value of the ChoiceId property for this object.
     * 
     * @return The value of the ChoiceId property for this object.
     */
    public final String choiceId() {
        return choiceId;
    }

    /**
     * Returns the value of the ChoiceTitle property for this object.
     * 
     * @return The value of the ChoiceTitle property for this object.
     */
    public final String choiceTitle() {
        return choiceTitle;
    }

    /**
     * Returns the value of the ChoiceDescription property for this object.
     * 
     * @return The value of the ChoiceDescription property for this object.
     */
    public final String choiceDescription() {
        return choiceDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(choiceId());
        hashCode = 31 * hashCode + Objects.hashCode(choiceTitle());
        hashCode = 31 * hashCode + Objects.hashCode(choiceDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProfileTemplateChoice)) {
            return false;
        }
        ProfileTemplateChoice other = (ProfileTemplateChoice) obj;
        return Objects.equals(choiceId(), other.choiceId()) && Objects.equals(choiceTitle(), other.choiceTitle())
                && Objects.equals(choiceDescription(), other.choiceDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProfileTemplateChoice").add("ChoiceId", choiceId()).add("ChoiceTitle", choiceTitle())
                .add("ChoiceDescription", choiceDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChoiceId":
            return Optional.ofNullable(clazz.cast(choiceId()));
        case "ChoiceTitle":
            return Optional.ofNullable(clazz.cast(choiceTitle()));
        case "ChoiceDescription":
            return Optional.ofNullable(clazz.cast(choiceDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ChoiceId", CHOICE_ID_FIELD);
        map.put("ChoiceTitle", CHOICE_TITLE_FIELD);
        map.put("ChoiceDescription", CHOICE_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProfileTemplateChoice, T> g) {
        return obj -> g.apply((ProfileTemplateChoice) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProfileTemplateChoice> {
        /**
         * Sets the value of the ChoiceId property for this object.
         *
         * @param choiceId
         *        The new value for the ChoiceId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder choiceId(String choiceId);

        /**
         * Sets the value of the ChoiceTitle property for this object.
         *
         * @param choiceTitle
         *        The new value for the ChoiceTitle property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder choiceTitle(String choiceTitle);

        /**
         * Sets the value of the ChoiceDescription property for this object.
         *
         * @param choiceDescription
         *        The new value for the ChoiceDescription property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder choiceDescription(String choiceDescription);
    }

    static final class BuilderImpl implements Builder {
        private String choiceId;

        private String choiceTitle;

        private String choiceDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(ProfileTemplateChoice model) {
            choiceId(model.choiceId);
            choiceTitle(model.choiceTitle);
            choiceDescription(model.choiceDescription);
        }

        public final String getChoiceId() {
            return choiceId;
        }

        public final void setChoiceId(String choiceId) {
            this.choiceId = choiceId;
        }

        @Override
        public final Builder choiceId(String choiceId) {
            this.choiceId = choiceId;
            return this;
        }

        public final String getChoiceTitle() {
            return choiceTitle;
        }

        public final void setChoiceTitle(String choiceTitle) {
            this.choiceTitle = choiceTitle;
        }

        @Override
        public final Builder choiceTitle(String choiceTitle) {
            this.choiceTitle = choiceTitle;
            return this;
        }

        public final String getChoiceDescription() {
            return choiceDescription;
        }

        public final void setChoiceDescription(String choiceDescription) {
            this.choiceDescription = choiceDescription;
        }

        @Override
        public final Builder choiceDescription(String choiceDescription) {
            this.choiceDescription = choiceDescription;
            return this;
        }

        @Override
        public ProfileTemplateChoice build() {
            return new ProfileTemplateChoice(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
