/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The profile notification summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProfileNotificationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ProfileNotificationSummary.Builder, ProfileNotificationSummary> {
    private static final SdkField<String> CURRENT_PROFILE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentProfileVersion").getter(getter(ProfileNotificationSummary::currentProfileVersion))
            .setter(setter(Builder::currentProfileVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentProfileVersion").build())
            .build();

    private static final SdkField<String> LATEST_PROFILE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LatestProfileVersion").getter(getter(ProfileNotificationSummary::latestProfileVersion))
            .setter(setter(Builder::latestProfileVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestProfileVersion").build())
            .build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ProfileNotificationSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileArn").getter(getter(ProfileNotificationSummary::profileArn)).setter(setter(Builder::profileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileArn").build()).build();

    private static final SdkField<String> PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileName").getter(getter(ProfileNotificationSummary::profileName))
            .setter(setter(Builder::profileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileName").build()).build();

    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkloadId").getter(getter(ProfileNotificationSummary::workloadId)).setter(setter(Builder::workloadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadId").build()).build();

    private static final SdkField<String> WORKLOAD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkloadName").getter(getter(ProfileNotificationSummary::workloadName))
            .setter(setter(Builder::workloadName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENT_PROFILE_VERSION_FIELD,
            LATEST_PROFILE_VERSION_FIELD, TYPE_FIELD, PROFILE_ARN_FIELD, PROFILE_NAME_FIELD, WORKLOAD_ID_FIELD,
            WORKLOAD_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String currentProfileVersion;

    private final String latestProfileVersion;

    private final String type;

    private final String profileArn;

    private final String profileName;

    private final String workloadId;

    private final String workloadName;

    private ProfileNotificationSummary(BuilderImpl builder) {
        this.currentProfileVersion = builder.currentProfileVersion;
        this.latestProfileVersion = builder.latestProfileVersion;
        this.type = builder.type;
        this.profileArn = builder.profileArn;
        this.profileName = builder.profileName;
        this.workloadId = builder.workloadId;
        this.workloadName = builder.workloadName;
    }

    /**
     * <p>
     * The current profile version.
     * </p>
     * 
     * @return The current profile version.
     */
    public final String currentProfileVersion() {
        return currentProfileVersion;
    }

    /**
     * <p>
     * The latest profile version.
     * </p>
     * 
     * @return The latest profile version.
     */
    public final String latestProfileVersion() {
        return latestProfileVersion;
    }

    /**
     * <p>
     * Type of notification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ProfileNotificationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Type of notification.
     * @see ProfileNotificationType
     */
    public final ProfileNotificationType type() {
        return ProfileNotificationType.fromValue(type);
    }

    /**
     * <p>
     * Type of notification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ProfileNotificationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Type of notification.
     * @see ProfileNotificationType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The profile ARN.
     * </p>
     * 
     * @return The profile ARN.
     */
    public final String profileArn() {
        return profileArn;
    }

    /**
     * <p>
     * The profile name.
     * </p>
     * 
     * @return The profile name.
     */
    public final String profileName() {
        return profileName;
    }

    /**
     * Returns the value of the WorkloadId property for this object.
     * 
     * @return The value of the WorkloadId property for this object.
     */
    public final String workloadId() {
        return workloadId;
    }

    /**
     * Returns the value of the WorkloadName property for this object.
     * 
     * @return The value of the WorkloadName property for this object.
     */
    public final String workloadName() {
        return workloadName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(currentProfileVersion());
        hashCode = 31 * hashCode + Objects.hashCode(latestProfileVersion());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(profileArn());
        hashCode = 31 * hashCode + Objects.hashCode(profileName());
        hashCode = 31 * hashCode + Objects.hashCode(workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(workloadName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProfileNotificationSummary)) {
            return false;
        }
        ProfileNotificationSummary other = (ProfileNotificationSummary) obj;
        return Objects.equals(currentProfileVersion(), other.currentProfileVersion())
                && Objects.equals(latestProfileVersion(), other.latestProfileVersion())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(profileArn(), other.profileArn())
                && Objects.equals(profileName(), other.profileName()) && Objects.equals(workloadId(), other.workloadId())
                && Objects.equals(workloadName(), other.workloadName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProfileNotificationSummary").add("CurrentProfileVersion", currentProfileVersion())
                .add("LatestProfileVersion", latestProfileVersion()).add("Type", typeAsString()).add("ProfileArn", profileArn())
                .add("ProfileName", profileName()).add("WorkloadId", workloadId()).add("WorkloadName", workloadName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CurrentProfileVersion":
            return Optional.ofNullable(clazz.cast(currentProfileVersion()));
        case "LatestProfileVersion":
            return Optional.ofNullable(clazz.cast(latestProfileVersion()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "ProfileArn":
            return Optional.ofNullable(clazz.cast(profileArn()));
        case "ProfileName":
            return Optional.ofNullable(clazz.cast(profileName()));
        case "WorkloadId":
            return Optional.ofNullable(clazz.cast(workloadId()));
        case "WorkloadName":
            return Optional.ofNullable(clazz.cast(workloadName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CurrentProfileVersion", CURRENT_PROFILE_VERSION_FIELD);
        map.put("LatestProfileVersion", LATEST_PROFILE_VERSION_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("ProfileArn", PROFILE_ARN_FIELD);
        map.put("ProfileName", PROFILE_NAME_FIELD);
        map.put("WorkloadId", WORKLOAD_ID_FIELD);
        map.put("WorkloadName", WORKLOAD_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProfileNotificationSummary, T> g) {
        return obj -> g.apply((ProfileNotificationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProfileNotificationSummary> {
        /**
         * <p>
         * The current profile version.
         * </p>
         * 
         * @param currentProfileVersion
         *        The current profile version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentProfileVersion(String currentProfileVersion);

        /**
         * <p>
         * The latest profile version.
         * </p>
         * 
         * @param latestProfileVersion
         *        The latest profile version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestProfileVersion(String latestProfileVersion);

        /**
         * <p>
         * Type of notification.
         * </p>
         * 
         * @param type
         *        Type of notification.
         * @see ProfileNotificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProfileNotificationType
         */
        Builder type(String type);

        /**
         * <p>
         * Type of notification.
         * </p>
         * 
         * @param type
         *        Type of notification.
         * @see ProfileNotificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProfileNotificationType
         */
        Builder type(ProfileNotificationType type);

        /**
         * <p>
         * The profile ARN.
         * </p>
         * 
         * @param profileArn
         *        The profile ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileArn(String profileArn);

        /**
         * <p>
         * The profile name.
         * </p>
         * 
         * @param profileName
         *        The profile name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileName(String profileName);

        /**
         * Sets the value of the WorkloadId property for this object.
         *
         * @param workloadId
         *        The new value for the WorkloadId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadId(String workloadId);

        /**
         * Sets the value of the WorkloadName property for this object.
         *
         * @param workloadName
         *        The new value for the WorkloadName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadName(String workloadName);
    }

    static final class BuilderImpl implements Builder {
        private String currentProfileVersion;

        private String latestProfileVersion;

        private String type;

        private String profileArn;

        private String profileName;

        private String workloadId;

        private String workloadName;

        private BuilderImpl() {
        }

        private BuilderImpl(ProfileNotificationSummary model) {
            currentProfileVersion(model.currentProfileVersion);
            latestProfileVersion(model.latestProfileVersion);
            type(model.type);
            profileArn(model.profileArn);
            profileName(model.profileName);
            workloadId(model.workloadId);
            workloadName(model.workloadName);
        }

        public final String getCurrentProfileVersion() {
            return currentProfileVersion;
        }

        public final void setCurrentProfileVersion(String currentProfileVersion) {
            this.currentProfileVersion = currentProfileVersion;
        }

        @Override
        public final Builder currentProfileVersion(String currentProfileVersion) {
            this.currentProfileVersion = currentProfileVersion;
            return this;
        }

        public final String getLatestProfileVersion() {
            return latestProfileVersion;
        }

        public final void setLatestProfileVersion(String latestProfileVersion) {
            this.latestProfileVersion = latestProfileVersion;
        }

        @Override
        public final Builder latestProfileVersion(String latestProfileVersion) {
            this.latestProfileVersion = latestProfileVersion;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ProfileNotificationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getProfileArn() {
            return profileArn;
        }

        public final void setProfileArn(String profileArn) {
            this.profileArn = profileArn;
        }

        @Override
        public final Builder profileArn(String profileArn) {
            this.profileArn = profileArn;
            return this;
        }

        public final String getProfileName() {
            return profileName;
        }

        public final void setProfileName(String profileName) {
            this.profileName = profileName;
        }

        @Override
        public final Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public final String getWorkloadId() {
            return workloadId;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final String getWorkloadName() {
            return workloadName;
        }

        public final void setWorkloadName(String workloadName) {
            this.workloadName = workloadName;
        }

        @Override
        public final Builder workloadName(String workloadName) {
            this.workloadName = workloadName;
            return this;
        }

        @Override
        public ProfileNotificationSummary build() {
            return new ProfileNotificationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
