/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Profile implements SdkPojo, Serializable, ToCopyableBuilder<Profile.Builder, Profile> {
    private static final SdkField<String> PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileArn").getter(getter(Profile::profileArn)).setter(setter(Builder::profileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileArn").build()).build();

    private static final SdkField<String> PROFILE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileVersion").getter(getter(Profile::profileVersion)).setter(setter(Builder::profileVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileVersion").build()).build();

    private static final SdkField<String> PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileName").getter(getter(Profile::profileName)).setter(setter(Builder::profileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileName").build()).build();

    private static final SdkField<String> PROFILE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileDescription").getter(getter(Profile::profileDescription))
            .setter(setter(Builder::profileDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileDescription").build())
            .build();

    private static final SdkField<List<ProfileQuestion>> PROFILE_QUESTIONS_FIELD = SdkField
            .<List<ProfileQuestion>> builder(MarshallingType.LIST)
            .memberName("ProfileQuestions")
            .getter(getter(Profile::profileQuestions))
            .setter(setter(Builder::profileQuestions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileQuestions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProfileQuestion> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProfileQuestion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Owner")
            .getter(getter(Profile::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(Profile::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(Profile::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final SdkField<String> SHARE_INVITATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShareInvitationId").getter(getter(Profile::shareInvitationId))
            .setter(setter(Builder::shareInvitationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareInvitationId").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(Profile::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_ARN_FIELD,
            PROFILE_VERSION_FIELD, PROFILE_NAME_FIELD, PROFILE_DESCRIPTION_FIELD, PROFILE_QUESTIONS_FIELD, OWNER_FIELD,
            CREATED_AT_FIELD, UPDATED_AT_FIELD, SHARE_INVITATION_ID_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String profileArn;

    private final String profileVersion;

    private final String profileName;

    private final String profileDescription;

    private final List<ProfileQuestion> profileQuestions;

    private final String owner;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String shareInvitationId;

    private final Map<String, String> tags;

    private Profile(BuilderImpl builder) {
        this.profileArn = builder.profileArn;
        this.profileVersion = builder.profileVersion;
        this.profileName = builder.profileName;
        this.profileDescription = builder.profileDescription;
        this.profileQuestions = builder.profileQuestions;
        this.owner = builder.owner;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.shareInvitationId = builder.shareInvitationId;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The profile ARN.
     * </p>
     * 
     * @return The profile ARN.
     */
    public final String profileArn() {
        return profileArn;
    }

    /**
     * <p>
     * The profile version.
     * </p>
     * 
     * @return The profile version.
     */
    public final String profileVersion() {
        return profileVersion;
    }

    /**
     * <p>
     * The profile name.
     * </p>
     * 
     * @return The profile name.
     */
    public final String profileName() {
        return profileName;
    }

    /**
     * <p>
     * The profile description.
     * </p>
     * 
     * @return The profile description.
     */
    public final String profileDescription() {
        return profileDescription;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProfileQuestions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProfileQuestions() {
        return profileQuestions != null && !(profileQuestions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Profile questions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProfileQuestions} method.
     * </p>
     * 
     * @return Profile questions.
     */
    public final List<ProfileQuestion> profileQuestions() {
        return profileQuestions;
    }

    /**
     * Returns the value of the Owner property for this object.
     * 
     * @return The value of the Owner property for this object.
     */
    public final String owner() {
        return owner;
    }

    /**
     * Returns the value of the CreatedAt property for this object.
     * 
     * @return The value of the CreatedAt property for this object.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * Returns the value of the UpdatedAt property for this object.
     * 
     * @return The value of the UpdatedAt property for this object.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The ID assigned to the share invitation.
     * </p>
     * 
     * @return The ID assigned to the share invitation.
     */
    public final String shareInvitationId() {
        return shareInvitationId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags assigned to the profile.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags assigned to the profile.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(profileArn());
        hashCode = 31 * hashCode + Objects.hashCode(profileVersion());
        hashCode = 31 * hashCode + Objects.hashCode(profileName());
        hashCode = 31 * hashCode + Objects.hashCode(profileDescription());
        hashCode = 31 * hashCode + Objects.hashCode(hasProfileQuestions() ? profileQuestions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(shareInvitationId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Profile)) {
            return false;
        }
        Profile other = (Profile) obj;
        return Objects.equals(profileArn(), other.profileArn()) && Objects.equals(profileVersion(), other.profileVersion())
                && Objects.equals(profileName(), other.profileName())
                && Objects.equals(profileDescription(), other.profileDescription())
                && hasProfileQuestions() == other.hasProfileQuestions()
                && Objects.equals(profileQuestions(), other.profileQuestions()) && Objects.equals(owner(), other.owner())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(shareInvitationId(), other.shareInvitationId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Profile").add("ProfileArn", profileArn()).add("ProfileVersion", profileVersion())
                .add("ProfileName", profileName()).add("ProfileDescription", profileDescription())
                .add("ProfileQuestions", hasProfileQuestions() ? profileQuestions() : null).add("Owner", owner())
                .add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).add("ShareInvitationId", shareInvitationId())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProfileArn":
            return Optional.ofNullable(clazz.cast(profileArn()));
        case "ProfileVersion":
            return Optional.ofNullable(clazz.cast(profileVersion()));
        case "ProfileName":
            return Optional.ofNullable(clazz.cast(profileName()));
        case "ProfileDescription":
            return Optional.ofNullable(clazz.cast(profileDescription()));
        case "ProfileQuestions":
            return Optional.ofNullable(clazz.cast(profileQuestions()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "ShareInvitationId":
            return Optional.ofNullable(clazz.cast(shareInvitationId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProfileArn", PROFILE_ARN_FIELD);
        map.put("ProfileVersion", PROFILE_VERSION_FIELD);
        map.put("ProfileName", PROFILE_NAME_FIELD);
        map.put("ProfileDescription", PROFILE_DESCRIPTION_FIELD);
        map.put("ProfileQuestions", PROFILE_QUESTIONS_FIELD);
        map.put("Owner", OWNER_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        map.put("ShareInvitationId", SHARE_INVITATION_ID_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Profile, T> g) {
        return obj -> g.apply((Profile) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Profile> {
        /**
         * <p>
         * The profile ARN.
         * </p>
         * 
         * @param profileArn
         *        The profile ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileArn(String profileArn);

        /**
         * <p>
         * The profile version.
         * </p>
         * 
         * @param profileVersion
         *        The profile version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileVersion(String profileVersion);

        /**
         * <p>
         * The profile name.
         * </p>
         * 
         * @param profileName
         *        The profile name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileName(String profileName);

        /**
         * <p>
         * The profile description.
         * </p>
         * 
         * @param profileDescription
         *        The profile description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileDescription(String profileDescription);

        /**
         * <p>
         * Profile questions.
         * </p>
         * 
         * @param profileQuestions
         *        Profile questions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileQuestions(Collection<ProfileQuestion> profileQuestions);

        /**
         * <p>
         * Profile questions.
         * </p>
         * 
         * @param profileQuestions
         *        Profile questions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileQuestions(ProfileQuestion... profileQuestions);

        /**
         * <p>
         * Profile questions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wellarchitected.model.ProfileQuestion.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.wellarchitected.model.ProfileQuestion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wellarchitected.model.ProfileQuestion.Builder#build()} is called
         * immediately and its result is passed to {@link #profileQuestions(List<ProfileQuestion>)}.
         * 
         * @param profileQuestions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wellarchitected.model.ProfileQuestion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #profileQuestions(java.util.Collection<ProfileQuestion>)
         */
        Builder profileQuestions(Consumer<ProfileQuestion.Builder>... profileQuestions);

        /**
         * Sets the value of the Owner property for this object.
         *
         * @param owner
         *        The new value for the Owner property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * Sets the value of the CreatedAt property for this object.
         *
         * @param createdAt
         *        The new value for the CreatedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * Sets the value of the UpdatedAt property for this object.
         *
         * @param updatedAt
         *        The new value for the UpdatedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The ID assigned to the share invitation.
         * </p>
         * 
         * @param shareInvitationId
         *        The ID assigned to the share invitation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareInvitationId(String shareInvitationId);

        /**
         * <p>
         * The tags assigned to the profile.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String profileArn;

        private String profileVersion;

        private String profileName;

        private String profileDescription;

        private List<ProfileQuestion> profileQuestions = DefaultSdkAutoConstructList.getInstance();

        private String owner;

        private Instant createdAt;

        private Instant updatedAt;

        private String shareInvitationId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Profile model) {
            profileArn(model.profileArn);
            profileVersion(model.profileVersion);
            profileName(model.profileName);
            profileDescription(model.profileDescription);
            profileQuestions(model.profileQuestions);
            owner(model.owner);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            shareInvitationId(model.shareInvitationId);
            tags(model.tags);
        }

        public final String getProfileArn() {
            return profileArn;
        }

        public final void setProfileArn(String profileArn) {
            this.profileArn = profileArn;
        }

        @Override
        public final Builder profileArn(String profileArn) {
            this.profileArn = profileArn;
            return this;
        }

        public final String getProfileVersion() {
            return profileVersion;
        }

        public final void setProfileVersion(String profileVersion) {
            this.profileVersion = profileVersion;
        }

        @Override
        public final Builder profileVersion(String profileVersion) {
            this.profileVersion = profileVersion;
            return this;
        }

        public final String getProfileName() {
            return profileName;
        }

        public final void setProfileName(String profileName) {
            this.profileName = profileName;
        }

        @Override
        public final Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public final String getProfileDescription() {
            return profileDescription;
        }

        public final void setProfileDescription(String profileDescription) {
            this.profileDescription = profileDescription;
        }

        @Override
        public final Builder profileDescription(String profileDescription) {
            this.profileDescription = profileDescription;
            return this;
        }

        public final List<ProfileQuestion.Builder> getProfileQuestions() {
            List<ProfileQuestion.Builder> result = ProfileQuestionsCopier.copyToBuilder(this.profileQuestions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProfileQuestions(Collection<ProfileQuestion.BuilderImpl> profileQuestions) {
            this.profileQuestions = ProfileQuestionsCopier.copyFromBuilder(profileQuestions);
        }

        @Override
        public final Builder profileQuestions(Collection<ProfileQuestion> profileQuestions) {
            this.profileQuestions = ProfileQuestionsCopier.copy(profileQuestions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profileQuestions(ProfileQuestion... profileQuestions) {
            profileQuestions(Arrays.asList(profileQuestions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profileQuestions(Consumer<ProfileQuestion.Builder>... profileQuestions) {
            profileQuestions(Stream.of(profileQuestions).map(c -> ProfileQuestion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getShareInvitationId() {
            return shareInvitationId;
        }

        public final void setShareInvitationId(String shareInvitationId) {
            this.shareInvitationId = shareInvitationId;
        }

        @Override
        public final Builder shareInvitationId(String shareInvitationId) {
            this.shareInvitationId = shareInvitationId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Profile build() {
            return new Profile(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
