/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCheckDetailsResponse extends WellArchitectedResponse implements
        ToCopyableBuilder<ListCheckDetailsResponse.Builder, ListCheckDetailsResponse> {
    private static final SdkField<List<CheckDetail>> CHECK_DETAILS_FIELD = SdkField
            .<List<CheckDetail>> builder(MarshallingType.LIST)
            .memberName("CheckDetails")
            .getter(getter(ListCheckDetailsResponse::checkDetails))
            .setter(setter(Builder::checkDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CheckDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(CheckDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCheckDetailsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHECK_DETAILS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<CheckDetail> checkDetails;

    private final String nextToken;

    private ListCheckDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.checkDetails = builder.checkDetails;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CheckDetails property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCheckDetails() {
        return checkDetails != null && !(checkDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The details about the Trusted Advisor checks related to the Well-Architected best practice.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCheckDetails} method.
     * </p>
     * 
     * @return The details about the Trusted Advisor checks related to the Well-Architected best practice.
     */
    public final List<CheckDetail> checkDetails() {
        return checkDetails;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCheckDetails() ? checkDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCheckDetailsResponse)) {
            return false;
        }
        ListCheckDetailsResponse other = (ListCheckDetailsResponse) obj;
        return hasCheckDetails() == other.hasCheckDetails() && Objects.equals(checkDetails(), other.checkDetails())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCheckDetailsResponse").add("CheckDetails", hasCheckDetails() ? checkDetails() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CheckDetails":
            return Optional.ofNullable(clazz.cast(checkDetails()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CheckDetails", CHECK_DETAILS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCheckDetailsResponse, T> g) {
        return obj -> g.apply((ListCheckDetailsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WellArchitectedResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListCheckDetailsResponse> {
        /**
         * <p>
         * The details about the Trusted Advisor checks related to the Well-Architected best practice.
         * </p>
         * 
         * @param checkDetails
         *        The details about the Trusted Advisor checks related to the Well-Architected best practice.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkDetails(Collection<CheckDetail> checkDetails);

        /**
         * <p>
         * The details about the Trusted Advisor checks related to the Well-Architected best practice.
         * </p>
         * 
         * @param checkDetails
         *        The details about the Trusted Advisor checks related to the Well-Architected best practice.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkDetails(CheckDetail... checkDetails);

        /**
         * <p>
         * The details about the Trusted Advisor checks related to the Well-Architected best practice.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wellarchitected.model.CheckDetail.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.wellarchitected.model.CheckDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wellarchitected.model.CheckDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #checkDetails(List<CheckDetail>)}.
         * 
         * @param checkDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wellarchitected.model.CheckDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #checkDetails(java.util.Collection<CheckDetail>)
         */
        Builder checkDetails(Consumer<CheckDetail.Builder>... checkDetails);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends WellArchitectedResponse.BuilderImpl implements Builder {
        private List<CheckDetail> checkDetails = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCheckDetailsResponse model) {
            super(model);
            checkDetails(model.checkDetails);
            nextToken(model.nextToken);
        }

        public final List<CheckDetail.Builder> getCheckDetails() {
            List<CheckDetail.Builder> result = CheckDetailsCopier.copyToBuilder(this.checkDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCheckDetails(Collection<CheckDetail.BuilderImpl> checkDetails) {
            this.checkDetails = CheckDetailsCopier.copyFromBuilder(checkDetails);
        }

        @Override
        public final Builder checkDetails(Collection<CheckDetail> checkDetails) {
            this.checkDetails = CheckDetailsCopier.copy(checkDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder checkDetails(CheckDetail... checkDetails) {
            checkDetails(Arrays.asList(checkDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder checkDetails(Consumer<CheckDetail.Builder>... checkDetails) {
            checkDetails(Stream.of(checkDetails).map(c -> CheckDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCheckDetailsResponse build() {
            return new ListCheckDetailsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
