/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Lens upgrade summary return object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LensUpgradeSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<LensUpgradeSummary.Builder, LensUpgradeSummary> {
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkloadId").getter(getter(LensUpgradeSummary::workloadId)).setter(setter(Builder::workloadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadId").build()).build();

    private static final SdkField<String> WORKLOAD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkloadName").getter(getter(LensUpgradeSummary::workloadName)).setter(setter(Builder::workloadName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadName").build()).build();

    private static final SdkField<String> LENS_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensAlias").getter(getter(LensUpgradeSummary::lensAlias)).setter(setter(Builder::lensAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensAlias").build()).build();

    private static final SdkField<String> LENS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensArn").getter(getter(LensUpgradeSummary::lensArn)).setter(setter(Builder::lensArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensArn").build()).build();

    private static final SdkField<String> CURRENT_LENS_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentLensVersion").getter(getter(LensUpgradeSummary::currentLensVersion))
            .setter(setter(Builder::currentLensVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentLensVersion").build())
            .build();

    private static final SdkField<String> LATEST_LENS_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LatestLensVersion").getter(getter(LensUpgradeSummary::latestLensVersion))
            .setter(setter(Builder::latestLensVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestLensVersion").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(LensUpgradeSummary::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceName").getter(getter(LensUpgradeSummary::resourceName)).setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ID_FIELD,
            WORKLOAD_NAME_FIELD, LENS_ALIAS_FIELD, LENS_ARN_FIELD, CURRENT_LENS_VERSION_FIELD, LATEST_LENS_VERSION_FIELD,
            RESOURCE_ARN_FIELD, RESOURCE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String workloadId;

    private final String workloadName;

    private final String lensAlias;

    private final String lensArn;

    private final String currentLensVersion;

    private final String latestLensVersion;

    private final String resourceArn;

    private final String resourceName;

    private LensUpgradeSummary(BuilderImpl builder) {
        this.workloadId = builder.workloadId;
        this.workloadName = builder.workloadName;
        this.lensAlias = builder.lensAlias;
        this.lensArn = builder.lensArn;
        this.currentLensVersion = builder.currentLensVersion;
        this.latestLensVersion = builder.latestLensVersion;
        this.resourceArn = builder.resourceArn;
        this.resourceName = builder.resourceName;
    }

    /**
     * Returns the value of the WorkloadId property for this object.
     * 
     * @return The value of the WorkloadId property for this object.
     */
    public final String workloadId() {
        return workloadId;
    }

    /**
     * Returns the value of the WorkloadName property for this object.
     * 
     * @return The value of the WorkloadName property for this object.
     */
    public final String workloadName() {
        return workloadName;
    }

    /**
     * Returns the value of the LensAlias property for this object.
     * 
     * @return The value of the LensAlias property for this object.
     */
    public final String lensAlias() {
        return lensAlias;
    }

    /**
     * <p>
     * The ARN for the lens.
     * </p>
     * 
     * @return The ARN for the lens.
     */
    public final String lensArn() {
        return lensArn;
    }

    /**
     * <p>
     * The current version of the lens.
     * </p>
     * 
     * @return The current version of the lens.
     */
    public final String currentLensVersion() {
        return currentLensVersion;
    }

    /**
     * <p>
     * The latest version of the lens.
     * </p>
     * 
     * @return The latest version of the lens.
     */
    public final String latestLensVersion() {
        return latestLensVersion;
    }

    /**
     * <p>
     * <code>ResourceArn</code> of the lens being upgraded
     * </p>
     * 
     * @return <code>ResourceArn</code> of the lens being upgraded
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * Returns the value of the ResourceName property for this object.
     * 
     * @return The value of the ResourceName property for this object.
     */
    public final String resourceName() {
        return resourceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(workloadName());
        hashCode = 31 * hashCode + Objects.hashCode(lensAlias());
        hashCode = 31 * hashCode + Objects.hashCode(lensArn());
        hashCode = 31 * hashCode + Objects.hashCode(currentLensVersion());
        hashCode = 31 * hashCode + Objects.hashCode(latestLensVersion());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LensUpgradeSummary)) {
            return false;
        }
        LensUpgradeSummary other = (LensUpgradeSummary) obj;
        return Objects.equals(workloadId(), other.workloadId()) && Objects.equals(workloadName(), other.workloadName())
                && Objects.equals(lensAlias(), other.lensAlias()) && Objects.equals(lensArn(), other.lensArn())
                && Objects.equals(currentLensVersion(), other.currentLensVersion())
                && Objects.equals(latestLensVersion(), other.latestLensVersion())
                && Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(resourceName(), other.resourceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LensUpgradeSummary").add("WorkloadId", workloadId()).add("WorkloadName", workloadName())
                .add("LensAlias", lensAlias()).add("LensArn", lensArn()).add("CurrentLensVersion", currentLensVersion())
                .add("LatestLensVersion", latestLensVersion()).add("ResourceArn", resourceArn())
                .add("ResourceName", resourceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkloadId":
            return Optional.ofNullable(clazz.cast(workloadId()));
        case "WorkloadName":
            return Optional.ofNullable(clazz.cast(workloadName()));
        case "LensAlias":
            return Optional.ofNullable(clazz.cast(lensAlias()));
        case "LensArn":
            return Optional.ofNullable(clazz.cast(lensArn()));
        case "CurrentLensVersion":
            return Optional.ofNullable(clazz.cast(currentLensVersion()));
        case "LatestLensVersion":
            return Optional.ofNullable(clazz.cast(latestLensVersion()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "ResourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WorkloadId", WORKLOAD_ID_FIELD);
        map.put("WorkloadName", WORKLOAD_NAME_FIELD);
        map.put("LensAlias", LENS_ALIAS_FIELD);
        map.put("LensArn", LENS_ARN_FIELD);
        map.put("CurrentLensVersion", CURRENT_LENS_VERSION_FIELD);
        map.put("LatestLensVersion", LATEST_LENS_VERSION_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("ResourceName", RESOURCE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LensUpgradeSummary, T> g) {
        return obj -> g.apply((LensUpgradeSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LensUpgradeSummary> {
        /**
         * Sets the value of the WorkloadId property for this object.
         *
         * @param workloadId
         *        The new value for the WorkloadId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadId(String workloadId);

        /**
         * Sets the value of the WorkloadName property for this object.
         *
         * @param workloadName
         *        The new value for the WorkloadName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadName(String workloadName);

        /**
         * Sets the value of the LensAlias property for this object.
         *
         * @param lensAlias
         *        The new value for the LensAlias property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensAlias(String lensAlias);

        /**
         * <p>
         * The ARN for the lens.
         * </p>
         * 
         * @param lensArn
         *        The ARN for the lens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensArn(String lensArn);

        /**
         * <p>
         * The current version of the lens.
         * </p>
         * 
         * @param currentLensVersion
         *        The current version of the lens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentLensVersion(String currentLensVersion);

        /**
         * <p>
         * The latest version of the lens.
         * </p>
         * 
         * @param latestLensVersion
         *        The latest version of the lens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestLensVersion(String latestLensVersion);

        /**
         * <p>
         * <code>ResourceArn</code> of the lens being upgraded
         * </p>
         * 
         * @param resourceArn
         *        <code>ResourceArn</code> of the lens being upgraded
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * Sets the value of the ResourceName property for this object.
         *
         * @param resourceName
         *        The new value for the ResourceName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);
    }

    static final class BuilderImpl implements Builder {
        private String workloadId;

        private String workloadName;

        private String lensAlias;

        private String lensArn;

        private String currentLensVersion;

        private String latestLensVersion;

        private String resourceArn;

        private String resourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(LensUpgradeSummary model) {
            workloadId(model.workloadId);
            workloadName(model.workloadName);
            lensAlias(model.lensAlias);
            lensArn(model.lensArn);
            currentLensVersion(model.currentLensVersion);
            latestLensVersion(model.latestLensVersion);
            resourceArn(model.resourceArn);
            resourceName(model.resourceName);
        }

        public final String getWorkloadId() {
            return workloadId;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final String getWorkloadName() {
            return workloadName;
        }

        public final void setWorkloadName(String workloadName) {
            this.workloadName = workloadName;
        }

        @Override
        public final Builder workloadName(String workloadName) {
            this.workloadName = workloadName;
            return this;
        }

        public final String getLensAlias() {
            return lensAlias;
        }

        public final void setLensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
        }

        @Override
        public final Builder lensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
            return this;
        }

        public final String getLensArn() {
            return lensArn;
        }

        public final void setLensArn(String lensArn) {
            this.lensArn = lensArn;
        }

        @Override
        public final Builder lensArn(String lensArn) {
            this.lensArn = lensArn;
            return this;
        }

        public final String getCurrentLensVersion() {
            return currentLensVersion;
        }

        public final void setCurrentLensVersion(String currentLensVersion) {
            this.currentLensVersion = currentLensVersion;
        }

        @Override
        public final Builder currentLensVersion(String currentLensVersion) {
            this.currentLensVersion = currentLensVersion;
            return this;
        }

        public final String getLatestLensVersion() {
            return latestLensVersion;
        }

        public final void setLatestLensVersion(String latestLensVersion) {
            this.latestLensVersion = latestLensVersion;
        }

        @Override
        public final Builder latestLensVersion(String latestLensVersion) {
            this.latestLensVersion = latestLensVersion;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getResourceName() {
            return resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        @Override
        public LensUpgradeSummary build() {
            return new LensUpgradeSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
