/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A report of a lens review.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LensReviewReport implements SdkPojo, Serializable,
        ToCopyableBuilder<LensReviewReport.Builder, LensReviewReport> {
    private static final SdkField<String> LENS_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensAlias").getter(getter(LensReviewReport::lensAlias)).setter(setter(Builder::lensAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensAlias").build()).build();

    private static final SdkField<String> LENS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensArn").getter(getter(LensReviewReport::lensArn)).setter(setter(Builder::lensArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensArn").build()).build();

    private static final SdkField<String> BASE64_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Base64String").getter(getter(LensReviewReport::base64String)).setter(setter(Builder::base64String))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Base64String").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LENS_ALIAS_FIELD,
            LENS_ARN_FIELD, BASE64_STRING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String lensAlias;

    private final String lensArn;

    private final String base64String;

    private LensReviewReport(BuilderImpl builder) {
        this.lensAlias = builder.lensAlias;
        this.lensArn = builder.lensArn;
        this.base64String = builder.base64String;
    }

    /**
     * Returns the value of the LensAlias property for this object.
     * 
     * @return The value of the LensAlias property for this object.
     */
    public final String lensAlias() {
        return lensAlias;
    }

    /**
     * <p>
     * The ARN for the lens.
     * </p>
     * 
     * @return The ARN for the lens.
     */
    public final String lensArn() {
        return lensArn;
    }

    /**
     * Returns the value of the Base64String property for this object.
     * 
     * @return The value of the Base64String property for this object.
     */
    public final String base64String() {
        return base64String;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lensAlias());
        hashCode = 31 * hashCode + Objects.hashCode(lensArn());
        hashCode = 31 * hashCode + Objects.hashCode(base64String());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LensReviewReport)) {
            return false;
        }
        LensReviewReport other = (LensReviewReport) obj;
        return Objects.equals(lensAlias(), other.lensAlias()) && Objects.equals(lensArn(), other.lensArn())
                && Objects.equals(base64String(), other.base64String());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LensReviewReport").add("LensAlias", lensAlias()).add("LensArn", lensArn())
                .add("Base64String", base64String()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LensAlias":
            return Optional.ofNullable(clazz.cast(lensAlias()));
        case "LensArn":
            return Optional.ofNullable(clazz.cast(lensArn()));
        case "Base64String":
            return Optional.ofNullable(clazz.cast(base64String()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LensAlias", LENS_ALIAS_FIELD);
        map.put("LensArn", LENS_ARN_FIELD);
        map.put("Base64String", BASE64_STRING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LensReviewReport, T> g) {
        return obj -> g.apply((LensReviewReport) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LensReviewReport> {
        /**
         * Sets the value of the LensAlias property for this object.
         *
         * @param lensAlias
         *        The new value for the LensAlias property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensAlias(String lensAlias);

        /**
         * <p>
         * The ARN for the lens.
         * </p>
         * 
         * @param lensArn
         *        The ARN for the lens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensArn(String lensArn);

        /**
         * Sets the value of the Base64String property for this object.
         *
         * @param base64String
         *        The new value for the Base64String property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder base64String(String base64String);
    }

    static final class BuilderImpl implements Builder {
        private String lensAlias;

        private String lensArn;

        private String base64String;

        private BuilderImpl() {
        }

        private BuilderImpl(LensReviewReport model) {
            lensAlias(model.lensAlias);
            lensArn(model.lensArn);
            base64String(model.base64String);
        }

        public final String getLensAlias() {
            return lensAlias;
        }

        public final void setLensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
        }

        @Override
        public final Builder lensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
            return this;
        }

        public final String getLensArn() {
            return lensArn;
        }

        public final void setLensArn(String lensArn) {
            this.lensArn = lensArn;
        }

        @Override
        public final Builder lensArn(String lensArn) {
            this.lensArn = lensArn;
            return this;
        }

        public final String getBase64String() {
            return base64String;
        }

        public final void setBase64String(String base64String) {
            this.base64String = base64String;
        }

        @Override
        public final Builder base64String(String base64String) {
            this.base64String = base64String;
            return this;
        }

        @Override
        public LensReviewReport build() {
            return new LensReviewReport(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
