/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetReviewTemplateLensReviewResponse extends WellArchitectedResponse implements
        ToCopyableBuilder<GetReviewTemplateLensReviewResponse.Builder, GetReviewTemplateLensReviewResponse> {
    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateArn").getter(getter(GetReviewTemplateLensReviewResponse::templateArn))
            .setter(setter(Builder::templateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateArn").build()).build();

    private static final SdkField<ReviewTemplateLensReview> LENS_REVIEW_FIELD = SdkField
            .<ReviewTemplateLensReview> builder(MarshallingType.SDK_POJO).memberName("LensReview")
            .getter(getter(GetReviewTemplateLensReviewResponse::lensReview)).setter(setter(Builder::lensReview))
            .constructor(ReviewTemplateLensReview::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensReview").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_ARN_FIELD,
            LENS_REVIEW_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String templateArn;

    private final ReviewTemplateLensReview lensReview;

    private GetReviewTemplateLensReviewResponse(BuilderImpl builder) {
        super(builder);
        this.templateArn = builder.templateArn;
        this.lensReview = builder.lensReview;
    }

    /**
     * <p>
     * The review template ARN.
     * </p>
     * 
     * @return The review template ARN.
     */
    public final String templateArn() {
        return templateArn;
    }

    /**
     * <p>
     * A lens review of a question.
     * </p>
     * 
     * @return A lens review of a question.
     */
    public final ReviewTemplateLensReview lensReview() {
        return lensReview;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(templateArn());
        hashCode = 31 * hashCode + Objects.hashCode(lensReview());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReviewTemplateLensReviewResponse)) {
            return false;
        }
        GetReviewTemplateLensReviewResponse other = (GetReviewTemplateLensReviewResponse) obj;
        return Objects.equals(templateArn(), other.templateArn()) && Objects.equals(lensReview(), other.lensReview());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetReviewTemplateLensReviewResponse").add("TemplateArn", templateArn())
                .add("LensReview", lensReview()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplateArn":
            return Optional.ofNullable(clazz.cast(templateArn()));
        case "LensReview":
            return Optional.ofNullable(clazz.cast(lensReview()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TemplateArn", TEMPLATE_ARN_FIELD);
        map.put("LensReview", LENS_REVIEW_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetReviewTemplateLensReviewResponse, T> g) {
        return obj -> g.apply((GetReviewTemplateLensReviewResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WellArchitectedResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetReviewTemplateLensReviewResponse> {
        /**
         * <p>
         * The review template ARN.
         * </p>
         * 
         * @param templateArn
         *        The review template ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateArn(String templateArn);

        /**
         * <p>
         * A lens review of a question.
         * </p>
         * 
         * @param lensReview
         *        A lens review of a question.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensReview(ReviewTemplateLensReview lensReview);

        /**
         * <p>
         * A lens review of a question.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReviewTemplateLensReview.Builder}
         * avoiding the need to create one manually via {@link ReviewTemplateLensReview#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReviewTemplateLensReview.Builder#build()} is called immediately
         * and its result is passed to {@link #lensReview(ReviewTemplateLensReview)}.
         * 
         * @param lensReview
         *        a consumer that will call methods on {@link ReviewTemplateLensReview.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lensReview(ReviewTemplateLensReview)
         */
        default Builder lensReview(Consumer<ReviewTemplateLensReview.Builder> lensReview) {
            return lensReview(ReviewTemplateLensReview.builder().applyMutation(lensReview).build());
        }
    }

    static final class BuilderImpl extends WellArchitectedResponse.BuilderImpl implements Builder {
        private String templateArn;

        private ReviewTemplateLensReview lensReview;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReviewTemplateLensReviewResponse model) {
            super(model);
            templateArn(model.templateArn);
            lensReview(model.lensReview);
        }

        public final String getTemplateArn() {
            return templateArn;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        @Override
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        public final ReviewTemplateLensReview.Builder getLensReview() {
            return lensReview != null ? lensReview.toBuilder() : null;
        }

        public final void setLensReview(ReviewTemplateLensReview.BuilderImpl lensReview) {
            this.lensReview = lensReview != null ? lensReview.build() : null;
        }

        @Override
        public final Builder lensReview(ReviewTemplateLensReview lensReview) {
            this.lensReview = lensReview;
            return this;
        }

        @Override
        public GetReviewTemplateLensReviewResponse build() {
            return new GetReviewTemplateLensReviewResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
