/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetGlobalSettingsResponse extends WellArchitectedResponse implements
        ToCopyableBuilder<GetGlobalSettingsResponse.Builder, GetGlobalSettingsResponse> {
    private static final SdkField<String> ORGANIZATION_SHARING_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationSharingStatus").getter(getter(GetGlobalSettingsResponse::organizationSharingStatusAsString))
            .setter(setter(Builder::organizationSharingStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationSharingStatus").build())
            .build();

    private static final SdkField<String> DISCOVERY_INTEGRATION_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DiscoveryIntegrationStatus")
            .getter(getter(GetGlobalSettingsResponse::discoveryIntegrationStatusAsString))
            .setter(setter(Builder::discoveryIntegrationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscoveryIntegrationStatus").build())
            .build();

    private static final SdkField<AccountJiraConfigurationOutput> JIRA_CONFIGURATION_FIELD = SdkField
            .<AccountJiraConfigurationOutput> builder(MarshallingType.SDK_POJO).memberName("JiraConfiguration")
            .getter(getter(GetGlobalSettingsResponse::jiraConfiguration)).setter(setter(Builder::jiraConfiguration))
            .constructor(AccountJiraConfigurationOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JiraConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ORGANIZATION_SHARING_STATUS_FIELD, DISCOVERY_INTEGRATION_STATUS_FIELD, JIRA_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String organizationSharingStatus;

    private final String discoveryIntegrationStatus;

    private final AccountJiraConfigurationOutput jiraConfiguration;

    private GetGlobalSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.organizationSharingStatus = builder.organizationSharingStatus;
        this.discoveryIntegrationStatus = builder.discoveryIntegrationStatus;
        this.jiraConfiguration = builder.jiraConfiguration;
    }

    /**
     * <p>
     * Amazon Web Services Organizations sharing status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #organizationSharingStatus} will return {@link OrganizationSharingStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #organizationSharingStatusAsString}.
     * </p>
     * 
     * @return Amazon Web Services Organizations sharing status.
     * @see OrganizationSharingStatus
     */
    public final OrganizationSharingStatus organizationSharingStatus() {
        return OrganizationSharingStatus.fromValue(organizationSharingStatus);
    }

    /**
     * <p>
     * Amazon Web Services Organizations sharing status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #organizationSharingStatus} will return {@link OrganizationSharingStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #organizationSharingStatusAsString}.
     * </p>
     * 
     * @return Amazon Web Services Organizations sharing status.
     * @see OrganizationSharingStatus
     */
    public final String organizationSharingStatusAsString() {
        return organizationSharingStatus;
    }

    /**
     * <p>
     * Discovery integration status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #discoveryIntegrationStatus} will return {@link DiscoveryIntegrationStatus#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #discoveryIntegrationStatusAsString}.
     * </p>
     * 
     * @return Discovery integration status.
     * @see DiscoveryIntegrationStatus
     */
    public final DiscoveryIntegrationStatus discoveryIntegrationStatus() {
        return DiscoveryIntegrationStatus.fromValue(discoveryIntegrationStatus);
    }

    /**
     * <p>
     * Discovery integration status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #discoveryIntegrationStatus} will return {@link DiscoveryIntegrationStatus#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #discoveryIntegrationStatusAsString}.
     * </p>
     * 
     * @return Discovery integration status.
     * @see DiscoveryIntegrationStatus
     */
    public final String discoveryIntegrationStatusAsString() {
        return discoveryIntegrationStatus;
    }

    /**
     * <p>
     * Jira configuration status.
     * </p>
     * 
     * @return Jira configuration status.
     */
    public final AccountJiraConfigurationOutput jiraConfiguration() {
        return jiraConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(organizationSharingStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(discoveryIntegrationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(jiraConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGlobalSettingsResponse)) {
            return false;
        }
        GetGlobalSettingsResponse other = (GetGlobalSettingsResponse) obj;
        return Objects.equals(organizationSharingStatusAsString(), other.organizationSharingStatusAsString())
                && Objects.equals(discoveryIntegrationStatusAsString(), other.discoveryIntegrationStatusAsString())
                && Objects.equals(jiraConfiguration(), other.jiraConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetGlobalSettingsResponse")
                .add("OrganizationSharingStatus", organizationSharingStatusAsString())
                .add("DiscoveryIntegrationStatus", discoveryIntegrationStatusAsString())
                .add("JiraConfiguration", jiraConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationSharingStatus":
            return Optional.ofNullable(clazz.cast(organizationSharingStatusAsString()));
        case "DiscoveryIntegrationStatus":
            return Optional.ofNullable(clazz.cast(discoveryIntegrationStatusAsString()));
        case "JiraConfiguration":
            return Optional.ofNullable(clazz.cast(jiraConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OrganizationSharingStatus", ORGANIZATION_SHARING_STATUS_FIELD);
        map.put("DiscoveryIntegrationStatus", DISCOVERY_INTEGRATION_STATUS_FIELD);
        map.put("JiraConfiguration", JIRA_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetGlobalSettingsResponse, T> g) {
        return obj -> g.apply((GetGlobalSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WellArchitectedResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetGlobalSettingsResponse> {
        /**
         * <p>
         * Amazon Web Services Organizations sharing status.
         * </p>
         * 
         * @param organizationSharingStatus
         *        Amazon Web Services Organizations sharing status.
         * @see OrganizationSharingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrganizationSharingStatus
         */
        Builder organizationSharingStatus(String organizationSharingStatus);

        /**
         * <p>
         * Amazon Web Services Organizations sharing status.
         * </p>
         * 
         * @param organizationSharingStatus
         *        Amazon Web Services Organizations sharing status.
         * @see OrganizationSharingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrganizationSharingStatus
         */
        Builder organizationSharingStatus(OrganizationSharingStatus organizationSharingStatus);

        /**
         * <p>
         * Discovery integration status.
         * </p>
         * 
         * @param discoveryIntegrationStatus
         *        Discovery integration status.
         * @see DiscoveryIntegrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiscoveryIntegrationStatus
         */
        Builder discoveryIntegrationStatus(String discoveryIntegrationStatus);

        /**
         * <p>
         * Discovery integration status.
         * </p>
         * 
         * @param discoveryIntegrationStatus
         *        Discovery integration status.
         * @see DiscoveryIntegrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiscoveryIntegrationStatus
         */
        Builder discoveryIntegrationStatus(DiscoveryIntegrationStatus discoveryIntegrationStatus);

        /**
         * <p>
         * Jira configuration status.
         * </p>
         * 
         * @param jiraConfiguration
         *        Jira configuration status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jiraConfiguration(AccountJiraConfigurationOutput jiraConfiguration);

        /**
         * <p>
         * Jira configuration status.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccountJiraConfigurationOutput.Builder}
         * avoiding the need to create one manually via {@link AccountJiraConfigurationOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccountJiraConfigurationOutput.Builder#build()} is called
         * immediately and its result is passed to {@link #jiraConfiguration(AccountJiraConfigurationOutput)}.
         * 
         * @param jiraConfiguration
         *        a consumer that will call methods on {@link AccountJiraConfigurationOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jiraConfiguration(AccountJiraConfigurationOutput)
         */
        default Builder jiraConfiguration(Consumer<AccountJiraConfigurationOutput.Builder> jiraConfiguration) {
            return jiraConfiguration(AccountJiraConfigurationOutput.builder().applyMutation(jiraConfiguration).build());
        }
    }

    static final class BuilderImpl extends WellArchitectedResponse.BuilderImpl implements Builder {
        private String organizationSharingStatus;

        private String discoveryIntegrationStatus;

        private AccountJiraConfigurationOutput jiraConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGlobalSettingsResponse model) {
            super(model);
            organizationSharingStatus(model.organizationSharingStatus);
            discoveryIntegrationStatus(model.discoveryIntegrationStatus);
            jiraConfiguration(model.jiraConfiguration);
        }

        public final String getOrganizationSharingStatus() {
            return organizationSharingStatus;
        }

        public final void setOrganizationSharingStatus(String organizationSharingStatus) {
            this.organizationSharingStatus = organizationSharingStatus;
        }

        @Override
        public final Builder organizationSharingStatus(String organizationSharingStatus) {
            this.organizationSharingStatus = organizationSharingStatus;
            return this;
        }

        @Override
        public final Builder organizationSharingStatus(OrganizationSharingStatus organizationSharingStatus) {
            this.organizationSharingStatus(organizationSharingStatus == null ? null : organizationSharingStatus.toString());
            return this;
        }

        public final String getDiscoveryIntegrationStatus() {
            return discoveryIntegrationStatus;
        }

        public final void setDiscoveryIntegrationStatus(String discoveryIntegrationStatus) {
            this.discoveryIntegrationStatus = discoveryIntegrationStatus;
        }

        @Override
        public final Builder discoveryIntegrationStatus(String discoveryIntegrationStatus) {
            this.discoveryIntegrationStatus = discoveryIntegrationStatus;
            return this;
        }

        @Override
        public final Builder discoveryIntegrationStatus(DiscoveryIntegrationStatus discoveryIntegrationStatus) {
            this.discoveryIntegrationStatus(discoveryIntegrationStatus == null ? null : discoveryIntegrationStatus.toString());
            return this;
        }

        public final AccountJiraConfigurationOutput.Builder getJiraConfiguration() {
            return jiraConfiguration != null ? jiraConfiguration.toBuilder() : null;
        }

        public final void setJiraConfiguration(AccountJiraConfigurationOutput.BuilderImpl jiraConfiguration) {
            this.jiraConfiguration = jiraConfiguration != null ? jiraConfiguration.build() : null;
        }

        @Override
        public final Builder jiraConfiguration(AccountJiraConfigurationOutput jiraConfiguration) {
            this.jiraConfiguration = jiraConfiguration;
            return this;
        }

        @Override
        public GetGlobalSettingsResponse build() {
            return new GetGlobalSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
