/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportLensResponse extends WellArchitectedResponse implements
        ToCopyableBuilder<ExportLensResponse.Builder, ExportLensResponse> {
    private static final SdkField<String> LENS_JSON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensJSON").getter(getter(ExportLensResponse::lensJSON)).setter(setter(Builder::lensJSON))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensJSON").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LENS_JSON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String lensJSON;

    private ExportLensResponse(BuilderImpl builder) {
        super(builder);
        this.lensJSON = builder.lensJSON;
    }

    /**
     * <p>
     * The JSON representation of a lens.
     * </p>
     * 
     * @return The JSON representation of a lens.
     */
    public final String lensJSON() {
        return lensJSON;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(lensJSON());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportLensResponse)) {
            return false;
        }
        ExportLensResponse other = (ExportLensResponse) obj;
        return Objects.equals(lensJSON(), other.lensJSON());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportLensResponse").add("LensJSON", lensJSON()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LensJSON":
            return Optional.ofNullable(clazz.cast(lensJSON()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LensJSON", LENS_JSON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportLensResponse, T> g) {
        return obj -> g.apply((ExportLensResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WellArchitectedResponse.Builder, SdkPojo, CopyableBuilder<Builder, ExportLensResponse> {
        /**
         * <p>
         * The JSON representation of a lens.
         * </p>
         * 
         * @param lensJSON
         *        The JSON representation of a lens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensJSON(String lensJSON);
    }

    static final class BuilderImpl extends WellArchitectedResponse.BuilderImpl implements Builder {
        private String lensJSON;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportLensResponse model) {
            super(model);
            lensJSON(model.lensJSON);
        }

        public final String getLensJSON() {
            return lensJSON;
        }

        public final void setLensJSON(String lensJSON) {
            this.lensJSON = lensJSON;
        }

        @Override
        public final Builder lensJSON(String lensJSON) {
            this.lensJSON = lensJSON;
            return this;
        }

        @Override
        public ExportLensResponse build() {
            return new ExportLensResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
