/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input for Create Workload Share
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWorkloadShareResponse extends WellArchitectedResponse implements
        ToCopyableBuilder<CreateWorkloadShareResponse.Builder, CreateWorkloadShareResponse> {
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkloadId").getter(getter(CreateWorkloadShareResponse::workloadId)).setter(setter(Builder::workloadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadId").build()).build();

    private static final SdkField<String> SHARE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShareId").getter(getter(CreateWorkloadShareResponse::shareId)).setter(setter(Builder::shareId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ID_FIELD,
            SHARE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String workloadId;

    private final String shareId;

    private CreateWorkloadShareResponse(BuilderImpl builder) {
        super(builder);
        this.workloadId = builder.workloadId;
        this.shareId = builder.shareId;
    }

    /**
     * Returns the value of the WorkloadId property for this object.
     * 
     * @return The value of the WorkloadId property for this object.
     */
    public final String workloadId() {
        return workloadId;
    }

    /**
     * Returns the value of the ShareId property for this object.
     * 
     * @return The value of the ShareId property for this object.
     */
    public final String shareId() {
        return shareId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(shareId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkloadShareResponse)) {
            return false;
        }
        CreateWorkloadShareResponse other = (CreateWorkloadShareResponse) obj;
        return Objects.equals(workloadId(), other.workloadId()) && Objects.equals(shareId(), other.shareId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWorkloadShareResponse").add("WorkloadId", workloadId()).add("ShareId", shareId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkloadId":
            return Optional.ofNullable(clazz.cast(workloadId()));
        case "ShareId":
            return Optional.ofNullable(clazz.cast(shareId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WorkloadId", WORKLOAD_ID_FIELD);
        map.put("ShareId", SHARE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkloadShareResponse, T> g) {
        return obj -> g.apply((CreateWorkloadShareResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WellArchitectedResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateWorkloadShareResponse> {
        /**
         * Sets the value of the WorkloadId property for this object.
         *
         * @param workloadId
         *        The new value for the WorkloadId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadId(String workloadId);

        /**
         * Sets the value of the ShareId property for this object.
         *
         * @param shareId
         *        The new value for the ShareId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareId(String shareId);
    }

    static final class BuilderImpl extends WellArchitectedResponse.BuilderImpl implements Builder {
        private String workloadId;

        private String shareId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkloadShareResponse model) {
            super(model);
            workloadId(model.workloadId);
            shareId(model.shareId);
        }

        public final String getWorkloadId() {
            return workloadId;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final String getShareId() {
            return shareId;
        }

        public final void setShareId(String shareId) {
            this.shareId = shareId;
        }

        @Override
        public final Builder shareId(String shareId) {
            this.shareId = shareId;
            return this;
        }

        @Override
        public CreateWorkloadShareResponse build() {
            return new CreateWorkloadShareResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
