/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A choice that has been answered on a question in your workload.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChoiceAnswer implements SdkPojo, Serializable, ToCopyableBuilder<ChoiceAnswer.Builder, ChoiceAnswer> {
    private static final SdkField<String> CHOICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChoiceId").getter(getter(ChoiceAnswer::choiceId)).setter(setter(Builder::choiceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChoiceId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ChoiceAnswer::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reason")
            .getter(getter(ChoiceAnswer::reasonAsString)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final SdkField<String> NOTES_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Notes")
            .getter(getter(ChoiceAnswer::notes)).setter(setter(Builder::notes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHOICE_ID_FIELD, STATUS_FIELD,
            REASON_FIELD, NOTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String choiceId;

    private final String status;

    private final String reason;

    private final String notes;

    private ChoiceAnswer(BuilderImpl builder) {
        this.choiceId = builder.choiceId;
        this.status = builder.status;
        this.reason = builder.reason;
        this.notes = builder.notes;
    }

    /**
     * Returns the value of the ChoiceId property for this object.
     * 
     * @return The value of the ChoiceId property for this object.
     */
    public final String choiceId() {
        return choiceId;
    }

    /**
     * <p>
     * The status of a choice.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ChoiceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a choice.
     * @see ChoiceStatus
     */
    public final ChoiceStatus status() {
        return ChoiceStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of a choice.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ChoiceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a choice.
     * @see ChoiceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The reason why a choice is non-applicable to a question in your workload.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link ChoiceReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reasonAsString}.
     * </p>
     * 
     * @return The reason why a choice is non-applicable to a question in your workload.
     * @see ChoiceReason
     */
    public final ChoiceReason reason() {
        return ChoiceReason.fromValue(reason);
    }

    /**
     * <p>
     * The reason why a choice is non-applicable to a question in your workload.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link ChoiceReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reasonAsString}.
     * </p>
     * 
     * @return The reason why a choice is non-applicable to a question in your workload.
     * @see ChoiceReason
     */
    public final String reasonAsString() {
        return reason;
    }

    /**
     * <p>
     * The notes associated with a choice.
     * </p>
     * 
     * @return The notes associated with a choice.
     */
    public final String notes() {
        return notes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(choiceId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(notes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChoiceAnswer)) {
            return false;
        }
        ChoiceAnswer other = (ChoiceAnswer) obj;
        return Objects.equals(choiceId(), other.choiceId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(reasonAsString(), other.reasonAsString()) && Objects.equals(notes(), other.notes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChoiceAnswer").add("ChoiceId", choiceId()).add("Status", statusAsString())
                .add("Reason", reasonAsString()).add("Notes", notes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChoiceId":
            return Optional.ofNullable(clazz.cast(choiceId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Reason":
            return Optional.ofNullable(clazz.cast(reasonAsString()));
        case "Notes":
            return Optional.ofNullable(clazz.cast(notes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ChoiceId", CHOICE_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Reason", REASON_FIELD);
        map.put("Notes", NOTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChoiceAnswer, T> g) {
        return obj -> g.apply((ChoiceAnswer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChoiceAnswer> {
        /**
         * Sets the value of the ChoiceId property for this object.
         *
         * @param choiceId
         *        The new value for the ChoiceId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder choiceId(String choiceId);

        /**
         * <p>
         * The status of a choice.
         * </p>
         * 
         * @param status
         *        The status of a choice.
         * @see ChoiceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChoiceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of a choice.
         * </p>
         * 
         * @param status
         *        The status of a choice.
         * @see ChoiceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChoiceStatus
         */
        Builder status(ChoiceStatus status);

        /**
         * <p>
         * The reason why a choice is non-applicable to a question in your workload.
         * </p>
         * 
         * @param reason
         *        The reason why a choice is non-applicable to a question in your workload.
         * @see ChoiceReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChoiceReason
         */
        Builder reason(String reason);

        /**
         * <p>
         * The reason why a choice is non-applicable to a question in your workload.
         * </p>
         * 
         * @param reason
         *        The reason why a choice is non-applicable to a question in your workload.
         * @see ChoiceReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChoiceReason
         */
        Builder reason(ChoiceReason reason);

        /**
         * <p>
         * The notes associated with a choice.
         * </p>
         * 
         * @param notes
         *        The notes associated with a choice.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notes(String notes);
    }

    static final class BuilderImpl implements Builder {
        private String choiceId;

        private String status;

        private String reason;

        private String notes;

        private BuilderImpl() {
        }

        private BuilderImpl(ChoiceAnswer model) {
            choiceId(model.choiceId);
            status(model.status);
            reason(model.reason);
            notes(model.notes);
        }

        public final String getChoiceId() {
            return choiceId;
        }

        public final void setChoiceId(String choiceId) {
            this.choiceId = choiceId;
        }

        @Override
        public final Builder choiceId(String choiceId) {
            this.choiceId = choiceId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ChoiceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(ChoiceReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        public final String getNotes() {
            return notes;
        }

        public final void setNotes(String notes) {
            this.notes = notes;
        }

        @Override
        public final Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        @Override
        public ChoiceAnswer build() {
            return new ChoiceAnswer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
