/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Trusted Advisor check summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CheckSummary implements SdkPojo, Serializable, ToCopyableBuilder<CheckSummary.Builder, CheckSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(CheckSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CheckSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Provider").getter(getter(CheckSummary::providerAsString)).setter(setter(Builder::provider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Provider").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CheckSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(CheckSummary::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final SdkField<String> LENS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensArn").getter(getter(CheckSummary::lensArn)).setter(setter(Builder::lensArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensArn").build()).build();

    private static final SdkField<String> PILLAR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PillarId").getter(getter(CheckSummary::pillarId)).setter(setter(Builder::pillarId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PillarId").build()).build();

    private static final SdkField<String> QUESTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuestionId").getter(getter(CheckSummary::questionId)).setter(setter(Builder::questionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionId").build()).build();

    private static final SdkField<String> CHOICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChoiceId").getter(getter(CheckSummary::choiceId)).setter(setter(Builder::choiceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChoiceId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(CheckSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Map<String, Integer>> ACCOUNT_SUMMARY_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("AccountSummary")
            .getter(getter(CheckSummary::accountSummaryAsStrings))
            .setter(setter(Builder::accountSummaryWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountSummary").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            PROVIDER_FIELD, DESCRIPTION_FIELD, UPDATED_AT_FIELD, LENS_ARN_FIELD, PILLAR_ID_FIELD, QUESTION_ID_FIELD,
            CHOICE_ID_FIELD, STATUS_FIELD, ACCOUNT_SUMMARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String provider;

    private final String description;

    private final Instant updatedAt;

    private final String lensArn;

    private final String pillarId;

    private final String questionId;

    private final String choiceId;

    private final String status;

    private final Map<String, Integer> accountSummary;

    private CheckSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.provider = builder.provider;
        this.description = builder.description;
        this.updatedAt = builder.updatedAt;
        this.lensArn = builder.lensArn;
        this.pillarId = builder.pillarId;
        this.questionId = builder.questionId;
        this.choiceId = builder.choiceId;
        this.status = builder.status;
        this.accountSummary = builder.accountSummary;
    }

    /**
     * <p>
     * Trusted Advisor check ID.
     * </p>
     * 
     * @return Trusted Advisor check ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Trusted Advisor check name.
     * </p>
     * 
     * @return Trusted Advisor check name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Provider of the check related to the best practice.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #provider} will
     * return {@link CheckProvider#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #providerAsString}.
     * </p>
     * 
     * @return Provider of the check related to the best practice.
     * @see CheckProvider
     */
    public final CheckProvider provider() {
        return CheckProvider.fromValue(provider);
    }

    /**
     * <p>
     * Provider of the check related to the best practice.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #provider} will
     * return {@link CheckProvider#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #providerAsString}.
     * </p>
     * 
     * @return Provider of the check related to the best practice.
     * @see CheckProvider
     */
    public final String providerAsString() {
        return provider;
    }

    /**
     * <p>
     * Trusted Advisor check description.
     * </p>
     * 
     * @return Trusted Advisor check description.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns the value of the UpdatedAt property for this object.
     * 
     * @return The value of the UpdatedAt property for this object.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * Well-Architected Lens ARN associated to the check.
     * </p>
     * 
     * @return Well-Architected Lens ARN associated to the check.
     */
    public final String lensArn() {
        return lensArn;
    }

    /**
     * Returns the value of the PillarId property for this object.
     * 
     * @return The value of the PillarId property for this object.
     */
    public final String pillarId() {
        return pillarId;
    }

    /**
     * Returns the value of the QuestionId property for this object.
     * 
     * @return The value of the QuestionId property for this object.
     */
    public final String questionId() {
        return questionId;
    }

    /**
     * Returns the value of the ChoiceId property for this object.
     * 
     * @return The value of the ChoiceId property for this object.
     */
    public final String choiceId() {
        return choiceId;
    }

    /**
     * <p>
     * Status associated to the check.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CheckStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status associated to the check.
     * @see CheckStatus
     */
    public final CheckStatus status() {
        return CheckStatus.fromValue(status);
    }

    /**
     * <p>
     * Status associated to the check.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CheckStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status associated to the check.
     * @see CheckStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Account summary associated to the check.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountSummary} method.
     * </p>
     * 
     * @return Account summary associated to the check.
     */
    public final Map<CheckStatus, Integer> accountSummary() {
        return AccountSummaryCopier.copyStringToEnum(accountSummary);
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountSummary property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAccountSummary() {
        return accountSummary != null && !(accountSummary instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Account summary associated to the check.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountSummary} method.
     * </p>
     * 
     * @return Account summary associated to the check.
     */
    public final Map<String, Integer> accountSummaryAsStrings() {
        return accountSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(providerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(lensArn());
        hashCode = 31 * hashCode + Objects.hashCode(pillarId());
        hashCode = 31 * hashCode + Objects.hashCode(questionId());
        hashCode = 31 * hashCode + Objects.hashCode(choiceId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountSummary() ? accountSummaryAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckSummary)) {
            return false;
        }
        CheckSummary other = (CheckSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(providerAsString(), other.providerAsString())
                && Objects.equals(description(), other.description()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(lensArn(), other.lensArn()) && Objects.equals(pillarId(), other.pillarId())
                && Objects.equals(questionId(), other.questionId()) && Objects.equals(choiceId(), other.choiceId())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasAccountSummary() == other.hasAccountSummary()
                && Objects.equals(accountSummaryAsStrings(), other.accountSummaryAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CheckSummary").add("Id", id()).add("Name", name()).add("Provider", providerAsString())
                .add("Description", description()).add("UpdatedAt", updatedAt()).add("LensArn", lensArn())
                .add("PillarId", pillarId()).add("QuestionId", questionId()).add("ChoiceId", choiceId())
                .add("Status", statusAsString()).add("AccountSummary", hasAccountSummary() ? accountSummaryAsStrings() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Provider":
            return Optional.ofNullable(clazz.cast(providerAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "LensArn":
            return Optional.ofNullable(clazz.cast(lensArn()));
        case "PillarId":
            return Optional.ofNullable(clazz.cast(pillarId()));
        case "QuestionId":
            return Optional.ofNullable(clazz.cast(questionId()));
        case "ChoiceId":
            return Optional.ofNullable(clazz.cast(choiceId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "AccountSummary":
            return Optional.ofNullable(clazz.cast(accountSummaryAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Provider", PROVIDER_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        map.put("LensArn", LENS_ARN_FIELD);
        map.put("PillarId", PILLAR_ID_FIELD);
        map.put("QuestionId", QUESTION_ID_FIELD);
        map.put("ChoiceId", CHOICE_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("AccountSummary", ACCOUNT_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CheckSummary, T> g) {
        return obj -> g.apply((CheckSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CheckSummary> {
        /**
         * <p>
         * Trusted Advisor check ID.
         * </p>
         * 
         * @param id
         *        Trusted Advisor check ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Trusted Advisor check name.
         * </p>
         * 
         * @param name
         *        Trusted Advisor check name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Provider of the check related to the best practice.
         * </p>
         * 
         * @param provider
         *        Provider of the check related to the best practice.
         * @see CheckProvider
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CheckProvider
         */
        Builder provider(String provider);

        /**
         * <p>
         * Provider of the check related to the best practice.
         * </p>
         * 
         * @param provider
         *        Provider of the check related to the best practice.
         * @see CheckProvider
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CheckProvider
         */
        Builder provider(CheckProvider provider);

        /**
         * <p>
         * Trusted Advisor check description.
         * </p>
         * 
         * @param description
         *        Trusted Advisor check description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Sets the value of the UpdatedAt property for this object.
         *
         * @param updatedAt
         *        The new value for the UpdatedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * Well-Architected Lens ARN associated to the check.
         * </p>
         * 
         * @param lensArn
         *        Well-Architected Lens ARN associated to the check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensArn(String lensArn);

        /**
         * Sets the value of the PillarId property for this object.
         *
         * @param pillarId
         *        The new value for the PillarId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pillarId(String pillarId);

        /**
         * Sets the value of the QuestionId property for this object.
         *
         * @param questionId
         *        The new value for the QuestionId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder questionId(String questionId);

        /**
         * Sets the value of the ChoiceId property for this object.
         *
         * @param choiceId
         *        The new value for the ChoiceId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder choiceId(String choiceId);

        /**
         * <p>
         * Status associated to the check.
         * </p>
         * 
         * @param status
         *        Status associated to the check.
         * @see CheckStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CheckStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status associated to the check.
         * </p>
         * 
         * @param status
         *        Status associated to the check.
         * @see CheckStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CheckStatus
         */
        Builder status(CheckStatus status);

        /**
         * <p>
         * Account summary associated to the check.
         * </p>
         * 
         * @param accountSummary
         *        Account summary associated to the check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountSummaryWithStrings(Map<String, Integer> accountSummary);

        /**
         * <p>
         * Account summary associated to the check.
         * </p>
         * 
         * @param accountSummary
         *        Account summary associated to the check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountSummary(Map<CheckStatus, Integer> accountSummary);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String provider;

        private String description;

        private Instant updatedAt;

        private String lensArn;

        private String pillarId;

        private String questionId;

        private String choiceId;

        private String status;

        private Map<String, Integer> accountSummary = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CheckSummary model) {
            id(model.id);
            name(model.name);
            provider(model.provider);
            description(model.description);
            updatedAt(model.updatedAt);
            lensArn(model.lensArn);
            pillarId(model.pillarId);
            questionId(model.questionId);
            choiceId(model.choiceId);
            status(model.status);
            accountSummaryWithStrings(model.accountSummary);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProvider() {
            return provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        @Override
        public final Builder provider(CheckProvider provider) {
            this.provider(provider == null ? null : provider.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getLensArn() {
            return lensArn;
        }

        public final void setLensArn(String lensArn) {
            this.lensArn = lensArn;
        }

        @Override
        public final Builder lensArn(String lensArn) {
            this.lensArn = lensArn;
            return this;
        }

        public final String getPillarId() {
            return pillarId;
        }

        public final void setPillarId(String pillarId) {
            this.pillarId = pillarId;
        }

        @Override
        public final Builder pillarId(String pillarId) {
            this.pillarId = pillarId;
            return this;
        }

        public final String getQuestionId() {
            return questionId;
        }

        public final void setQuestionId(String questionId) {
            this.questionId = questionId;
        }

        @Override
        public final Builder questionId(String questionId) {
            this.questionId = questionId;
            return this;
        }

        public final String getChoiceId() {
            return choiceId;
        }

        public final void setChoiceId(String choiceId) {
            this.choiceId = choiceId;
        }

        @Override
        public final Builder choiceId(String choiceId) {
            this.choiceId = choiceId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CheckStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, Integer> getAccountSummary() {
            if (accountSummary instanceof SdkAutoConstructMap) {
                return null;
            }
            return accountSummary;
        }

        public final void setAccountSummary(Map<String, Integer> accountSummary) {
            this.accountSummary = AccountSummaryCopier.copy(accountSummary);
        }

        @Override
        public final Builder accountSummaryWithStrings(Map<String, Integer> accountSummary) {
            this.accountSummary = AccountSummaryCopier.copy(accountSummary);
            return this;
        }

        @Override
        public final Builder accountSummary(Map<CheckStatus, Integer> accountSummary) {
            this.accountSummary = AccountSummaryCopier.copyEnumToString(accountSummary);
            return this;
        }

        @Override
        public CheckSummary build() {
            return new CheckSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
