/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Account details for a Well-Architected best practice in relation to Trusted Advisor checks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CheckDetail implements SdkPojo, Serializable, ToCopyableBuilder<CheckDetail.Builder, CheckDetail> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(CheckDetail::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CheckDetail::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CheckDetail::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Provider").getter(getter(CheckDetail::providerAsString)).setter(setter(Builder::provider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Provider").build()).build();

    private static final SdkField<String> LENS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensArn").getter(getter(CheckDetail::lensArn)).setter(setter(Builder::lensArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensArn").build()).build();

    private static final SdkField<String> PILLAR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PillarId").getter(getter(CheckDetail::pillarId)).setter(setter(Builder::pillarId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PillarId").build()).build();

    private static final SdkField<String> QUESTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuestionId").getter(getter(CheckDetail::questionId)).setter(setter(Builder::questionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionId").build()).build();

    private static final SdkField<String> CHOICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChoiceId").getter(getter(CheckDetail::choiceId)).setter(setter(Builder::choiceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChoiceId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(CheckDetail::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(CheckDetail::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<Integer> FLAGGED_RESOURCES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FlaggedResources").getter(getter(CheckDetail::flaggedResources))
            .setter(setter(Builder::flaggedResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlaggedResources").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reason")
            .getter(getter(CheckDetail::reasonAsString)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(CheckDetail::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, PROVIDER_FIELD, LENS_ARN_FIELD, PILLAR_ID_FIELD, QUESTION_ID_FIELD, CHOICE_ID_FIELD, STATUS_FIELD,
            ACCOUNT_ID_FIELD, FLAGGED_RESOURCES_FIELD, REASON_FIELD, UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String description;

    private final String provider;

    private final String lensArn;

    private final String pillarId;

    private final String questionId;

    private final String choiceId;

    private final String status;

    private final String accountId;

    private final Integer flaggedResources;

    private final String reason;

    private final Instant updatedAt;

    private CheckDetail(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.provider = builder.provider;
        this.lensArn = builder.lensArn;
        this.pillarId = builder.pillarId;
        this.questionId = builder.questionId;
        this.choiceId = builder.choiceId;
        this.status = builder.status;
        this.accountId = builder.accountId;
        this.flaggedResources = builder.flaggedResources;
        this.reason = builder.reason;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * Trusted Advisor check ID.
     * </p>
     * 
     * @return Trusted Advisor check ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Trusted Advisor check name.
     * </p>
     * 
     * @return Trusted Advisor check name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Trusted Advisor check description.
     * </p>
     * 
     * @return Trusted Advisor check description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Provider of the check related to the best practice.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #provider} will
     * return {@link CheckProvider#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #providerAsString}.
     * </p>
     * 
     * @return Provider of the check related to the best practice.
     * @see CheckProvider
     */
    public final CheckProvider provider() {
        return CheckProvider.fromValue(provider);
    }

    /**
     * <p>
     * Provider of the check related to the best practice.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #provider} will
     * return {@link CheckProvider#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #providerAsString}.
     * </p>
     * 
     * @return Provider of the check related to the best practice.
     * @see CheckProvider
     */
    public final String providerAsString() {
        return provider;
    }

    /**
     * <p>
     * Well-Architected Lens ARN associated to the check.
     * </p>
     * 
     * @return Well-Architected Lens ARN associated to the check.
     */
    public final String lensArn() {
        return lensArn;
    }

    /**
     * Returns the value of the PillarId property for this object.
     * 
     * @return The value of the PillarId property for this object.
     */
    public final String pillarId() {
        return pillarId;
    }

    /**
     * Returns the value of the QuestionId property for this object.
     * 
     * @return The value of the QuestionId property for this object.
     */
    public final String questionId() {
        return questionId;
    }

    /**
     * Returns the value of the ChoiceId property for this object.
     * 
     * @return The value of the ChoiceId property for this object.
     */
    public final String choiceId() {
        return choiceId;
    }

    /**
     * <p>
     * Status associated to the check.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CheckStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status associated to the check.
     * @see CheckStatus
     */
    public final CheckStatus status() {
        return CheckStatus.fromValue(status);
    }

    /**
     * <p>
     * Status associated to the check.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CheckStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status associated to the check.
     * @see CheckStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * Returns the value of the AccountId property for this object.
     * 
     * @return The value of the AccountId property for this object.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * Count of flagged resources associated to the check.
     * </p>
     * 
     * @return Count of flagged resources associated to the check.
     */
    public final Integer flaggedResources() {
        return flaggedResources;
    }

    /**
     * <p>
     * Reason associated to the check.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link CheckFailureReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reasonAsString}.
     * </p>
     * 
     * @return Reason associated to the check.
     * @see CheckFailureReason
     */
    public final CheckFailureReason reason() {
        return CheckFailureReason.fromValue(reason);
    }

    /**
     * <p>
     * Reason associated to the check.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link CheckFailureReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reasonAsString}.
     * </p>
     * 
     * @return Reason associated to the check.
     * @see CheckFailureReason
     */
    public final String reasonAsString() {
        return reason;
    }

    /**
     * Returns the value of the UpdatedAt property for this object.
     * 
     * @return The value of the UpdatedAt property for this object.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(providerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lensArn());
        hashCode = 31 * hashCode + Objects.hashCode(pillarId());
        hashCode = 31 * hashCode + Objects.hashCode(questionId());
        hashCode = 31 * hashCode + Objects.hashCode(choiceId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(flaggedResources());
        hashCode = 31 * hashCode + Objects.hashCode(reasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckDetail)) {
            return false;
        }
        CheckDetail other = (CheckDetail) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(providerAsString(), other.providerAsString()) && Objects.equals(lensArn(), other.lensArn())
                && Objects.equals(pillarId(), other.pillarId()) && Objects.equals(questionId(), other.questionId())
                && Objects.equals(choiceId(), other.choiceId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(accountId(), other.accountId()) && Objects.equals(flaggedResources(), other.flaggedResources())
                && Objects.equals(reasonAsString(), other.reasonAsString()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CheckDetail").add("Id", id()).add("Name", name()).add("Description", description())
                .add("Provider", providerAsString()).add("LensArn", lensArn()).add("PillarId", pillarId())
                .add("QuestionId", questionId()).add("ChoiceId", choiceId()).add("Status", statusAsString())
                .add("AccountId", accountId()).add("FlaggedResources", flaggedResources()).add("Reason", reasonAsString())
                .add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Provider":
            return Optional.ofNullable(clazz.cast(providerAsString()));
        case "LensArn":
            return Optional.ofNullable(clazz.cast(lensArn()));
        case "PillarId":
            return Optional.ofNullable(clazz.cast(pillarId()));
        case "QuestionId":
            return Optional.ofNullable(clazz.cast(questionId()));
        case "ChoiceId":
            return Optional.ofNullable(clazz.cast(choiceId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "FlaggedResources":
            return Optional.ofNullable(clazz.cast(flaggedResources()));
        case "Reason":
            return Optional.ofNullable(clazz.cast(reasonAsString()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Provider", PROVIDER_FIELD);
        map.put("LensArn", LENS_ARN_FIELD);
        map.put("PillarId", PILLAR_ID_FIELD);
        map.put("QuestionId", QUESTION_ID_FIELD);
        map.put("ChoiceId", CHOICE_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("FlaggedResources", FLAGGED_RESOURCES_FIELD);
        map.put("Reason", REASON_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CheckDetail, T> g) {
        return obj -> g.apply((CheckDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CheckDetail> {
        /**
         * <p>
         * Trusted Advisor check ID.
         * </p>
         * 
         * @param id
         *        Trusted Advisor check ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Trusted Advisor check name.
         * </p>
         * 
         * @param name
         *        Trusted Advisor check name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Trusted Advisor check description.
         * </p>
         * 
         * @param description
         *        Trusted Advisor check description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Provider of the check related to the best practice.
         * </p>
         * 
         * @param provider
         *        Provider of the check related to the best practice.
         * @see CheckProvider
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CheckProvider
         */
        Builder provider(String provider);

        /**
         * <p>
         * Provider of the check related to the best practice.
         * </p>
         * 
         * @param provider
         *        Provider of the check related to the best practice.
         * @see CheckProvider
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CheckProvider
         */
        Builder provider(CheckProvider provider);

        /**
         * <p>
         * Well-Architected Lens ARN associated to the check.
         * </p>
         * 
         * @param lensArn
         *        Well-Architected Lens ARN associated to the check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensArn(String lensArn);

        /**
         * Sets the value of the PillarId property for this object.
         *
         * @param pillarId
         *        The new value for the PillarId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pillarId(String pillarId);

        /**
         * Sets the value of the QuestionId property for this object.
         *
         * @param questionId
         *        The new value for the QuestionId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder questionId(String questionId);

        /**
         * Sets the value of the ChoiceId property for this object.
         *
         * @param choiceId
         *        The new value for the ChoiceId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder choiceId(String choiceId);

        /**
         * <p>
         * Status associated to the check.
         * </p>
         * 
         * @param status
         *        Status associated to the check.
         * @see CheckStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CheckStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status associated to the check.
         * </p>
         * 
         * @param status
         *        Status associated to the check.
         * @see CheckStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CheckStatus
         */
        Builder status(CheckStatus status);

        /**
         * Sets the value of the AccountId property for this object.
         *
         * @param accountId
         *        The new value for the AccountId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * Count of flagged resources associated to the check.
         * </p>
         * 
         * @param flaggedResources
         *        Count of flagged resources associated to the check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flaggedResources(Integer flaggedResources);

        /**
         * <p>
         * Reason associated to the check.
         * </p>
         * 
         * @param reason
         *        Reason associated to the check.
         * @see CheckFailureReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CheckFailureReason
         */
        Builder reason(String reason);

        /**
         * <p>
         * Reason associated to the check.
         * </p>
         * 
         * @param reason
         *        Reason associated to the check.
         * @see CheckFailureReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CheckFailureReason
         */
        Builder reason(CheckFailureReason reason);

        /**
         * Sets the value of the UpdatedAt property for this object.
         *
         * @param updatedAt
         *        The new value for the UpdatedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String description;

        private String provider;

        private String lensArn;

        private String pillarId;

        private String questionId;

        private String choiceId;

        private String status;

        private String accountId;

        private Integer flaggedResources;

        private String reason;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckDetail model) {
            id(model.id);
            name(model.name);
            description(model.description);
            provider(model.provider);
            lensArn(model.lensArn);
            pillarId(model.pillarId);
            questionId(model.questionId);
            choiceId(model.choiceId);
            status(model.status);
            accountId(model.accountId);
            flaggedResources(model.flaggedResources);
            reason(model.reason);
            updatedAt(model.updatedAt);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getProvider() {
            return provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        @Override
        public final Builder provider(CheckProvider provider) {
            this.provider(provider == null ? null : provider.toString());
            return this;
        }

        public final String getLensArn() {
            return lensArn;
        }

        public final void setLensArn(String lensArn) {
            this.lensArn = lensArn;
        }

        @Override
        public final Builder lensArn(String lensArn) {
            this.lensArn = lensArn;
            return this;
        }

        public final String getPillarId() {
            return pillarId;
        }

        public final void setPillarId(String pillarId) {
            this.pillarId = pillarId;
        }

        @Override
        public final Builder pillarId(String pillarId) {
            this.pillarId = pillarId;
            return this;
        }

        public final String getQuestionId() {
            return questionId;
        }

        public final void setQuestionId(String questionId) {
            this.questionId = questionId;
        }

        @Override
        public final Builder questionId(String questionId) {
            this.questionId = questionId;
            return this;
        }

        public final String getChoiceId() {
            return choiceId;
        }

        public final void setChoiceId(String choiceId) {
            this.choiceId = choiceId;
        }

        @Override
        public final Builder choiceId(String choiceId) {
            this.choiceId = choiceId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CheckStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Integer getFlaggedResources() {
            return flaggedResources;
        }

        public final void setFlaggedResources(Integer flaggedResources) {
            this.flaggedResources = flaggedResources;
        }

        @Override
        public final Builder flaggedResources(Integer flaggedResources) {
            this.flaggedResources = flaggedResources;
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(CheckFailureReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public CheckDetail build() {
            return new CheckDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
