/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An answer of the question.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Answer implements SdkPojo, Serializable, ToCopyableBuilder<Answer.Builder, Answer> {
    private static final SdkField<String> QUESTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuestionId").getter(getter(Answer::questionId)).setter(setter(Builder::questionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionId").build()).build();

    private static final SdkField<String> PILLAR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PillarId").getter(getter(Answer::pillarId)).setter(setter(Builder::pillarId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PillarId").build()).build();

    private static final SdkField<String> QUESTION_TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuestionTitle").getter(getter(Answer::questionTitle)).setter(setter(Builder::questionTitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionTitle").build()).build();

    private static final SdkField<String> QUESTION_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuestionDescription").getter(getter(Answer::questionDescription))
            .setter(setter(Builder::questionDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionDescription").build())
            .build();

    private static final SdkField<String> IMPROVEMENT_PLAN_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImprovementPlanUrl").getter(getter(Answer::improvementPlanUrl))
            .setter(setter(Builder::improvementPlanUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImprovementPlanUrl").build())
            .build();

    private static final SdkField<String> HELPFUL_RESOURCE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HelpfulResourceUrl").getter(getter(Answer::helpfulResourceUrl))
            .setter(setter(Builder::helpfulResourceUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HelpfulResourceUrl").build())
            .build();

    private static final SdkField<String> HELPFUL_RESOURCE_DISPLAY_TEXT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HelpfulResourceDisplayText")
            .getter(getter(Answer::helpfulResourceDisplayText))
            .setter(setter(Builder::helpfulResourceDisplayText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HelpfulResourceDisplayText").build())
            .build();

    private static final SdkField<List<Choice>> CHOICES_FIELD = SdkField
            .<List<Choice>> builder(MarshallingType.LIST)
            .memberName("Choices")
            .getter(getter(Answer::choices))
            .setter(setter(Builder::choices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Choices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Choice> builder(MarshallingType.SDK_POJO)
                                            .constructor(Choice::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SELECTED_CHOICES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SelectedChoices")
            .getter(getter(Answer::selectedChoices))
            .setter(setter(Builder::selectedChoices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedChoices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ChoiceAnswer>> CHOICE_ANSWERS_FIELD = SdkField
            .<List<ChoiceAnswer>> builder(MarshallingType.LIST)
            .memberName("ChoiceAnswers")
            .getter(getter(Answer::choiceAnswers))
            .setter(setter(Builder::choiceAnswers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChoiceAnswers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ChoiceAnswer> builder(MarshallingType.SDK_POJO)
                                            .constructor(ChoiceAnswer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_APPLICABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsApplicable").getter(getter(Answer::isApplicable)).setter(setter(Builder::isApplicable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsApplicable").build()).build();

    private static final SdkField<String> RISK_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Risk")
            .getter(getter(Answer::riskAsString)).setter(setter(Builder::risk))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Risk").build()).build();

    private static final SdkField<String> NOTES_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Notes")
            .getter(getter(Answer::notes)).setter(setter(Builder::notes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reason")
            .getter(getter(Answer::reasonAsString)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final SdkField<JiraConfiguration> JIRA_CONFIGURATION_FIELD = SdkField
            .<JiraConfiguration> builder(MarshallingType.SDK_POJO).memberName("JiraConfiguration")
            .getter(getter(Answer::jiraConfiguration)).setter(setter(Builder::jiraConfiguration))
            .constructor(JiraConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JiraConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUESTION_ID_FIELD,
            PILLAR_ID_FIELD, QUESTION_TITLE_FIELD, QUESTION_DESCRIPTION_FIELD, IMPROVEMENT_PLAN_URL_FIELD,
            HELPFUL_RESOURCE_URL_FIELD, HELPFUL_RESOURCE_DISPLAY_TEXT_FIELD, CHOICES_FIELD, SELECTED_CHOICES_FIELD,
            CHOICE_ANSWERS_FIELD, IS_APPLICABLE_FIELD, RISK_FIELD, NOTES_FIELD, REASON_FIELD, JIRA_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String questionId;

    private final String pillarId;

    private final String questionTitle;

    private final String questionDescription;

    private final String improvementPlanUrl;

    private final String helpfulResourceUrl;

    private final String helpfulResourceDisplayText;

    private final List<Choice> choices;

    private final List<String> selectedChoices;

    private final List<ChoiceAnswer> choiceAnswers;

    private final Boolean isApplicable;

    private final String risk;

    private final String notes;

    private final String reason;

    private final JiraConfiguration jiraConfiguration;

    private Answer(BuilderImpl builder) {
        this.questionId = builder.questionId;
        this.pillarId = builder.pillarId;
        this.questionTitle = builder.questionTitle;
        this.questionDescription = builder.questionDescription;
        this.improvementPlanUrl = builder.improvementPlanUrl;
        this.helpfulResourceUrl = builder.helpfulResourceUrl;
        this.helpfulResourceDisplayText = builder.helpfulResourceDisplayText;
        this.choices = builder.choices;
        this.selectedChoices = builder.selectedChoices;
        this.choiceAnswers = builder.choiceAnswers;
        this.isApplicable = builder.isApplicable;
        this.risk = builder.risk;
        this.notes = builder.notes;
        this.reason = builder.reason;
        this.jiraConfiguration = builder.jiraConfiguration;
    }

    /**
     * Returns the value of the QuestionId property for this object.
     * 
     * @return The value of the QuestionId property for this object.
     */
    public final String questionId() {
        return questionId;
    }

    /**
     * Returns the value of the PillarId property for this object.
     * 
     * @return The value of the PillarId property for this object.
     */
    public final String pillarId() {
        return pillarId;
    }

    /**
     * Returns the value of the QuestionTitle property for this object.
     * 
     * @return The value of the QuestionTitle property for this object.
     */
    public final String questionTitle() {
        return questionTitle;
    }

    /**
     * Returns the value of the QuestionDescription property for this object.
     * 
     * @return The value of the QuestionDescription property for this object.
     */
    public final String questionDescription() {
        return questionDescription;
    }

    /**
     * Returns the value of the ImprovementPlanUrl property for this object.
     * 
     * @return The value of the ImprovementPlanUrl property for this object.
     */
    public final String improvementPlanUrl() {
        return improvementPlanUrl;
    }

    /**
     * Returns the value of the HelpfulResourceUrl property for this object.
     * 
     * @return The value of the HelpfulResourceUrl property for this object.
     */
    public final String helpfulResourceUrl() {
        return helpfulResourceUrl;
    }

    /**
     * <p>
     * The helpful resource text to be displayed for a custom lens.
     * </p>
     * <p>
     * This field does not apply to Amazon Web Services official lenses.
     * </p>
     * 
     * @return The helpful resource text to be displayed for a custom lens.</p>
     *         <p>
     *         This field does not apply to Amazon Web Services official lenses.
     */
    public final String helpfulResourceDisplayText() {
        return helpfulResourceDisplayText;
    }

    /**
     * For responses, this returns true if the service returned a value for the Choices property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasChoices() {
        return choices != null && !(choices instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Choices property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChoices} method.
     * </p>
     * 
     * @return The value of the Choices property for this object.
     */
    public final List<Choice> choices() {
        return choices;
    }

    /**
     * For responses, this returns true if the service returned a value for the SelectedChoices property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSelectedChoices() {
        return selectedChoices != null && !(selectedChoices instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the SelectedChoices property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSelectedChoices} method.
     * </p>
     * 
     * @return The value of the SelectedChoices property for this object.
     */
    public final List<String> selectedChoices() {
        return selectedChoices;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChoiceAnswers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasChoiceAnswers() {
        return choiceAnswers != null && !(choiceAnswers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of selected choices to a question in your workload.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChoiceAnswers} method.
     * </p>
     * 
     * @return A list of selected choices to a question in your workload.
     */
    public final List<ChoiceAnswer> choiceAnswers() {
        return choiceAnswers;
    }

    /**
     * Returns the value of the IsApplicable property for this object.
     * 
     * @return The value of the IsApplicable property for this object.
     */
    public final Boolean isApplicable() {
        return isApplicable;
    }

    /**
     * Returns the value of the Risk property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #risk} will return
     * {@link Risk#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #riskAsString}.
     * </p>
     * 
     * @return The value of the Risk property for this object.
     * @see Risk
     */
    public final Risk risk() {
        return Risk.fromValue(risk);
    }

    /**
     * Returns the value of the Risk property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #risk} will return
     * {@link Risk#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #riskAsString}.
     * </p>
     * 
     * @return The value of the Risk property for this object.
     * @see Risk
     */
    public final String riskAsString() {
        return risk;
    }

    /**
     * Returns the value of the Notes property for this object.
     * 
     * @return The value of the Notes property for this object.
     */
    public final String notes() {
        return notes;
    }

    /**
     * <p>
     * The reason why the question is not applicable to your workload.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link AnswerReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reasonAsString}.
     * </p>
     * 
     * @return The reason why the question is not applicable to your workload.
     * @see AnswerReason
     */
    public final AnswerReason reason() {
        return AnswerReason.fromValue(reason);
    }

    /**
     * <p>
     * The reason why the question is not applicable to your workload.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link AnswerReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reasonAsString}.
     * </p>
     * 
     * @return The reason why the question is not applicable to your workload.
     * @see AnswerReason
     */
    public final String reasonAsString() {
        return reason;
    }

    /**
     * <p>
     * Configuration of the Jira integration.
     * </p>
     * 
     * @return Configuration of the Jira integration.
     */
    public final JiraConfiguration jiraConfiguration() {
        return jiraConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(questionId());
        hashCode = 31 * hashCode + Objects.hashCode(pillarId());
        hashCode = 31 * hashCode + Objects.hashCode(questionTitle());
        hashCode = 31 * hashCode + Objects.hashCode(questionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(improvementPlanUrl());
        hashCode = 31 * hashCode + Objects.hashCode(helpfulResourceUrl());
        hashCode = 31 * hashCode + Objects.hashCode(helpfulResourceDisplayText());
        hashCode = 31 * hashCode + Objects.hashCode(hasChoices() ? choices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSelectedChoices() ? selectedChoices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasChoiceAnswers() ? choiceAnswers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isApplicable());
        hashCode = 31 * hashCode + Objects.hashCode(riskAsString());
        hashCode = 31 * hashCode + Objects.hashCode(notes());
        hashCode = 31 * hashCode + Objects.hashCode(reasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(jiraConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Answer)) {
            return false;
        }
        Answer other = (Answer) obj;
        return Objects.equals(questionId(), other.questionId()) && Objects.equals(pillarId(), other.pillarId())
                && Objects.equals(questionTitle(), other.questionTitle())
                && Objects.equals(questionDescription(), other.questionDescription())
                && Objects.equals(improvementPlanUrl(), other.improvementPlanUrl())
                && Objects.equals(helpfulResourceUrl(), other.helpfulResourceUrl())
                && Objects.equals(helpfulResourceDisplayText(), other.helpfulResourceDisplayText())
                && hasChoices() == other.hasChoices() && Objects.equals(choices(), other.choices())
                && hasSelectedChoices() == other.hasSelectedChoices()
                && Objects.equals(selectedChoices(), other.selectedChoices()) && hasChoiceAnswers() == other.hasChoiceAnswers()
                && Objects.equals(choiceAnswers(), other.choiceAnswers()) && Objects.equals(isApplicable(), other.isApplicable())
                && Objects.equals(riskAsString(), other.riskAsString()) && Objects.equals(notes(), other.notes())
                && Objects.equals(reasonAsString(), other.reasonAsString())
                && Objects.equals(jiraConfiguration(), other.jiraConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Answer").add("QuestionId", questionId()).add("PillarId", pillarId())
                .add("QuestionTitle", questionTitle()).add("QuestionDescription", questionDescription())
                .add("ImprovementPlanUrl", improvementPlanUrl()).add("HelpfulResourceUrl", helpfulResourceUrl())
                .add("HelpfulResourceDisplayText", helpfulResourceDisplayText()).add("Choices", hasChoices() ? choices() : null)
                .add("SelectedChoices", hasSelectedChoices() ? selectedChoices() : null)
                .add("ChoiceAnswers", hasChoiceAnswers() ? choiceAnswers() : null).add("IsApplicable", isApplicable())
                .add("Risk", riskAsString()).add("Notes", notes()).add("Reason", reasonAsString())
                .add("JiraConfiguration", jiraConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QuestionId":
            return Optional.ofNullable(clazz.cast(questionId()));
        case "PillarId":
            return Optional.ofNullable(clazz.cast(pillarId()));
        case "QuestionTitle":
            return Optional.ofNullable(clazz.cast(questionTitle()));
        case "QuestionDescription":
            return Optional.ofNullable(clazz.cast(questionDescription()));
        case "ImprovementPlanUrl":
            return Optional.ofNullable(clazz.cast(improvementPlanUrl()));
        case "HelpfulResourceUrl":
            return Optional.ofNullable(clazz.cast(helpfulResourceUrl()));
        case "HelpfulResourceDisplayText":
            return Optional.ofNullable(clazz.cast(helpfulResourceDisplayText()));
        case "Choices":
            return Optional.ofNullable(clazz.cast(choices()));
        case "SelectedChoices":
            return Optional.ofNullable(clazz.cast(selectedChoices()));
        case "ChoiceAnswers":
            return Optional.ofNullable(clazz.cast(choiceAnswers()));
        case "IsApplicable":
            return Optional.ofNullable(clazz.cast(isApplicable()));
        case "Risk":
            return Optional.ofNullable(clazz.cast(riskAsString()));
        case "Notes":
            return Optional.ofNullable(clazz.cast(notes()));
        case "Reason":
            return Optional.ofNullable(clazz.cast(reasonAsString()));
        case "JiraConfiguration":
            return Optional.ofNullable(clazz.cast(jiraConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("QuestionId", QUESTION_ID_FIELD);
        map.put("PillarId", PILLAR_ID_FIELD);
        map.put("QuestionTitle", QUESTION_TITLE_FIELD);
        map.put("QuestionDescription", QUESTION_DESCRIPTION_FIELD);
        map.put("ImprovementPlanUrl", IMPROVEMENT_PLAN_URL_FIELD);
        map.put("HelpfulResourceUrl", HELPFUL_RESOURCE_URL_FIELD);
        map.put("HelpfulResourceDisplayText", HELPFUL_RESOURCE_DISPLAY_TEXT_FIELD);
        map.put("Choices", CHOICES_FIELD);
        map.put("SelectedChoices", SELECTED_CHOICES_FIELD);
        map.put("ChoiceAnswers", CHOICE_ANSWERS_FIELD);
        map.put("IsApplicable", IS_APPLICABLE_FIELD);
        map.put("Risk", RISK_FIELD);
        map.put("Notes", NOTES_FIELD);
        map.put("Reason", REASON_FIELD);
        map.put("JiraConfiguration", JIRA_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Answer, T> g) {
        return obj -> g.apply((Answer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Answer> {
        /**
         * Sets the value of the QuestionId property for this object.
         *
         * @param questionId
         *        The new value for the QuestionId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder questionId(String questionId);

        /**
         * Sets the value of the PillarId property for this object.
         *
         * @param pillarId
         *        The new value for the PillarId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pillarId(String pillarId);

        /**
         * Sets the value of the QuestionTitle property for this object.
         *
         * @param questionTitle
         *        The new value for the QuestionTitle property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder questionTitle(String questionTitle);

        /**
         * Sets the value of the QuestionDescription property for this object.
         *
         * @param questionDescription
         *        The new value for the QuestionDescription property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder questionDescription(String questionDescription);

        /**
         * Sets the value of the ImprovementPlanUrl property for this object.
         *
         * @param improvementPlanUrl
         *        The new value for the ImprovementPlanUrl property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder improvementPlanUrl(String improvementPlanUrl);

        /**
         * Sets the value of the HelpfulResourceUrl property for this object.
         *
         * @param helpfulResourceUrl
         *        The new value for the HelpfulResourceUrl property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder helpfulResourceUrl(String helpfulResourceUrl);

        /**
         * <p>
         * The helpful resource text to be displayed for a custom lens.
         * </p>
         * <p>
         * This field does not apply to Amazon Web Services official lenses.
         * </p>
         * 
         * @param helpfulResourceDisplayText
         *        The helpful resource text to be displayed for a custom lens.</p>
         *        <p>
         *        This field does not apply to Amazon Web Services official lenses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder helpfulResourceDisplayText(String helpfulResourceDisplayText);

        /**
         * Sets the value of the Choices property for this object.
         *
         * @param choices
         *        The new value for the Choices property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder choices(Collection<Choice> choices);

        /**
         * Sets the value of the Choices property for this object.
         *
         * @param choices
         *        The new value for the Choices property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder choices(Choice... choices);

        /**
         * Sets the value of the Choices property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wellarchitected.model.Choice.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.wellarchitected.model.Choice#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wellarchitected.model.Choice.Builder#build()} is called immediately
         * and its result is passed to {@link #choices(List<Choice>)}.
         * 
         * @param choices
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wellarchitected.model.Choice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #choices(java.util.Collection<Choice>)
         */
        Builder choices(Consumer<Choice.Builder>... choices);

        /**
         * Sets the value of the SelectedChoices property for this object.
         *
         * @param selectedChoices
         *        The new value for the SelectedChoices property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedChoices(Collection<String> selectedChoices);

        /**
         * Sets the value of the SelectedChoices property for this object.
         *
         * @param selectedChoices
         *        The new value for the SelectedChoices property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedChoices(String... selectedChoices);

        /**
         * <p>
         * A list of selected choices to a question in your workload.
         * </p>
         * 
         * @param choiceAnswers
         *        A list of selected choices to a question in your workload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder choiceAnswers(Collection<ChoiceAnswer> choiceAnswers);

        /**
         * <p>
         * A list of selected choices to a question in your workload.
         * </p>
         * 
         * @param choiceAnswers
         *        A list of selected choices to a question in your workload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder choiceAnswers(ChoiceAnswer... choiceAnswers);

        /**
         * <p>
         * A list of selected choices to a question in your workload.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wellarchitected.model.ChoiceAnswer.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.wellarchitected.model.ChoiceAnswer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wellarchitected.model.ChoiceAnswer.Builder#build()} is called
         * immediately and its result is passed to {@link #choiceAnswers(List<ChoiceAnswer>)}.
         * 
         * @param choiceAnswers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wellarchitected.model.ChoiceAnswer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #choiceAnswers(java.util.Collection<ChoiceAnswer>)
         */
        Builder choiceAnswers(Consumer<ChoiceAnswer.Builder>... choiceAnswers);

        /**
         * Sets the value of the IsApplicable property for this object.
         *
         * @param isApplicable
         *        The new value for the IsApplicable property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isApplicable(Boolean isApplicable);

        /**
         * Sets the value of the Risk property for this object.
         *
         * @param risk
         *        The new value for the Risk property for this object.
         * @see Risk
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Risk
         */
        Builder risk(String risk);

        /**
         * Sets the value of the Risk property for this object.
         *
         * @param risk
         *        The new value for the Risk property for this object.
         * @see Risk
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Risk
         */
        Builder risk(Risk risk);

        /**
         * Sets the value of the Notes property for this object.
         *
         * @param notes
         *        The new value for the Notes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notes(String notes);

        /**
         * <p>
         * The reason why the question is not applicable to your workload.
         * </p>
         * 
         * @param reason
         *        The reason why the question is not applicable to your workload.
         * @see AnswerReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnswerReason
         */
        Builder reason(String reason);

        /**
         * <p>
         * The reason why the question is not applicable to your workload.
         * </p>
         * 
         * @param reason
         *        The reason why the question is not applicable to your workload.
         * @see AnswerReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnswerReason
         */
        Builder reason(AnswerReason reason);

        /**
         * <p>
         * Configuration of the Jira integration.
         * </p>
         * 
         * @param jiraConfiguration
         *        Configuration of the Jira integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jiraConfiguration(JiraConfiguration jiraConfiguration);

        /**
         * <p>
         * Configuration of the Jira integration.
         * </p>
         * This is a convenience method that creates an instance of the {@link JiraConfiguration.Builder} avoiding the
         * need to create one manually via {@link JiraConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JiraConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #jiraConfiguration(JiraConfiguration)}.
         * 
         * @param jiraConfiguration
         *        a consumer that will call methods on {@link JiraConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jiraConfiguration(JiraConfiguration)
         */
        default Builder jiraConfiguration(Consumer<JiraConfiguration.Builder> jiraConfiguration) {
            return jiraConfiguration(JiraConfiguration.builder().applyMutation(jiraConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String questionId;

        private String pillarId;

        private String questionTitle;

        private String questionDescription;

        private String improvementPlanUrl;

        private String helpfulResourceUrl;

        private String helpfulResourceDisplayText;

        private List<Choice> choices = DefaultSdkAutoConstructList.getInstance();

        private List<String> selectedChoices = DefaultSdkAutoConstructList.getInstance();

        private List<ChoiceAnswer> choiceAnswers = DefaultSdkAutoConstructList.getInstance();

        private Boolean isApplicable;

        private String risk;

        private String notes;

        private String reason;

        private JiraConfiguration jiraConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(Answer model) {
            questionId(model.questionId);
            pillarId(model.pillarId);
            questionTitle(model.questionTitle);
            questionDescription(model.questionDescription);
            improvementPlanUrl(model.improvementPlanUrl);
            helpfulResourceUrl(model.helpfulResourceUrl);
            helpfulResourceDisplayText(model.helpfulResourceDisplayText);
            choices(model.choices);
            selectedChoices(model.selectedChoices);
            choiceAnswers(model.choiceAnswers);
            isApplicable(model.isApplicable);
            risk(model.risk);
            notes(model.notes);
            reason(model.reason);
            jiraConfiguration(model.jiraConfiguration);
        }

        public final String getQuestionId() {
            return questionId;
        }

        public final void setQuestionId(String questionId) {
            this.questionId = questionId;
        }

        @Override
        public final Builder questionId(String questionId) {
            this.questionId = questionId;
            return this;
        }

        public final String getPillarId() {
            return pillarId;
        }

        public final void setPillarId(String pillarId) {
            this.pillarId = pillarId;
        }

        @Override
        public final Builder pillarId(String pillarId) {
            this.pillarId = pillarId;
            return this;
        }

        public final String getQuestionTitle() {
            return questionTitle;
        }

        public final void setQuestionTitle(String questionTitle) {
            this.questionTitle = questionTitle;
        }

        @Override
        public final Builder questionTitle(String questionTitle) {
            this.questionTitle = questionTitle;
            return this;
        }

        public final String getQuestionDescription() {
            return questionDescription;
        }

        public final void setQuestionDescription(String questionDescription) {
            this.questionDescription = questionDescription;
        }

        @Override
        public final Builder questionDescription(String questionDescription) {
            this.questionDescription = questionDescription;
            return this;
        }

        public final String getImprovementPlanUrl() {
            return improvementPlanUrl;
        }

        public final void setImprovementPlanUrl(String improvementPlanUrl) {
            this.improvementPlanUrl = improvementPlanUrl;
        }

        @Override
        public final Builder improvementPlanUrl(String improvementPlanUrl) {
            this.improvementPlanUrl = improvementPlanUrl;
            return this;
        }

        public final String getHelpfulResourceUrl() {
            return helpfulResourceUrl;
        }

        public final void setHelpfulResourceUrl(String helpfulResourceUrl) {
            this.helpfulResourceUrl = helpfulResourceUrl;
        }

        @Override
        public final Builder helpfulResourceUrl(String helpfulResourceUrl) {
            this.helpfulResourceUrl = helpfulResourceUrl;
            return this;
        }

        public final String getHelpfulResourceDisplayText() {
            return helpfulResourceDisplayText;
        }

        public final void setHelpfulResourceDisplayText(String helpfulResourceDisplayText) {
            this.helpfulResourceDisplayText = helpfulResourceDisplayText;
        }

        @Override
        public final Builder helpfulResourceDisplayText(String helpfulResourceDisplayText) {
            this.helpfulResourceDisplayText = helpfulResourceDisplayText;
            return this;
        }

        public final List<Choice.Builder> getChoices() {
            List<Choice.Builder> result = ChoicesCopier.copyToBuilder(this.choices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChoices(Collection<Choice.BuilderImpl> choices) {
            this.choices = ChoicesCopier.copyFromBuilder(choices);
        }

        @Override
        public final Builder choices(Collection<Choice> choices) {
            this.choices = ChoicesCopier.copy(choices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder choices(Choice... choices) {
            choices(Arrays.asList(choices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder choices(Consumer<Choice.Builder>... choices) {
            choices(Stream.of(choices).map(c -> Choice.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSelectedChoices() {
            if (selectedChoices instanceof SdkAutoConstructList) {
                return null;
            }
            return selectedChoices;
        }

        public final void setSelectedChoices(Collection<String> selectedChoices) {
            this.selectedChoices = SelectedChoicesCopier.copy(selectedChoices);
        }

        @Override
        public final Builder selectedChoices(Collection<String> selectedChoices) {
            this.selectedChoices = SelectedChoicesCopier.copy(selectedChoices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedChoices(String... selectedChoices) {
            selectedChoices(Arrays.asList(selectedChoices));
            return this;
        }

        public final List<ChoiceAnswer.Builder> getChoiceAnswers() {
            List<ChoiceAnswer.Builder> result = ChoiceAnswersCopier.copyToBuilder(this.choiceAnswers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChoiceAnswers(Collection<ChoiceAnswer.BuilderImpl> choiceAnswers) {
            this.choiceAnswers = ChoiceAnswersCopier.copyFromBuilder(choiceAnswers);
        }

        @Override
        public final Builder choiceAnswers(Collection<ChoiceAnswer> choiceAnswers) {
            this.choiceAnswers = ChoiceAnswersCopier.copy(choiceAnswers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder choiceAnswers(ChoiceAnswer... choiceAnswers) {
            choiceAnswers(Arrays.asList(choiceAnswers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder choiceAnswers(Consumer<ChoiceAnswer.Builder>... choiceAnswers) {
            choiceAnswers(Stream.of(choiceAnswers).map(c -> ChoiceAnswer.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIsApplicable() {
            return isApplicable;
        }

        public final void setIsApplicable(Boolean isApplicable) {
            this.isApplicable = isApplicable;
        }

        @Override
        public final Builder isApplicable(Boolean isApplicable) {
            this.isApplicable = isApplicable;
            return this;
        }

        public final String getRisk() {
            return risk;
        }

        public final void setRisk(String risk) {
            this.risk = risk;
        }

        @Override
        public final Builder risk(String risk) {
            this.risk = risk;
            return this;
        }

        @Override
        public final Builder risk(Risk risk) {
            this.risk(risk == null ? null : risk.toString());
            return this;
        }

        public final String getNotes() {
            return notes;
        }

        public final void setNotes(String notes) {
            this.notes = notes;
        }

        @Override
        public final Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(AnswerReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        public final JiraConfiguration.Builder getJiraConfiguration() {
            return jiraConfiguration != null ? jiraConfiguration.toBuilder() : null;
        }

        public final void setJiraConfiguration(JiraConfiguration.BuilderImpl jiraConfiguration) {
            this.jiraConfiguration = jiraConfiguration != null ? jiraConfiguration.build() : null;
        }

        @Override
        public final Builder jiraConfiguration(JiraConfiguration jiraConfiguration) {
            this.jiraConfiguration = jiraConfiguration;
            return this;
        }

        @Override
        public Answer build() {
            return new Answer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
