/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wellarchitected.model.ProfileChoice;
import software.amazon.awssdk.services.wellarchitected.model.ProfileQuestionChoicesCopier;
import software.amazon.awssdk.services.wellarchitected.model.SelectedChoiceIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProfileQuestion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProfileQuestion> {
    private static final SdkField<String> QUESTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuestionId").getter(ProfileQuestion.getter(ProfileQuestion::questionId)).setter(ProfileQuestion.setter(Builder::questionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionId").build()}).build();
    private static final SdkField<String> QUESTION_TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuestionTitle").getter(ProfileQuestion.getter(ProfileQuestion::questionTitle)).setter(ProfileQuestion.setter(Builder::questionTitle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionTitle").build()}).build();
    private static final SdkField<String> QUESTION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuestionDescription").getter(ProfileQuestion.getter(ProfileQuestion::questionDescription)).setter(ProfileQuestion.setter(Builder::questionDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionDescription").build()}).build();
    private static final SdkField<List<ProfileChoice>> QUESTION_CHOICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("QuestionChoices").getter(ProfileQuestion.getter(ProfileQuestion::questionChoices)).setter(ProfileQuestion.setter(Builder::questionChoices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionChoices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProfileChoice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SELECTED_CHOICE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SelectedChoiceIds").getter(ProfileQuestion.getter(ProfileQuestion::selectedChoiceIds)).setter(ProfileQuestion.setter(Builder::selectedChoiceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedChoiceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MIN_SELECTED_CHOICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinSelectedChoices").getter(ProfileQuestion.getter(ProfileQuestion::minSelectedChoices)).setter(ProfileQuestion.setter(Builder::minSelectedChoices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinSelectedChoices").build()}).build();
    private static final SdkField<Integer> MAX_SELECTED_CHOICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxSelectedChoices").getter(ProfileQuestion.getter(ProfileQuestion::maxSelectedChoices)).setter(ProfileQuestion.setter(Builder::maxSelectedChoices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSelectedChoices").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUESTION_ID_FIELD, QUESTION_TITLE_FIELD, QUESTION_DESCRIPTION_FIELD, QUESTION_CHOICES_FIELD, SELECTED_CHOICE_IDS_FIELD, MIN_SELECTED_CHOICES_FIELD, MAX_SELECTED_CHOICES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProfileQuestion.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String questionId;
    private final String questionTitle;
    private final String questionDescription;
    private final List<ProfileChoice> questionChoices;
    private final List<String> selectedChoiceIds;
    private final Integer minSelectedChoices;
    private final Integer maxSelectedChoices;

    private ProfileQuestion(BuilderImpl builder) {
        this.questionId = builder.questionId;
        this.questionTitle = builder.questionTitle;
        this.questionDescription = builder.questionDescription;
        this.questionChoices = builder.questionChoices;
        this.selectedChoiceIds = builder.selectedChoiceIds;
        this.minSelectedChoices = builder.minSelectedChoices;
        this.maxSelectedChoices = builder.maxSelectedChoices;
    }

    public final String questionId() {
        return this.questionId;
    }

    public final String questionTitle() {
        return this.questionTitle;
    }

    public final String questionDescription() {
        return this.questionDescription;
    }

    public final boolean hasQuestionChoices() {
        return this.questionChoices != null && !(this.questionChoices instanceof SdkAutoConstructList);
    }

    public final List<ProfileChoice> questionChoices() {
        return this.questionChoices;
    }

    public final boolean hasSelectedChoiceIds() {
        return this.selectedChoiceIds != null && !(this.selectedChoiceIds instanceof SdkAutoConstructList);
    }

    public final List<String> selectedChoiceIds() {
        return this.selectedChoiceIds;
    }

    public final Integer minSelectedChoices() {
        return this.minSelectedChoices;
    }

    public final Integer maxSelectedChoices() {
        return this.maxSelectedChoices;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.questionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.questionTitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.questionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQuestionChoices() ? this.questionChoices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSelectedChoiceIds() ? this.selectedChoiceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.minSelectedChoices());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxSelectedChoices());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProfileQuestion)) {
            return false;
        }
        ProfileQuestion other = (ProfileQuestion)obj;
        return Objects.equals(this.questionId(), other.questionId()) && Objects.equals(this.questionTitle(), other.questionTitle()) && Objects.equals(this.questionDescription(), other.questionDescription()) && this.hasQuestionChoices() == other.hasQuestionChoices() && Objects.equals(this.questionChoices(), other.questionChoices()) && this.hasSelectedChoiceIds() == other.hasSelectedChoiceIds() && Objects.equals(this.selectedChoiceIds(), other.selectedChoiceIds()) && Objects.equals(this.minSelectedChoices(), other.minSelectedChoices()) && Objects.equals(this.maxSelectedChoices(), other.maxSelectedChoices());
    }

    public final String toString() {
        return ToString.builder((String)"ProfileQuestion").add("QuestionId", (Object)this.questionId()).add("QuestionTitle", (Object)this.questionTitle()).add("QuestionDescription", (Object)this.questionDescription()).add("QuestionChoices", this.hasQuestionChoices() ? this.questionChoices() : null).add("SelectedChoiceIds", this.hasSelectedChoiceIds() ? this.selectedChoiceIds() : null).add("MinSelectedChoices", (Object)this.minSelectedChoices()).add("MaxSelectedChoices", (Object)this.maxSelectedChoices()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QuestionId": {
                return Optional.ofNullable(clazz.cast(this.questionId()));
            }
            case "QuestionTitle": {
                return Optional.ofNullable(clazz.cast(this.questionTitle()));
            }
            case "QuestionDescription": {
                return Optional.ofNullable(clazz.cast(this.questionDescription()));
            }
            case "QuestionChoices": {
                return Optional.ofNullable(clazz.cast(this.questionChoices()));
            }
            case "SelectedChoiceIds": {
                return Optional.ofNullable(clazz.cast(this.selectedChoiceIds()));
            }
            case "MinSelectedChoices": {
                return Optional.ofNullable(clazz.cast(this.minSelectedChoices()));
            }
            case "MaxSelectedChoices": {
                return Optional.ofNullable(clazz.cast(this.maxSelectedChoices()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("QuestionId", QUESTION_ID_FIELD);
        map.put("QuestionTitle", QUESTION_TITLE_FIELD);
        map.put("QuestionDescription", QUESTION_DESCRIPTION_FIELD);
        map.put("QuestionChoices", QUESTION_CHOICES_FIELD);
        map.put("SelectedChoiceIds", SELECTED_CHOICE_IDS_FIELD);
        map.put("MinSelectedChoices", MIN_SELECTED_CHOICES_FIELD);
        map.put("MaxSelectedChoices", MAX_SELECTED_CHOICES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProfileQuestion, T> g) {
        return obj -> g.apply((ProfileQuestion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String questionId;
        private String questionTitle;
        private String questionDescription;
        private List<ProfileChoice> questionChoices = DefaultSdkAutoConstructList.getInstance();
        private List<String> selectedChoiceIds = DefaultSdkAutoConstructList.getInstance();
        private Integer minSelectedChoices;
        private Integer maxSelectedChoices;

        private BuilderImpl() {
        }

        private BuilderImpl(ProfileQuestion model) {
            this.questionId(model.questionId);
            this.questionTitle(model.questionTitle);
            this.questionDescription(model.questionDescription);
            this.questionChoices(model.questionChoices);
            this.selectedChoiceIds(model.selectedChoiceIds);
            this.minSelectedChoices(model.minSelectedChoices);
            this.maxSelectedChoices(model.maxSelectedChoices);
        }

        public final String getQuestionId() {
            return this.questionId;
        }

        public final void setQuestionId(String questionId) {
            this.questionId = questionId;
        }

        @Override
        public final Builder questionId(String questionId) {
            this.questionId = questionId;
            return this;
        }

        public final String getQuestionTitle() {
            return this.questionTitle;
        }

        public final void setQuestionTitle(String questionTitle) {
            this.questionTitle = questionTitle;
        }

        @Override
        public final Builder questionTitle(String questionTitle) {
            this.questionTitle = questionTitle;
            return this;
        }

        public final String getQuestionDescription() {
            return this.questionDescription;
        }

        public final void setQuestionDescription(String questionDescription) {
            this.questionDescription = questionDescription;
        }

        @Override
        public final Builder questionDescription(String questionDescription) {
            this.questionDescription = questionDescription;
            return this;
        }

        public final List<ProfileChoice.Builder> getQuestionChoices() {
            List<ProfileChoice.Builder> result = ProfileQuestionChoicesCopier.copyToBuilder(this.questionChoices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQuestionChoices(Collection<ProfileChoice.BuilderImpl> questionChoices) {
            this.questionChoices = ProfileQuestionChoicesCopier.copyFromBuilder(questionChoices);
        }

        @Override
        public final Builder questionChoices(Collection<ProfileChoice> questionChoices) {
            this.questionChoices = ProfileQuestionChoicesCopier.copy(questionChoices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder questionChoices(ProfileChoice ... questionChoices) {
            this.questionChoices(Arrays.asList(questionChoices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder questionChoices(Consumer<ProfileChoice.Builder> ... questionChoices) {
            this.questionChoices(Stream.of(questionChoices).map(c -> (ProfileChoice)((ProfileChoice.Builder)ProfileChoice.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSelectedChoiceIds() {
            if (this.selectedChoiceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.selectedChoiceIds;
        }

        public final void setSelectedChoiceIds(Collection<String> selectedChoiceIds) {
            this.selectedChoiceIds = SelectedChoiceIdsCopier.copy(selectedChoiceIds);
        }

        @Override
        public final Builder selectedChoiceIds(Collection<String> selectedChoiceIds) {
            this.selectedChoiceIds = SelectedChoiceIdsCopier.copy(selectedChoiceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedChoiceIds(String ... selectedChoiceIds) {
            this.selectedChoiceIds(Arrays.asList(selectedChoiceIds));
            return this;
        }

        public final Integer getMinSelectedChoices() {
            return this.minSelectedChoices;
        }

        public final void setMinSelectedChoices(Integer minSelectedChoices) {
            this.minSelectedChoices = minSelectedChoices;
        }

        @Override
        public final Builder minSelectedChoices(Integer minSelectedChoices) {
            this.minSelectedChoices = minSelectedChoices;
            return this;
        }

        public final Integer getMaxSelectedChoices() {
            return this.maxSelectedChoices;
        }

        public final void setMaxSelectedChoices(Integer maxSelectedChoices) {
            this.maxSelectedChoices = maxSelectedChoices;
        }

        @Override
        public final Builder maxSelectedChoices(Integer maxSelectedChoices) {
            this.maxSelectedChoices = maxSelectedChoices;
            return this;
        }

        public ProfileQuestion build() {
            return new ProfileQuestion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProfileQuestion> {
        public Builder questionId(String var1);

        public Builder questionTitle(String var1);

        public Builder questionDescription(String var1);

        public Builder questionChoices(Collection<ProfileChoice> var1);

        public Builder questionChoices(ProfileChoice ... var1);

        public Builder questionChoices(Consumer<ProfileChoice.Builder> ... var1);

        public Builder selectedChoiceIds(Collection<String> var1);

        public Builder selectedChoiceIds(String ... var1);

        public Builder minSelectedChoices(Integer var1);

        public Builder maxSelectedChoices(Integer var1);
    }
}

