/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.wellarchitected.model.JiraSelectedQuestionConfiguration;
import software.amazon.awssdk.services.wellarchitected.model.LensStatus;
import software.amazon.awssdk.services.wellarchitected.model.PillarReviewSummariesCopier;
import software.amazon.awssdk.services.wellarchitected.model.PillarReviewSummary;
import software.amazon.awssdk.services.wellarchitected.model.Risk;
import software.amazon.awssdk.services.wellarchitected.model.RiskCountsCopier;
import software.amazon.awssdk.services.wellarchitected.model.WorkloadProfile;
import software.amazon.awssdk.services.wellarchitected.model.WorkloadProfilesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LensReview
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LensReview> {
    private static final SdkField<String> LENS_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensAlias").getter(LensReview.getter(LensReview::lensAlias)).setter(LensReview.setter(Builder::lensAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensAlias").build()}).build();
    private static final SdkField<String> LENS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensArn").getter(LensReview.getter(LensReview::lensArn)).setter(LensReview.setter(Builder::lensArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensArn").build()}).build();
    private static final SdkField<String> LENS_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensVersion").getter(LensReview.getter(LensReview::lensVersion)).setter(LensReview.setter(Builder::lensVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensVersion").build()}).build();
    private static final SdkField<String> LENS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensName").getter(LensReview.getter(LensReview::lensName)).setter(LensReview.setter(Builder::lensName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensName").build()}).build();
    private static final SdkField<String> LENS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensStatus").getter(LensReview.getter(LensReview::lensStatusAsString)).setter(LensReview.setter(Builder::lensStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensStatus").build()}).build();
    private static final SdkField<List<PillarReviewSummary>> PILLAR_REVIEW_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PillarReviewSummaries").getter(LensReview.getter(LensReview::pillarReviewSummaries)).setter(LensReview.setter(Builder::pillarReviewSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PillarReviewSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PillarReviewSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<JiraSelectedQuestionConfiguration> JIRA_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JiraConfiguration").getter(LensReview.getter(LensReview::jiraConfiguration)).setter(LensReview.setter(Builder::jiraConfiguration)).constructor(JiraSelectedQuestionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JiraConfiguration").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(LensReview.getter(LensReview::updatedAt)).setter(LensReview.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final SdkField<String> NOTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Notes").getter(LensReview.getter(LensReview::notes)).setter(LensReview.setter(Builder::notes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build()}).build();
    private static final SdkField<Map<String, Integer>> RISK_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("RiskCounts").getter(LensReview.getter(LensReview::riskCountsAsStrings)).setter(LensReview.setter(Builder::riskCountsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RiskCounts").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(LensReview.getter(LensReview::nextToken)).setter(LensReview.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<WorkloadProfile>> PROFILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Profiles").getter(LensReview.getter(LensReview::profiles)).setter(LensReview.setter(Builder::profiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Profiles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkloadProfile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, Integer>> PRIORITIZED_RISK_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("PrioritizedRiskCounts").getter(LensReview.getter(LensReview::prioritizedRiskCountsAsStrings)).setter(LensReview.setter(Builder::prioritizedRiskCountsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrioritizedRiskCounts").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LENS_ALIAS_FIELD, LENS_ARN_FIELD, LENS_VERSION_FIELD, LENS_NAME_FIELD, LENS_STATUS_FIELD, PILLAR_REVIEW_SUMMARIES_FIELD, JIRA_CONFIGURATION_FIELD, UPDATED_AT_FIELD, NOTES_FIELD, RISK_COUNTS_FIELD, NEXT_TOKEN_FIELD, PROFILES_FIELD, PRIORITIZED_RISK_COUNTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LensReview.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String lensAlias;
    private final String lensArn;
    private final String lensVersion;
    private final String lensName;
    private final String lensStatus;
    private final List<PillarReviewSummary> pillarReviewSummaries;
    private final JiraSelectedQuestionConfiguration jiraConfiguration;
    private final Instant updatedAt;
    private final String notes;
    private final Map<String, Integer> riskCounts;
    private final String nextToken;
    private final List<WorkloadProfile> profiles;
    private final Map<String, Integer> prioritizedRiskCounts;

    private LensReview(BuilderImpl builder) {
        this.lensAlias = builder.lensAlias;
        this.lensArn = builder.lensArn;
        this.lensVersion = builder.lensVersion;
        this.lensName = builder.lensName;
        this.lensStatus = builder.lensStatus;
        this.pillarReviewSummaries = builder.pillarReviewSummaries;
        this.jiraConfiguration = builder.jiraConfiguration;
        this.updatedAt = builder.updatedAt;
        this.notes = builder.notes;
        this.riskCounts = builder.riskCounts;
        this.nextToken = builder.nextToken;
        this.profiles = builder.profiles;
        this.prioritizedRiskCounts = builder.prioritizedRiskCounts;
    }

    public final String lensAlias() {
        return this.lensAlias;
    }

    public final String lensArn() {
        return this.lensArn;
    }

    public final String lensVersion() {
        return this.lensVersion;
    }

    public final String lensName() {
        return this.lensName;
    }

    public final LensStatus lensStatus() {
        return LensStatus.fromValue(this.lensStatus);
    }

    public final String lensStatusAsString() {
        return this.lensStatus;
    }

    public final boolean hasPillarReviewSummaries() {
        return this.pillarReviewSummaries != null && !(this.pillarReviewSummaries instanceof SdkAutoConstructList);
    }

    public final List<PillarReviewSummary> pillarReviewSummaries() {
        return this.pillarReviewSummaries;
    }

    public final JiraSelectedQuestionConfiguration jiraConfiguration() {
        return this.jiraConfiguration;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String notes() {
        return this.notes;
    }

    public final Map<Risk, Integer> riskCounts() {
        return RiskCountsCopier.copyStringToEnum(this.riskCounts);
    }

    public final boolean hasRiskCounts() {
        return this.riskCounts != null && !(this.riskCounts instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> riskCountsAsStrings() {
        return this.riskCounts;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasProfiles() {
        return this.profiles != null && !(this.profiles instanceof SdkAutoConstructList);
    }

    public final List<WorkloadProfile> profiles() {
        return this.profiles;
    }

    public final Map<Risk, Integer> prioritizedRiskCounts() {
        return RiskCountsCopier.copyStringToEnum(this.prioritizedRiskCounts);
    }

    public final boolean hasPrioritizedRiskCounts() {
        return this.prioritizedRiskCounts != null && !(this.prioritizedRiskCounts instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> prioritizedRiskCountsAsStrings() {
        return this.prioritizedRiskCounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lensAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPillarReviewSummaries() ? this.pillarReviewSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.jiraConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.notes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRiskCounts() ? this.riskCountsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProfiles() ? this.profiles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrioritizedRiskCounts() ? this.prioritizedRiskCountsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LensReview)) {
            return false;
        }
        LensReview other = (LensReview)obj;
        return Objects.equals(this.lensAlias(), other.lensAlias()) && Objects.equals(this.lensArn(), other.lensArn()) && Objects.equals(this.lensVersion(), other.lensVersion()) && Objects.equals(this.lensName(), other.lensName()) && Objects.equals(this.lensStatusAsString(), other.lensStatusAsString()) && this.hasPillarReviewSummaries() == other.hasPillarReviewSummaries() && Objects.equals(this.pillarReviewSummaries(), other.pillarReviewSummaries()) && Objects.equals(this.jiraConfiguration(), other.jiraConfiguration()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.notes(), other.notes()) && this.hasRiskCounts() == other.hasRiskCounts() && Objects.equals(this.riskCountsAsStrings(), other.riskCountsAsStrings()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasProfiles() == other.hasProfiles() && Objects.equals(this.profiles(), other.profiles()) && this.hasPrioritizedRiskCounts() == other.hasPrioritizedRiskCounts() && Objects.equals(this.prioritizedRiskCountsAsStrings(), other.prioritizedRiskCountsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"LensReview").add("LensAlias", (Object)this.lensAlias()).add("LensArn", (Object)this.lensArn()).add("LensVersion", (Object)this.lensVersion()).add("LensName", (Object)this.lensName()).add("LensStatus", (Object)this.lensStatusAsString()).add("PillarReviewSummaries", this.hasPillarReviewSummaries() ? this.pillarReviewSummaries() : null).add("JiraConfiguration", (Object)this.jiraConfiguration()).add("UpdatedAt", (Object)this.updatedAt()).add("Notes", (Object)this.notes()).add("RiskCounts", this.hasRiskCounts() ? this.riskCountsAsStrings() : null).add("NextToken", (Object)this.nextToken()).add("Profiles", this.hasProfiles() ? this.profiles() : null).add("PrioritizedRiskCounts", this.hasPrioritizedRiskCounts() ? this.prioritizedRiskCountsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LensAlias": {
                return Optional.ofNullable(clazz.cast(this.lensAlias()));
            }
            case "LensArn": {
                return Optional.ofNullable(clazz.cast(this.lensArn()));
            }
            case "LensVersion": {
                return Optional.ofNullable(clazz.cast(this.lensVersion()));
            }
            case "LensName": {
                return Optional.ofNullable(clazz.cast(this.lensName()));
            }
            case "LensStatus": {
                return Optional.ofNullable(clazz.cast(this.lensStatusAsString()));
            }
            case "PillarReviewSummaries": {
                return Optional.ofNullable(clazz.cast(this.pillarReviewSummaries()));
            }
            case "JiraConfiguration": {
                return Optional.ofNullable(clazz.cast(this.jiraConfiguration()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "Notes": {
                return Optional.ofNullable(clazz.cast(this.notes()));
            }
            case "RiskCounts": {
                return Optional.ofNullable(clazz.cast(this.riskCountsAsStrings()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Profiles": {
                return Optional.ofNullable(clazz.cast(this.profiles()));
            }
            case "PrioritizedRiskCounts": {
                return Optional.ofNullable(clazz.cast(this.prioritizedRiskCountsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LensAlias", LENS_ALIAS_FIELD);
        map.put("LensArn", LENS_ARN_FIELD);
        map.put("LensVersion", LENS_VERSION_FIELD);
        map.put("LensName", LENS_NAME_FIELD);
        map.put("LensStatus", LENS_STATUS_FIELD);
        map.put("PillarReviewSummaries", PILLAR_REVIEW_SUMMARIES_FIELD);
        map.put("JiraConfiguration", JIRA_CONFIGURATION_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        map.put("Notes", NOTES_FIELD);
        map.put("RiskCounts", RISK_COUNTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Profiles", PROFILES_FIELD);
        map.put("PrioritizedRiskCounts", PRIORITIZED_RISK_COUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LensReview, T> g) {
        return obj -> g.apply((LensReview)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String lensAlias;
        private String lensArn;
        private String lensVersion;
        private String lensName;
        private String lensStatus;
        private List<PillarReviewSummary> pillarReviewSummaries = DefaultSdkAutoConstructList.getInstance();
        private JiraSelectedQuestionConfiguration jiraConfiguration;
        private Instant updatedAt;
        private String notes;
        private Map<String, Integer> riskCounts = DefaultSdkAutoConstructMap.getInstance();
        private String nextToken;
        private List<WorkloadProfile> profiles = DefaultSdkAutoConstructList.getInstance();
        private Map<String, Integer> prioritizedRiskCounts = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LensReview model) {
            this.lensAlias(model.lensAlias);
            this.lensArn(model.lensArn);
            this.lensVersion(model.lensVersion);
            this.lensName(model.lensName);
            this.lensStatus(model.lensStatus);
            this.pillarReviewSummaries(model.pillarReviewSummaries);
            this.jiraConfiguration(model.jiraConfiguration);
            this.updatedAt(model.updatedAt);
            this.notes(model.notes);
            this.riskCountsWithStrings(model.riskCounts);
            this.nextToken(model.nextToken);
            this.profiles(model.profiles);
            this.prioritizedRiskCountsWithStrings(model.prioritizedRiskCounts);
        }

        public final String getLensAlias() {
            return this.lensAlias;
        }

        public final void setLensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
        }

        @Override
        public final Builder lensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
            return this;
        }

        public final String getLensArn() {
            return this.lensArn;
        }

        public final void setLensArn(String lensArn) {
            this.lensArn = lensArn;
        }

        @Override
        public final Builder lensArn(String lensArn) {
            this.lensArn = lensArn;
            return this;
        }

        public final String getLensVersion() {
            return this.lensVersion;
        }

        public final void setLensVersion(String lensVersion) {
            this.lensVersion = lensVersion;
        }

        @Override
        public final Builder lensVersion(String lensVersion) {
            this.lensVersion = lensVersion;
            return this;
        }

        public final String getLensName() {
            return this.lensName;
        }

        public final void setLensName(String lensName) {
            this.lensName = lensName;
        }

        @Override
        public final Builder lensName(String lensName) {
            this.lensName = lensName;
            return this;
        }

        public final String getLensStatus() {
            return this.lensStatus;
        }

        public final void setLensStatus(String lensStatus) {
            this.lensStatus = lensStatus;
        }

        @Override
        public final Builder lensStatus(String lensStatus) {
            this.lensStatus = lensStatus;
            return this;
        }

        @Override
        public final Builder lensStatus(LensStatus lensStatus) {
            this.lensStatus(lensStatus == null ? null : lensStatus.toString());
            return this;
        }

        public final List<PillarReviewSummary.Builder> getPillarReviewSummaries() {
            List<PillarReviewSummary.Builder> result = PillarReviewSummariesCopier.copyToBuilder(this.pillarReviewSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPillarReviewSummaries(Collection<PillarReviewSummary.BuilderImpl> pillarReviewSummaries) {
            this.pillarReviewSummaries = PillarReviewSummariesCopier.copyFromBuilder(pillarReviewSummaries);
        }

        @Override
        public final Builder pillarReviewSummaries(Collection<PillarReviewSummary> pillarReviewSummaries) {
            this.pillarReviewSummaries = PillarReviewSummariesCopier.copy(pillarReviewSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pillarReviewSummaries(PillarReviewSummary ... pillarReviewSummaries) {
            this.pillarReviewSummaries(Arrays.asList(pillarReviewSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pillarReviewSummaries(Consumer<PillarReviewSummary.Builder> ... pillarReviewSummaries) {
            this.pillarReviewSummaries(Stream.of(pillarReviewSummaries).map(c -> (PillarReviewSummary)((PillarReviewSummary.Builder)PillarReviewSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final JiraSelectedQuestionConfiguration.Builder getJiraConfiguration() {
            return this.jiraConfiguration != null ? this.jiraConfiguration.toBuilder() : null;
        }

        public final void setJiraConfiguration(JiraSelectedQuestionConfiguration.BuilderImpl jiraConfiguration) {
            this.jiraConfiguration = jiraConfiguration != null ? jiraConfiguration.build() : null;
        }

        @Override
        public final Builder jiraConfiguration(JiraSelectedQuestionConfiguration jiraConfiguration) {
            this.jiraConfiguration = jiraConfiguration;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getNotes() {
            return this.notes;
        }

        public final void setNotes(String notes) {
            this.notes = notes;
        }

        @Override
        public final Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public final Map<String, Integer> getRiskCounts() {
            if (this.riskCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.riskCounts;
        }

        public final void setRiskCounts(Map<String, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copy(riskCounts);
        }

        @Override
        public final Builder riskCountsWithStrings(Map<String, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copy(riskCounts);
            return this;
        }

        @Override
        public final Builder riskCounts(Map<Risk, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copyEnumToString(riskCounts);
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<WorkloadProfile.Builder> getProfiles() {
            List<WorkloadProfile.Builder> result = WorkloadProfilesCopier.copyToBuilder(this.profiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProfiles(Collection<WorkloadProfile.BuilderImpl> profiles) {
            this.profiles = WorkloadProfilesCopier.copyFromBuilder(profiles);
        }

        @Override
        public final Builder profiles(Collection<WorkloadProfile> profiles) {
            this.profiles = WorkloadProfilesCopier.copy(profiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profiles(WorkloadProfile ... profiles) {
            this.profiles(Arrays.asList(profiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profiles(Consumer<WorkloadProfile.Builder> ... profiles) {
            this.profiles(Stream.of(profiles).map(c -> (WorkloadProfile)((WorkloadProfile.Builder)WorkloadProfile.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, Integer> getPrioritizedRiskCounts() {
            if (this.prioritizedRiskCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.prioritizedRiskCounts;
        }

        public final void setPrioritizedRiskCounts(Map<String, Integer> prioritizedRiskCounts) {
            this.prioritizedRiskCounts = RiskCountsCopier.copy(prioritizedRiskCounts);
        }

        @Override
        public final Builder prioritizedRiskCountsWithStrings(Map<String, Integer> prioritizedRiskCounts) {
            this.prioritizedRiskCounts = RiskCountsCopier.copy(prioritizedRiskCounts);
            return this;
        }

        @Override
        public final Builder prioritizedRiskCounts(Map<Risk, Integer> prioritizedRiskCounts) {
            this.prioritizedRiskCounts = RiskCountsCopier.copyEnumToString(prioritizedRiskCounts);
            return this;
        }

        public LensReview build() {
            return new LensReview(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LensReview> {
        public Builder lensAlias(String var1);

        public Builder lensArn(String var1);

        public Builder lensVersion(String var1);

        public Builder lensName(String var1);

        public Builder lensStatus(String var1);

        public Builder lensStatus(LensStatus var1);

        public Builder pillarReviewSummaries(Collection<PillarReviewSummary> var1);

        public Builder pillarReviewSummaries(PillarReviewSummary ... var1);

        public Builder pillarReviewSummaries(Consumer<PillarReviewSummary.Builder> ... var1);

        public Builder jiraConfiguration(JiraSelectedQuestionConfiguration var1);

        default public Builder jiraConfiguration(Consumer<JiraSelectedQuestionConfiguration.Builder> jiraConfiguration) {
            return this.jiraConfiguration((JiraSelectedQuestionConfiguration)((JiraSelectedQuestionConfiguration.Builder)JiraSelectedQuestionConfiguration.builder().applyMutation(jiraConfiguration)).build());
        }

        public Builder updatedAt(Instant var1);

        public Builder notes(String var1);

        public Builder riskCountsWithStrings(Map<String, Integer> var1);

        public Builder riskCounts(Map<Risk, Integer> var1);

        public Builder nextToken(String var1);

        public Builder profiles(Collection<WorkloadProfile> var1);

        public Builder profiles(WorkloadProfile ... var1);

        public Builder profiles(Consumer<WorkloadProfile.Builder> ... var1);

        public Builder prioritizedRiskCountsWithStrings(Map<String, Integer> var1);

        public Builder prioritizedRiskCounts(Map<Risk, Integer> var1);
    }
}

