/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateGlobalSettingsRequest extends WellArchitectedRequest implements
        ToCopyableBuilder<UpdateGlobalSettingsRequest.Builder, UpdateGlobalSettingsRequest> {
    private static final SdkField<String> ORGANIZATION_SHARING_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationSharingStatus")
            .getter(getter(UpdateGlobalSettingsRequest::organizationSharingStatusAsString))
            .setter(setter(Builder::organizationSharingStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationSharingStatus").build())
            .build();

    private static final SdkField<String> DISCOVERY_INTEGRATION_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DiscoveryIntegrationStatus")
            .getter(getter(UpdateGlobalSettingsRequest::discoveryIntegrationStatusAsString))
            .setter(setter(Builder::discoveryIntegrationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscoveryIntegrationStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ORGANIZATION_SHARING_STATUS_FIELD, DISCOVERY_INTEGRATION_STATUS_FIELD));

    private final String organizationSharingStatus;

    private final String discoveryIntegrationStatus;

    private UpdateGlobalSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.organizationSharingStatus = builder.organizationSharingStatus;
        this.discoveryIntegrationStatus = builder.discoveryIntegrationStatus;
    }

    /**
     * <p>
     * The status of organization sharing settings.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #organizationSharingStatus} will return {@link OrganizationSharingStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #organizationSharingStatusAsString}.
     * </p>
     * 
     * @return The status of organization sharing settings.
     * @see OrganizationSharingStatus
     */
    public final OrganizationSharingStatus organizationSharingStatus() {
        return OrganizationSharingStatus.fromValue(organizationSharingStatus);
    }

    /**
     * <p>
     * The status of organization sharing settings.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #organizationSharingStatus} will return {@link OrganizationSharingStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #organizationSharingStatusAsString}.
     * </p>
     * 
     * @return The status of organization sharing settings.
     * @see OrganizationSharingStatus
     */
    public final String organizationSharingStatusAsString() {
        return organizationSharingStatus;
    }

    /**
     * <p>
     * The status of discovery support settings.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #discoveryIntegrationStatus} will return {@link DiscoveryIntegrationStatus#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #discoveryIntegrationStatusAsString}.
     * </p>
     * 
     * @return The status of discovery support settings.
     * @see DiscoveryIntegrationStatus
     */
    public final DiscoveryIntegrationStatus discoveryIntegrationStatus() {
        return DiscoveryIntegrationStatus.fromValue(discoveryIntegrationStatus);
    }

    /**
     * <p>
     * The status of discovery support settings.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #discoveryIntegrationStatus} will return {@link DiscoveryIntegrationStatus#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #discoveryIntegrationStatusAsString}.
     * </p>
     * 
     * @return The status of discovery support settings.
     * @see DiscoveryIntegrationStatus
     */
    public final String discoveryIntegrationStatusAsString() {
        return discoveryIntegrationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(organizationSharingStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(discoveryIntegrationStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGlobalSettingsRequest)) {
            return false;
        }
        UpdateGlobalSettingsRequest other = (UpdateGlobalSettingsRequest) obj;
        return Objects.equals(organizationSharingStatusAsString(), other.organizationSharingStatusAsString())
                && Objects.equals(discoveryIntegrationStatusAsString(), other.discoveryIntegrationStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateGlobalSettingsRequest")
                .add("OrganizationSharingStatus", organizationSharingStatusAsString())
                .add("DiscoveryIntegrationStatus", discoveryIntegrationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationSharingStatus":
            return Optional.ofNullable(clazz.cast(organizationSharingStatusAsString()));
        case "DiscoveryIntegrationStatus":
            return Optional.ofNullable(clazz.cast(discoveryIntegrationStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateGlobalSettingsRequest, T> g) {
        return obj -> g.apply((UpdateGlobalSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WellArchitectedRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateGlobalSettingsRequest> {
        /**
         * <p>
         * The status of organization sharing settings.
         * </p>
         * 
         * @param organizationSharingStatus
         *        The status of organization sharing settings.
         * @see OrganizationSharingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrganizationSharingStatus
         */
        Builder organizationSharingStatus(String organizationSharingStatus);

        /**
         * <p>
         * The status of organization sharing settings.
         * </p>
         * 
         * @param organizationSharingStatus
         *        The status of organization sharing settings.
         * @see OrganizationSharingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrganizationSharingStatus
         */
        Builder organizationSharingStatus(OrganizationSharingStatus organizationSharingStatus);

        /**
         * <p>
         * The status of discovery support settings.
         * </p>
         * 
         * @param discoveryIntegrationStatus
         *        The status of discovery support settings.
         * @see DiscoveryIntegrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiscoveryIntegrationStatus
         */
        Builder discoveryIntegrationStatus(String discoveryIntegrationStatus);

        /**
         * <p>
         * The status of discovery support settings.
         * </p>
         * 
         * @param discoveryIntegrationStatus
         *        The status of discovery support settings.
         * @see DiscoveryIntegrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiscoveryIntegrationStatus
         */
        Builder discoveryIntegrationStatus(DiscoveryIntegrationStatus discoveryIntegrationStatus);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WellArchitectedRequest.BuilderImpl implements Builder {
        private String organizationSharingStatus;

        private String discoveryIntegrationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGlobalSettingsRequest model) {
            super(model);
            organizationSharingStatus(model.organizationSharingStatus);
            discoveryIntegrationStatus(model.discoveryIntegrationStatus);
        }

        public final String getOrganizationSharingStatus() {
            return organizationSharingStatus;
        }

        public final void setOrganizationSharingStatus(String organizationSharingStatus) {
            this.organizationSharingStatus = organizationSharingStatus;
        }

        @Override
        public final Builder organizationSharingStatus(String organizationSharingStatus) {
            this.organizationSharingStatus = organizationSharingStatus;
            return this;
        }

        @Override
        public final Builder organizationSharingStatus(OrganizationSharingStatus organizationSharingStatus) {
            this.organizationSharingStatus(organizationSharingStatus == null ? null : organizationSharingStatus.toString());
            return this;
        }

        public final String getDiscoveryIntegrationStatus() {
            return discoveryIntegrationStatus;
        }

        public final void setDiscoveryIntegrationStatus(String discoveryIntegrationStatus) {
            this.discoveryIntegrationStatus = discoveryIntegrationStatus;
        }

        @Override
        public final Builder discoveryIntegrationStatus(String discoveryIntegrationStatus) {
            this.discoveryIntegrationStatus = discoveryIntegrationStatus;
            return this;
        }

        @Override
        public final Builder discoveryIntegrationStatus(DiscoveryIntegrationStatus discoveryIntegrationStatus) {
            this.discoveryIntegrationStatus(discoveryIntegrationStatus == null ? null : discoveryIntegrationStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGlobalSettingsRequest build() {
            return new UpdateGlobalSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
