/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A metric for a particular pillar in a lens.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PillarMetric implements SdkPojo, Serializable, ToCopyableBuilder<PillarMetric.Builder, PillarMetric> {
    private static final SdkField<String> PILLAR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PillarId").getter(getter(PillarMetric::pillarId)).setter(setter(Builder::pillarId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PillarId").build()).build();

    private static final SdkField<Map<String, Integer>> RISK_COUNTS_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("RiskCounts")
            .getter(getter(PillarMetric::riskCountsAsStrings))
            .setter(setter(Builder::riskCountsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RiskCounts").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<QuestionMetric>> QUESTIONS_FIELD = SdkField
            .<List<QuestionMetric>> builder(MarshallingType.LIST)
            .memberName("Questions")
            .getter(getter(PillarMetric::questions))
            .setter(setter(Builder::questions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Questions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<QuestionMetric> builder(MarshallingType.SDK_POJO)
                                            .constructor(QuestionMetric::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PILLAR_ID_FIELD,
            RISK_COUNTS_FIELD, QUESTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String pillarId;

    private final Map<String, Integer> riskCounts;

    private final List<QuestionMetric> questions;

    private PillarMetric(BuilderImpl builder) {
        this.pillarId = builder.pillarId;
        this.riskCounts = builder.riskCounts;
        this.questions = builder.questions;
    }

    /**
     * Returns the value of the PillarId property for this object.
     * 
     * @return The value of the PillarId property for this object.
     */
    public final String pillarId() {
        return pillarId;
    }

    /**
     * Returns the value of the RiskCounts property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRiskCounts} method.
     * </p>
     * 
     * @return The value of the RiskCounts property for this object.
     */
    public final Map<Risk, Integer> riskCounts() {
        return RiskCountsCopier.copyStringToEnum(riskCounts);
    }

    /**
     * For responses, this returns true if the service returned a value for the RiskCounts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRiskCounts() {
        return riskCounts != null && !(riskCounts instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the RiskCounts property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRiskCounts} method.
     * </p>
     * 
     * @return The value of the RiskCounts property for this object.
     */
    public final Map<String, Integer> riskCountsAsStrings() {
        return riskCounts;
    }

    /**
     * For responses, this returns true if the service returned a value for the Questions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasQuestions() {
        return questions != null && !(questions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The questions that have been identified as risks in the pillar.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQuestions} method.
     * </p>
     * 
     * @return The questions that have been identified as risks in the pillar.
     */
    public final List<QuestionMetric> questions() {
        return questions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pillarId());
        hashCode = 31 * hashCode + Objects.hashCode(hasRiskCounts() ? riskCountsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasQuestions() ? questions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PillarMetric)) {
            return false;
        }
        PillarMetric other = (PillarMetric) obj;
        return Objects.equals(pillarId(), other.pillarId()) && hasRiskCounts() == other.hasRiskCounts()
                && Objects.equals(riskCountsAsStrings(), other.riskCountsAsStrings()) && hasQuestions() == other.hasQuestions()
                && Objects.equals(questions(), other.questions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PillarMetric").add("PillarId", pillarId())
                .add("RiskCounts", hasRiskCounts() ? riskCountsAsStrings() : null)
                .add("Questions", hasQuestions() ? questions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PillarId":
            return Optional.ofNullable(clazz.cast(pillarId()));
        case "RiskCounts":
            return Optional.ofNullable(clazz.cast(riskCountsAsStrings()));
        case "Questions":
            return Optional.ofNullable(clazz.cast(questions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PillarMetric, T> g) {
        return obj -> g.apply((PillarMetric) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PillarMetric> {
        /**
         * Sets the value of the PillarId property for this object.
         *
         * @param pillarId
         *        The new value for the PillarId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pillarId(String pillarId);

        /**
         * Sets the value of the RiskCounts property for this object.
         *
         * @param riskCounts
         *        The new value for the RiskCounts property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder riskCountsWithStrings(Map<String, Integer> riskCounts);

        /**
         * Sets the value of the RiskCounts property for this object.
         *
         * @param riskCounts
         *        The new value for the RiskCounts property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder riskCounts(Map<Risk, Integer> riskCounts);

        /**
         * <p>
         * The questions that have been identified as risks in the pillar.
         * </p>
         * 
         * @param questions
         *        The questions that have been identified as risks in the pillar.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder questions(Collection<QuestionMetric> questions);

        /**
         * <p>
         * The questions that have been identified as risks in the pillar.
         * </p>
         * 
         * @param questions
         *        The questions that have been identified as risks in the pillar.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder questions(QuestionMetric... questions);

        /**
         * <p>
         * The questions that have been identified as risks in the pillar.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wellarchitected.model.QuestionMetric.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.wellarchitected.model.QuestionMetric#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wellarchitected.model.QuestionMetric.Builder#build()} is called
         * immediately and its result is passed to {@link #questions(List<QuestionMetric>)}.
         * 
         * @param questions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wellarchitected.model.QuestionMetric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #questions(java.util.Collection<QuestionMetric>)
         */
        Builder questions(Consumer<QuestionMetric.Builder>... questions);
    }

    static final class BuilderImpl implements Builder {
        private String pillarId;

        private Map<String, Integer> riskCounts = DefaultSdkAutoConstructMap.getInstance();

        private List<QuestionMetric> questions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PillarMetric model) {
            pillarId(model.pillarId);
            riskCountsWithStrings(model.riskCounts);
            questions(model.questions);
        }

        public final String getPillarId() {
            return pillarId;
        }

        public final void setPillarId(String pillarId) {
            this.pillarId = pillarId;
        }

        @Override
        public final Builder pillarId(String pillarId) {
            this.pillarId = pillarId;
            return this;
        }

        public final Map<String, Integer> getRiskCounts() {
            if (riskCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return riskCounts;
        }

        public final void setRiskCounts(Map<String, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copy(riskCounts);
        }

        @Override
        public final Builder riskCountsWithStrings(Map<String, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copy(riskCounts);
            return this;
        }

        @Override
        public final Builder riskCounts(Map<Risk, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copyEnumToString(riskCounts);
            return this;
        }

        public final List<QuestionMetric.Builder> getQuestions() {
            List<QuestionMetric.Builder> result = QuestionMetricsCopier.copyToBuilder(this.questions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQuestions(Collection<QuestionMetric.BuilderImpl> questions) {
            this.questions = QuestionMetricsCopier.copyFromBuilder(questions);
        }

        @Override
        public final Builder questions(Collection<QuestionMetric> questions) {
            this.questions = QuestionMetricsCopier.copy(questions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder questions(QuestionMetric... questions) {
            questions(Arrays.asList(questions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder questions(Consumer<QuestionMetric.Builder>... questions) {
            questions(Stream.of(questions).map(c -> QuestionMetric.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public PillarMetric build() {
            return new PillarMetric(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
